/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.PrototypeCellProvider;

public class ListDataItemCellRenderer
extends DefaultListCellRenderer
implements PrototypeCellProvider {
    public ListDataItemCellRenderer() {
        this.setIconTextGap(8);
    }

    public Dimension getPreferredSize() {
        EditorProperties properties = EditorProperties.getProperties();
        int maxWidth = properties.getIntegerProperty("insight-max-popup-width");
        Dimension screenSize = this.getToolkit().getScreenSize();
        maxWidth = Math.min(screenSize.width / 2 - 5, maxWidth);
        Dimension size = super.getPreferredSize();
        Dimension newSize = new Dimension(Math.min(maxWidth, size.width), size.height);
        return newSize;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        JLabel label = (JLabel)component;
        if (value instanceof ListDataItem) {
            ListDataItem dataItem = (ListDataItem)value;
            String displayText = dataItem.getDisplayText();
            Icon displayIcon = dataItem.getIcon();
            label.setIcon(displayIcon);
            label.setText(displayText);
        }
        return label;
    }

    public Object getPrototypeCell(JList list, ListModel listModel) {
        Icon icon = null;
        String displayText = "";
        int displayWidth = 0;
        Font font = list.getFont();
        FontMetrics metrics = list.getFontMetrics(font);
        int numElements = listModel.getSize();
        int i = 0;
        while (i < numElements) {
            int elementWidth;
            String elementText;
            Object element = listModel.getElementAt(i);
            if (element instanceof ListDataItem) {
                ListDataItem listItem = (ListDataItem)element;
                elementText = listItem.getDisplayText();
                if (icon == null) {
                    icon = listItem.getIcon();
                }
            } else {
                elementText = element.toString();
            }
            if ((elementWidth = metrics.stringWidth(elementText)) > displayWidth) {
                displayWidth = elementWidth;
                displayText = elementText;
            }
            ++i;
        }
        DummyItem prototypeItem = new DummyItem(icon, displayText);
        return prototypeItem;
    }

    private static final class DummyItem
    extends ListDataItem {
        private Icon icon;
        private String name;

        DummyItem(Icon icon, String name) {
            this.icon = icon;
            this.name = name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDisplayText() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

