/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.resource.BundleHelper;

public final class KeyRecorder
implements ActionHookInvoker,
FocusListener,
KeyListener,
Runnable {
    private static final int FEEDBACK_LENGTH = 3000;
    private static final String RECORDING_STARTED;
    private static final String RECORDING_CANCELLED;
    private static final String RECORDING_ENDED;
    private static final String PLAYBACK_STARTED;
    private static final String PLAYBACK_CANCELLED;
    private static final String PLAYBACK_ENDED;
    private static final String NOTHING_RECORDED;
    public static final String MACRO_PLAYBACK_DELAY = "macro-playback-delay";
    private MultiKeyHandler keyHandler;
    private boolean shutdown;
    private boolean finished;
    private Thread playbackThread;
    private List macroList;
    private boolean recording;
    private boolean playing;
    private BasicEditorPane editorPane;

    public KeyRecorder() {
        this.$init$();
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        RECORDING_STARTED = resources.getString("MACRO_RECORDING_STARTED");
        RECORDING_CANCELLED = resources.getString("MACRO_RECORDING_CANCELLED");
        RECORDING_ENDED = resources.getString("MACRO_RECORDING_ENDED");
        PLAYBACK_STARTED = resources.getString("MACRO_PLAYBACK_STARTED");
        PLAYBACK_CANCELLED = resources.getString("MACRO_PLAYBACK_CANCELLED");
        PLAYBACK_ENDED = resources.getString("MACRO_PLAYBACK_ENDED");
        NOTHING_RECORDED = resources.getString("MACRO_NOTHING_RECORDED");
    }

    private void $init$() {
        this.keyHandler = null;
        this.shutdown = false;
        this.finished = true;
        this.playbackThread = null;
        this.macroList = null;
        this.recording = false;
        this.playing = false;
        this.editorPane = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private synchronized void install(BasicEditorPane editor) {
        this.shutdown = false;
        this.editorPane = editor;
        this.recording = false;
        this.playing = false;
        this.finished = true;
        this.playbackThread = null;
        this.keyHandler = MultiKeyHandler.getInstalledHandler(this.editorPane);
        this.keyHandler.addKeyFilter(this);
        editor.addFocusListener(this);
    }

    private synchronized void deinstall(BasicEditorPane editor) {
        editor.removeFocusListener(this);
        this.keyHandler.removeKeyFilter(this);
        this.keyHandler = null;
        this.shutdown = true;
        this.finished = true;
        this.editorPane = null;
        this.recording = false;
        this.playing = false;
        this.playbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void toggleRecording(BasicEditorPane editorPane) {
        if (this.playing) {
            Thread pt = null;
            KeyRecorder keyRecorder = this;
            synchronized (keyRecorder) {
                pt = this.playbackThread;
                this.finished = true;
            }
            if (pt != null) {
                Thread thread = pt;
                synchronized (thread) {
                    pt.notify();
                }
            }
            return;
        }
        if (this.recording) {
            if (editorPane != this.editorPane) {
                throw new IllegalStateException("toggle in wrong editor");
            }
            this.showFeedback(this.shutdown ? RECORDING_CANCELLED : RECORDING_ENDED);
            this.deinstall(editorPane);
        } else {
            this.install(editorPane);
            this.recording = true;
            if (this.macroList == null) {
                this.macroList = new ArrayList();
            }
            this.macroList.clear();
            this.showFeedback(RECORDING_STARTED);
        }
    }

    public synchronized void playbackRecording(BasicEditorPane editorPane) {
        if (this.recording) {
            return;
        }
        if (this.playing) {
            return;
        }
        if (this.macroList == null || this.macroList.size() == 0) {
            this.showFeedback(editorPane, NOTHING_RECORDED);
            return;
        }
        this.install(editorPane);
        this.playing = true;
        this.finished = false;
        this.shutdown = false;
        this.showFeedback(PLAYBACK_STARTED);
        this.playbackThread = new Thread((Runnable)this, "Macro Playback Thread");
        this.playbackThread.start();
    }

    private synchronized void handleKeyEvent(KeyEvent event) {
        if (this.recording) {
            RecordedEvent recordedEvent = new RecordedEvent(event, null);
            this.macroList.add(recordedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelOperation() {
        if (this.recording) {
            this.shutdown = true;
            this.toggleRecording(this.editorPane);
        } else if (this.playing) {
            Thread pt = null;
            KeyRecorder keyRecorder = this;
            synchronized (keyRecorder) {
                pt = this.playbackThread;
                this.shutdown = true;
                this.finished = true;
            }
            if (pt != null) {
                Thread thread = pt;
                synchronized (thread) {
                    pt.notify();
                }
            }
        } else {
            throw new IllegalStateException("nothing to cancel");
        }
    }

    private synchronized void handleFocusEvent(FocusEvent event) {
        if (event.getID() == 1005) {
            this.cancelOperation();
        }
    }

    private synchronized void showFeedback(String message) {
        this.showFeedback(this.editorPane, message);
    }

    private synchronized void showFeedback(BasicEditorPane editor, String message) {
        if (editor != null) {
            FeedbackManager feedbackManager = editor.getFeedbackManager();
            feedbackManager.showFeedback(this.editorPane, message, 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = this.playbackThread;
        synchronized (thread) {
            this.sleep(this.playbackThread, 10);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int numEvents = this.macroList.size();
            int i = 0;
            while (i < numEvents) {
                if (this.shutdown) break;
                RecordedEvent recordedEvent = (RecordedEvent)this.macroList.get(i);
                KeyRecorder keyRecorder = this;
                synchronized (keyRecorder) {
                    KeyEvent keyEvent = RecordedEvent.mav$getKeyEvent(recordedEvent, this.editorPane);
                    eventQueue.postEvent(keyEvent);
                }
                ++i;
            }
            while (!this.shutdown && !this.finished) {
                this.sleep(this.playbackThread, 1000L);
            }
        }
        String message = this.shutdown ? PLAYBACK_CANCELLED : PLAYBACK_ENDED;
        1 stopPlayback = new 1(this, message);
        SwingUtilities.invokeLater(stopPlayback);
    }

    private void sleep(Object object, long milliseconds) {
        try {
            object.wait(milliseconds);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("cancel")) {
            this.cancelOperation();
            return true;
        }
        return false;
    }

    public void focusGained(FocusEvent event) {
        this.handleFocusEvent(event);
    }

    public void focusLost(FocusEvent event) {
        this.handleFocusEvent(event);
    }

    public void keyPressed(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    public void keyTyped(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    public void keyReleased(KeyEvent event) {
        this.handleKeyEvent(event);
    }

    static void mav$showFeedback(KeyRecorder keyRecorder, String string) {
        keyRecorder.showFeedback(string);
    }

    static BasicEditorPane ra$editorPane(KeyRecorder keyRecorder) {
        return keyRecorder.editorPane;
    }

    static void mav$deinstall(KeyRecorder keyRecorder, BasicEditorPane basicEditorPane) {
        keyRecorder.deinstall(basicEditorPane);
    }

    static void wa$playing(KeyRecorder keyRecorder, boolean bl) {
        keyRecorder.playing = bl;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ String v$message;
        final /* synthetic */ KeyRecorder this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            KeyRecorder keyRecorder = this.this$0;
            synchronized (keyRecorder) {
                KeyRecorder.mav$showFeedback(this.this$0, this.v$message);
                KeyRecorder.mav$deinstall(this.this$0, KeyRecorder.ra$editorPane(this.this$0));
                KeyRecorder.wa$playing(this.this$0, false);
            }
        }

        public 1(KeyRecorder keyRecorder, String string) {
            this.v$message = string;
            this.this$0 = keyRecorder;
        }
    }

    private static final class RecordedEvent {
        int id;
        long when;
        int modifiers;
        int keyCode;
        char keyChar;

        private RecordedEvent(KeyEvent event) {
            this.id = event.getID();
            this.when = event.getWhen();
            this.modifiers = event.getModifiers();
            this.keyCode = event.getKeyCode();
            this.keyChar = event.getKeyChar();
        }

        private KeyEvent getKeyEvent(Component newSource) {
            return new KeyEvent(newSource, this.id, System.currentTimeMillis(), this.modifiers, this.keyCode, this.keyChar);
        }

        static KeyEvent mav$getKeyEvent(RecordedEvent recordedEvent, Component component) {
            return recordedEvent.getKeyEvent(component);
        }

        RecordedEvent(KeyEvent keyEvent, 1 var2_2) {
            this(keyEvent);
        }

        public final class 1 {
        }
    }
}

