/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.lang.ref.SoftReference;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.BraceHelper;

public abstract class AbstractBraceProvider
implements BraceProvider {
    private static final int AVERAGE_TOKEN_SIZE = 8;
    private static final float BRACE_OCCURRENCE = 0.12f;
    private static final int MINIMUM_BRACE_ENTRIES = 20;
    private static final float EXPANSION_FACTOR = 1.25f;
    protected int[] braceArray;
    protected int braceCount;
    private SoftReference braceArrayRef;
    private int bufferChangeId;

    protected abstract TextBuffer getTextBuffer();

    protected abstract BraceHelper getBraceHelper();

    protected abstract Lexer getLexer();

    protected abstract boolean isBraceToken(int var1);

    protected abstract String getBraceCharacters();

    public synchronized int isPartOfBrace(int offset, NumberRange braceLocation) {
        block5: {
            TextBuffer textBuffer = this.getTextBuffer();
            char c = textBuffer.getChar(offset);
            String braceCharacters = this.getBraceCharacters();
            if (braceCharacters.indexOf(c) == -1) {
                return -1;
            }
            try {
                this.buildBraceArray();
                int entry = this.findEntryForOffset(offset);
                if (entry == -1) break block5;
                braceLocation.start = this.braceArray[entry];
                braceLocation.end = this.braceArray[entry + 1];
                int n = this.braceArray[entry + 2];
                return n;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.releaseBraceArray();
            }
        }
        return -1;
    }

    public synchronized int findMatchingBrace(int braceType, NumberRange braceLocation, NumberRange matchingLocation) {
        int braceCategory;
        BraceHelper braceHelper = this.getBraceHelper();
        TextBuffer textBuffer = this.getTextBuffer();
        int bracePairCount = braceHelper.getBracePairsCount();
        int[] braceCountArray = new int[bracePairCount];
        int i = 0;
        while (i < bracePairCount) {
            braceCountArray[i] = 0;
            ++i;
        }
        int braceTypeMatch = braceHelper.getMatchingBraceIndex(braceType);
        boolean searchForward = braceHelper.isOpenIndex(braceType);
        int n = braceCategory = searchForward ? braceType : braceTypeMatch;
        if (braceType == -1) {
            throw new IllegalStateException("invalid brace type: " + braceType);
        }
        if (braceTypeMatch == -1) {
            throw new IllegalStateException("invalid match type: " + braceType);
        }
        int braceOffset = braceLocation.start;
        if (braceOffset < 0 || braceOffset >= textBuffer.getLength()) {
            throw new IllegalStateException("brace not in buffer");
        }
        try {
            this.buildBraceArray();
            int startEntry = this.findEntryForOffset(braceOffset);
            if (startEntry == -1) {
                int n2 = 3;
                return n2;
            }
            int increment = searchForward ? 3 : -3;
            int braceBoundary = this.braceCount * 3;
            for (int currentEntry = startEntry; currentEntry >= 0; currentEntry += increment) {
                if (currentEntry >= braceBoundary) {
                    break;
                }
                int braceToCheck = this.braceArray[currentEntry + 2];
                if (braceToCheck == -1) {
                    throw new IllegalStateException("bad check: " + braceToCheck);
                }
                int matchingToCheck = braceHelper.getMatchingBraceIndex(braceToCheck);
                if (matchingToCheck == -1) {
                    throw new IllegalStateException("bad match: " + matchingToCheck);
                }
                if (braceHelper.isOpenIndex(braceToCheck)) {
                    int n3 = braceToCheck;
                    braceCountArray[n3] = braceCountArray[n3] + 1;
                } else {
                    int n4 = matchingToCheck;
                    braceCountArray[n4] = braceCountArray[n4] - 1;
                }
                if (braceCountArray[braceCategory] != 0) continue;
                matchingLocation.start = this.braceArray[currentEntry];
                matchingLocation.end = this.braceArray[currentEntry + 1];
                int i2 = 0;
                while (i2 < bracePairCount) {
                    if (braceCountArray[i2] != 0) {
                        int n5 = 2;
                        return n5;
                    }
                    ++i2;
                }
                int n6 = 1;
                return n6;
            }
        }
        finally {
            this.releaseBraceArray();
        }
        return 3;
    }

    protected int guessBraceCount(int length) {
        return (int)((float)(length / 8) * 0.12f);
    }

    protected int[] expandBraceArray(int[] braceArray) {
        int currentSize = braceArray.length;
        int newSize = (int)((float)currentSize * 1.25f);
        int[] newArray = new int[newSize];
        System.arraycopy(braceArray, 0, newArray, 0, currentSize);
        return newArray;
    }

    protected void fillBraceArray() {
        TextBuffer textBuffer = this.getTextBuffer();
        int bufferEnd = textBuffer.getLength();
        Lexer lexer = this.getLexer();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(0);
        LexerToken lexerToken = lexer.createLexerToken();
        BraceHelper braceHelper = this.getBraceHelper();
        while (true) {
            int arrayIndex;
            int token = lexer.lex(lexerToken);
            if (lexerToken.getStartOffset() >= bufferEnd || token == 0) break;
            if (!this.isBraceToken(token)) continue;
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            int braceIndex = braceHelper.getBraceIndex((ReadTextBuffer)textBuffer, startOffset, endOffset);
            if ((arrayIndex = this.braceCount++ * 3) + 2 >= this.braceArray.length) {
                this.braceArray = this.expandBraceArray(this.braceArray);
            }
            this.braceArray[arrayIndex++] = startOffset;
            this.braceArray[arrayIndex++] = endOffset;
            this.braceArray[arrayIndex] = braceIndex;
        }
    }

    private void buildBraceArray() {
        TextBuffer textBuffer = this.getTextBuffer();
        if (this.braceArrayRef != null) {
            this.braceArray = (int[])this.braceArrayRef.get();
        }
        if (this.braceArray == null || this.bufferChangeId != textBuffer.getChangeId()) {
            int length = textBuffer.getLength();
            int guessSize = Math.max(this.guessBraceCount(length), 20);
            if (this.braceArray == null) {
                this.braceArray = new int[guessSize * 3];
            }
            this.bufferChangeId = textBuffer.getChangeId();
            this.braceCount = 0;
            this.fillBraceArray();
            this.braceArrayRef = new SoftReference<int[]>(this.braceArray);
        }
    }

    private void releaseBraceArray() {
        this.braceArray = null;
    }

    private int findEntryForOffset(int offset) {
        if (this.braceArray == null || this.braceArray.length == 0 || this.braceCount == 0) {
            return -1;
        }
        int top_entry = 0;
        int bottom_entry = this.braceCount * 3;
        if (offset < this.braceArray[top_entry]) {
            return -1;
        }
        if (offset >= this.braceArray[bottom_entry - 3 + 1]) {
            return -1;
        }
        while (true) {
            int spread;
            if ((spread = bottom_entry - top_entry) <= 3) {
                if (spread <= 0) {
                    return -1;
                }
                if (offset < this.braceArray[top_entry + 1]) {
                    return top_entry;
                }
                return -1;
            }
            int middle_entry = bottom_entry + top_entry >> 1;
            if (offset < this.braceArray[middle_entry = middle_entry / 3 * 3]) {
                bottom_entry = middle_entry;
                continue;
            }
            top_entry = middle_entry;
        }
    }
}

