/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyledFragmentsList;

public abstract class AbstractDocumentRenderer
implements DocumentRenderer {
    private static final boolean DEBUG = false;
    private LanguageSupport support;
    private static int fragListAllocCounter = 0;
    private static final int FRAGLIST_ALLOC_WARNING_LEVEL = 100;
    private static StyledFragmentsList cachedList = null;
    private static String listLock = "fragment-list-lock";

    public AbstractDocumentRenderer(LanguageSupport support) {
        this.support = support;
    }

    public final BasicDocument getDocument() {
        BasicDocument document = this.support.getDocument();
        return document;
    }

    public final TextBuffer getTextBuffer() {
        BasicDocument document = this.support.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer;
    }

    public final LineMap getLineMap() {
        BasicDocument document = this.support.getDocument();
        LineMap lineMap = document.getLineMap();
        return lineMap;
    }

    public StyledFragmentsList renderLines(int startLine, int endLine) {
        if (startLine > endLine) {
            return null;
        }
        StyledFragmentsList fragmentsList = this.allocateFragmentsList();
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int startOffset = lineMap.getLineStartOffset(startLine);
        int endOffset = lineMap.getLineEndOffset(endLine);
        this.renderRegion(fragmentsList, startOffset, endOffset);
        return fragmentsList;
    }

    public abstract void renderRegion(StyledFragmentsList var1, int var2, int var3);

    public void calculateDamage(DocumentEvent changes, NumberRange damageRange) {
        LineMap lineMap = this.getLineMap();
        int lineCount = lineMap.getLineCount();
        damageRange.start = 0;
        damageRange.end = lineCount - 1;
    }

    public void notifyUpdate(DocumentEvent changes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recycleFragmentsList(StyledFragmentsList fragmentsList) {
        String string = listLock;
        synchronized (string) {
            fragmentsList.clear();
            cachedList = fragmentsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StyledFragmentsList allocateFragmentsList() {
        StyledFragmentsList listToUse = null;
        String string = listLock;
        synchronized (string) {
            if (cachedList == null) {
                cachedList = new StyledFragmentsList();
                if (++fragListAllocCounter >= 100) {
                    EditorProperties properties = EditorProperties.getProperties();
                    boolean checkAlloc = properties.getBooleanProperty("check-fraglist-recycling");
                    if (checkAlloc) {
                        System.err.println("StyledFragmentsList allocation at: " + fragListAllocCounter);
                    }
                    fragListAllocCounter = 0;
                }
            }
            listToUse = cachedList;
            cachedList = null;
        }
        return listToUse;
    }
}

