/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.idl;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.idl.IDLBlockRenderer;
import oracle.javatools.editor.language.idl.IDLLanguageSupport;
import oracle.javatools.editor.language.idl.IDLStyles;
import oracle.javatools.resource.BundleHelper;

public final class IDLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"idl"};

    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("IDL_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return IDLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("const long VERSION = 1;\n");
        buffer.append("\n");
        buffer.append("module hello\n");
        buffer.append("{\n");
        buffer.append("  // Returns some friendly message\n");
        buffer.append("  interface Hello\n");
        buffer.append("  {\n");
        buffer.append("    wstring helloWorld();\n");
        buffer.append("  };\n");
        buffer.append("};\n");
        return buffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry registry) {
        new IDLStyles(registry);
    }

    public LanguageSupport createLanguageSupport() {
        return new IDLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new IDLBlockRenderer(buffer);
    }
}

