/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileReducer {
    private List<Integer> _offsets;
    private int _max;
    private ArrayList<Integer> _positionStack;
    private ArrayList<Pair<Integer, Integer>> _skips;
    private final StringBuffer _stringBuffer;

    private void $init$() {
        this._positionStack = new ArrayList();
        this._skips = new ArrayList();
        this._stringBuffer = new StringBuffer();
    }

    public SourceFileReducer() {
        this.$init$();
    }

    public final TextBuffer reduce(TextBuffer buffer, Integer ... offsets) {
        this._offsets = new ArrayList<Integer>(Arrays.asList(offsets));
        this._max = Collections.max(this._offsets);
        this._positionStack = new ArrayList();
        this._skips = new ArrayList();
        int upTo = this.buildSkips((ReadTextBuffer)buffer);
        TextBuffer shortBuffer = this.createShortBuffer(buffer, upTo, this._positionStack.size());
        return shortBuffer;
    }

    public List<Integer> getAdjustedOffsets() {
        return this._offsets;
    }

    private void clearStack() {
        this._positionStack.clear();
    }

    private void pushBlock(int offset) {
        this._positionStack.add(offset);
    }

    private void popBlock(int offset) {
        int size = this._positionStack.size();
        if (size > 0) {
            int blockStart = this._positionStack.remove(size - 1);
            boolean isNeeded = false;
            int i = 0;
            while (!isNeeded && i < this._offsets.size()) {
                int keepOffset = this._offsets.get(i);
                if (blockStart <= keepOffset && keepOffset <= offset) {
                    isNeeded = true;
                }
                ++i;
            }
            if (!isNeeded) {
                this.skip(blockStart + 1, offset - 1);
            }
        }
    }

    private void skip(int from, int to) {
        if (from < to) {
            int i = this._skips.size() - 1;
            while (i >= 0) {
                Pair<Integer, Integer> top = this._skips.get(i);
                if (from > (Integer)top.first || (Integer)top.second > to) break;
                this._skips.remove(i);
                --i;
            }
            this._skips.add(new Pair<Integer, Integer>(from, to));
        }
    }

    private int buildSkips(ReadTextBuffer buffer) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(buffer);
        javaLexer.setPosition(0);
        this.clearStack();
        int forSemi = 0;
        block7: while (true) {
            int token = javaLexer.lex();
            switch (token) {
                case 0: {
                    return buffer.getLength();
                }
                case 49: {
                    int startOffset = javaLexer.getStartOffset();
                    this.pushBlock(startOffset);
                    continue block7;
                }
                case 70: {
                    int startOffset = javaLexer.getStartOffset();
                    this.popBlock(startOffset);
                    if (startOffset <= this._max) continue block7;
                    return javaLexer.getEndOffset();
                }
                case 75: {
                    int startOffset;
                    if (--forSemi > 0 || (startOffset = javaLexer.getStartOffset()) <= this._max) continue block7;
                    return javaLexer.getEndOffset();
                }
                case 114: {
                    forSemi = 3;
                    continue block7;
                }
            }
        }
    }

    private TextBuffer createShortBuffer(TextBuffer originalBuffer, int upTo, int bracesToClose) {
        int offsetPos = 0;
        int removed = 0;
        int from = 0;
        this._stringBuffer.setLength(0);
        for (Pair<Integer, Integer> pair : this._skips) {
            int skipFrom = (Integer)pair.first;
            int skipTo = (Integer)pair.second;
            int length = skipFrom - from;
            String text = originalBuffer.getString(from, length);
            this._stringBuffer.append(text);
            while (offsetPos < this._offsets.size()) {
                int offset = this._offsets.get(offsetPos);
                if (offset >= skipFrom) break;
                this._offsets.set(offsetPos, offset - removed);
                ++offsetPos;
            }
            while (offsetPos < this._offsets.size()) {
                int offset = this._offsets.get(offsetPos);
                if (offset > skipTo) break;
                this._offsets.set(offsetPos, skipFrom - removed);
                ++offsetPos;
            }
            removed += skipTo - skipFrom + 1;
            from = skipTo + 1;
        }
        String text = originalBuffer.getString(from, upTo - from);
        this._stringBuffer.append(text);
        while (offsetPos < this._offsets.size()) {
            int offset = this._offsets.get(offsetPos);
            this._offsets.set(offsetPos, offset - removed);
            ++offsetPos;
        }
        this._stringBuffer.append('\n');
        int i = 0;
        while (i < bracesToClose) {
            this._stringBuffer.append('}');
            ++i;
        }
        String shortText = this._stringBuffer.toString();
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, shortText.toCharArray());
        return textBuffer;
    }
}

