/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.TagBlockRenderer;
import oracle.javatools.editor.language.jsp.JSPBlockRenderer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;

final class JSPTagBlockRenderer
extends TagBlockRenderer {
    private LexerBlockRenderer embeddedRenderer;
    private HTMLLexer embeddedLexer;
    private LexerToken embeddedToken;

    JSPTagBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 24: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderEmbeddedTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
                break;
            }
        }
    }

    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 24: {
                throw new IllegalStateException("should be sub-rendering embedded");
            }
        }
        return super.mapTokenToStyleName(token);
    }

    protected void renderEmbeddedTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        int quoteEnd;
        int quoteStart;
        String quoteStyleName = this.mapTokenToStyleName(22);
        if (tokenStart < tokenEnd && (quoteStart = Math.max(clipStart, tokenStart)) < (quoteEnd = Math.min(clipEnd, tokenEnd))) {
            fragmentsList.add(quoteStyleName, quoteStart, quoteEnd);
        }
    }

    private void ensureEmbeddedRenderer() {
        if (this.embeddedRenderer == null) {
            this.embeddedRenderer = new JSPBlockRenderer(this.getTextBuffer());
            this.embeddedLexer = new HTMLLexer();
            this.embeddedLexer.setRecognizeJSP(true);
            this.embeddedLexer.setRecognizeEmbeddedTags(true);
            this.embeddedLexer.setRecognizeScripts(true);
            this.embeddedLexer.setRecognizeStyles(true);
            this.embeddedToken = this.embeddedLexer.createLexerToken();
        }
    }
}

