/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.properties;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.properties.DefinitionBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.properties.PropertiesLexer;
import oracle.javatools.parser.properties.PropertiesTokens;

final class PropertiesBlockRenderer
extends LexerBlockRenderer
implements PropertiesTokens {
    protected DefinitionBlockRenderer definitionRenderer;

    PropertiesBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.definitionRenderer = new DefinitionBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        return new PropertiesLexer();
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 11: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderDefinition(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
                break;
            }
        }
    }

    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 12: {
                return "properties-comment-style";
            }
            case 11: {
                throw new IllegalStateException("Should be sub-rendering defs");
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderDefinition(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        this.definitionRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

