/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractClickPlugin
implements EditorPlugin,
ActionListener,
MouseListener,
MouseMotionListener,
CaretListener {
    private Point _mousePoint;
    private int _actionType;
    private Timer _updateTimer;
    protected static final int ACTION_NONE = -1;
    protected static final int DEFAULT_DELAY_TIME = 150;
    protected static final int ALL_MODIFIER_MASK = 960;
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;

    public void install(BasicEditorPane editor) {
        this._editor = editor;
        this._editor.addMouseListener(this);
        this._editor.addMouseMotionListener(this);
        this._updateTimer = new Timer(this.getUpdateDelayTime(), this);
        this._updateTimer.setRepeats(false);
        this._editor.addCaretListener(this);
    }

    public void deinstall(BasicEditorPane editor) {
        this._updateTimer.stop();
        this._updateTimer = null;
        this._editor.removeMouseListener(this);
        this._editor.removeMouseMotionListener(this);
        this._editor.removeCaretListener(this);
        if (this._highlightLayer != null) {
            this._editor.destroyHighlightLayer(this._highlightLayer);
            this._highlightLayer = null;
        }
        this._editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 1) {
            return;
        }
        int actionType = this.getActionTypeFor(event);
        if (actionType != -1) {
            Point point = event.getPoint();
            this.handleClickAction(point, actionType);
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
        this.scheduleUpdate(null, -1);
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
        int actionType = this.getActionTypeFor(event);
        Point pointToUse = actionType == -1 ? null : event.getPoint();
        this.scheduleUpdate(pointToUse, actionType);
    }

    public void caretUpdate(CaretEvent e) {
        this.scheduleUpdate(null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(Point point, int actionType) {
        AbstractClickPlugin abstractClickPlugin = this;
        synchronized (abstractClickPlugin) {
            this._mousePoint = point;
            this._actionType = actionType;
        }
        if (point == null) {
            this.updateHighlight(null, actionType);
        } else if (this._updateTimer != null) {
            this._updateTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        int actionType;
        Point point;
        AbstractClickPlugin abstractClickPlugin = this;
        synchronized (abstractClickPlugin) {
            point = this._mousePoint;
            actionType = this._actionType;
        }
        if (this._editor != null) {
            this.updateHighlight(point, actionType);
        }
    }

    protected abstract int getActionTypeFor(MouseEvent var1);

    protected abstract void handleClickAction(Point var1, int var2);

    protected abstract HighlightStyle getHighlightStyleFor(int var1);

    protected abstract String getHintTextFor(int var1);

    protected abstract NumberRange getRegionFor(int var1, int var2);

    protected int getUpdateDelayTime() {
        return 150;
    }

    protected boolean isActionTrigger(MouseEvent event) {
        return this.getActionTypeFor(event) != -1;
    }

    protected boolean hasModifierEx(MouseEvent event, int modifierEx) {
        return (event.getModifiersEx() & 0x3C0) == modifierEx;
    }

    protected TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    protected BasicEditorPane getEditorPane() {
        return this._editor;
    }

    protected BasicDocument getDocument() {
        return (BasicDocument)this._editor.getDocument();
    }

    private HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editor.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    protected void updateHighlight(Point point, int actionType) {
        HighlightLayer layerToUse = this.getHighlightLayer();
        if (layerToUse != null) {
            int offset;
            NumberRange offsets;
            HighlightStyle highlightToUse;
            layerToUse.removeAllHighlights();
            if (actionType != -1 && (highlightToUse = this.getHighlightStyleFor(actionType)) != null && point != null && (offsets = this.getRegionFor(offset = this._editor.viewToModel(point), actionType)) != null) {
                layerToUse.addHighlight(highlightToUse, offsets.start, offsets.end);
            }
        }
        this.updateHint(actionType);
    }

    protected void updateHint(int actionType) {
        String hintToUse;
        boolean shown = false;
        if (actionType != -1 && (hintToUse = this.getHintTextFor(actionType)) != null) {
            this._editor.getFeedbackManager().showFeedback(this._editor, hintToUse);
            shown = true;
        }
        if (!shown) {
            this._editor.getFeedbackManager().hideFeedback(this._editor);
        }
    }
}

