/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.DropTargetPlugin;
import oracle.javatools.resource.BundleHelper;

public class DragDropPlugin
extends DropTargetPlugin
implements DragGestureListener,
DragSourceListener {
    protected Caret originalCaret;
    protected DragGestureRecognizer dragRecognizer;
    protected boolean selectionClicked;
    protected boolean queuedPopupTrigger;
    protected boolean dragInProgress;
    protected OffsetMark dropOffsetMark;
    protected static final EditDescriptor DRAG_DESCRIPTOR;
    protected static final EditDescriptor DRAGDROP_DESCRIPTOR;
    private static final boolean needsFocusWorkaround;
    private boolean skipDragGesture;
    protected boolean focusWasGained;
    protected static final DataFlavor OUR_FLAVOR;
    private static DataFlavor[] ourFlavors;

    public DragDropPlugin() {
        this.$init$();
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        DragSource dragSource = DragSource.getDefaultDragSource();
        int supportedActions = 3;
        this.dragRecognizer = dragSource.createDefaultDragGestureRecognizer(editor, supportedActions, this);
        this.installDragCaret();
    }

    public void deinstall(BasicEditorPane editor) {
        this.deinstallDragCaret();
        this.dragRecognizer.setComponent(null);
        this.dragRecognizer = null;
        super.deinstall(editor);
    }

    protected void installDragCaret() {
        Caret oldCaret = this.editor.getCaret();
        DragCaret newCaret = new DragCaret();
        this.exchangeCaret(oldCaret, newCaret);
        if (!(oldCaret instanceof BasicCaret)) {
            this.originalCaret = oldCaret;
        }
    }

    protected void deinstallDragCaret() {
        Caret restoreCaret = this.originalCaret == null ? (Caret)new BasicCaret() : this.originalCaret;
        Caret currentCaret = this.editor.getCaret();
        try {
            this.exchangeCaret(currentCaret, restoreCaret);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.originalCaret = null;
    }

    protected void exchangeCaret(Caret oldCaret, Caret newCaret) {
        int blinkRate = oldCaret.getBlinkRate();
        int dot = oldCaret.getDot();
        int mark = oldCaret.getMark();
        Point magic = oldCaret.getMagicCaretPosition();
        this.editor.setCaret(newCaret);
        int length = this.editor.getDocument().getLength();
        dot = Math.min(dot, length);
        mark = Math.min(dot, length);
        newCaret.setBlinkRate(blinkRate);
        newCaret.setVisible(this.editor.hasFocus());
        newCaret.setMagicCaretPosition(magic);
        newCaret.setDot(mark);
        newCaret.moveDot(dot);
        if (oldCaret instanceof BasicCaret && newCaret instanceof BasicCaret) {
            boolean insertMode = ((BasicCaret)oldCaret).getInsertMode();
            ((BasicCaret)newCaret).setInsertMode(insertMode);
        }
    }

    private void $init$() {
        this.originalCaret = null;
        this.dragRecognizer = null;
        this.selectionClicked = false;
        this.queuedPopupTrigger = false;
        this.dragInProgress = false;
        this.dropOffsetMark = null;
        this.skipDragGesture = false;
        this.focusWasGained = false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        if (!this.focusWasGained && this.selectionClicked && !this.skipDragGesture) {
            Point location = event.getDragOrigin();
            int offset = this.editor.viewToModel(location);
            if (this.editor.hasSelection() && this.isInSelection(offset)) {
                this.dragInProgress = true;
                try {
                    DragTransferable transferable = new DragTransferable();
                    event.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
                }
                catch (InvalidDnDOperationException e) {
                    this.dragInProgress = false;
                }
            }
        }
    }

    public void dragEnter(DragSourceDragEvent event) {
        this.handleDragEvent(event);
    }

    public void dragOver(DragSourceDragEvent event) {
        this.handleDragEvent(event);
    }

    public void dropActionChanged(DragSourceDragEvent event) {
        this.handleDragEvent(event);
    }

    public void dragExit(DragSourceEvent event) {
        this.cancelDragEvent(event);
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        this.handleDropEvent(event);
    }

    protected void handleDragEvent(DragSourceDragEvent event) {
        int dropAction = event.getDropAction();
        this.updateDragCursor(event, dropAction);
    }

    protected void cancelDragEvent(DragSourceEvent event) {
        this.updateDragCursor(event, 0);
    }

    protected void handleDropEvent(DragSourceDropEvent event) {
        block17: {
            boolean dropSuccess = event.getDropSuccess();
            if (dropSuccess) {
                int dropAction = event.getDropAction();
                if (this.dropOffsetMark == null) {
                    if (dropAction == 2) {
                        this.editor.beginEdit(DRAG_DESCRIPTOR);
                        try {
                            this.removeSelectedText();
                        }
                        finally {
                            this.editor.endEdit();
                        }
                    }
                } else {
                    this.editor.beginEdit(DRAGDROP_DESCRIPTOR);
                    try {
                        try {
                            Caret caret;
                            Transferable transferable = event.getDragSourceContext().getTransferable();
                            String data = transferable.getTransferData(DropTargetPlugin.STRING_FLAVOR).toString();
                            if (dropAction == 2) {
                                this.removeSelectedText();
                            }
                            if ((caret = this.editor.getCaret()) instanceof BasicCaret) {
                                ((BasicCaret)caret).getEditorSelection().insertText(this.dropOffsetMark.getOffset(), data);
                                break block17;
                            }
                            BasicDocument document = this.getDocument();
                            document.insertString(this.dropOffsetMark.getOffset(), data, null);
                            this.editor.setCaretPosition(this.dropOffsetMark.getOffset() + data.length());
                        }
                        catch (BadLocationException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (UnsupportedFlavorException e) {}
                    }
                    finally {
                        this.editor.endEdit();
                    }
                }
            }
        }
        this.selectionClicked = false;
        this.queuedPopupTrigger = false;
        this.dragInProgress = false;
        if (this.dropOffsetMark != null) {
            ((BasicDocument)this.editor.getDocument()).getTextBuffer().removeOffsetMark(this.dropOffsetMark);
        }
        this.dropOffsetMark = null;
    }

    protected void removeSelectedText() {
        try {
            Caret caret = this.editor.getCaret();
            if (caret instanceof BasicCaret) {
                ((BasicCaret)caret).getEditorSelection().deleteSelection();
            } else {
                int selectStart = this.editor.getSelectionStart();
                int selectEnd = this.editor.getSelectionEnd();
                BasicDocument document = this.getDocument();
                document.remove(selectStart, selectEnd - selectStart);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    protected void handleDropEvent(DropTargetDropEvent event) {
        int dropAction = event.getDropAction();
        if (this.editor.isEditable() && this.isDropActionSupported(dropAction) && event.isDataFlavorSupported(OUR_FLAVOR)) {
            Transferable transferable = event.getTransferable();
            try {
                DragTransferable dragTransferable = (DragTransferable)transferable.getTransferData(OUR_FLAVOR);
                if (this.editor == dragTransferable.getEditorPane()) {
                    this.clearDropLocation();
                    event.acceptDrop(dropAction);
                    Point location = event.getLocation();
                    int dropOffset = this.editor.viewToModel(location);
                    this.dropOffsetMark = ((BasicDocument)this.editor.getDocument()).getTextBuffer().addOffsetMark(dropOffset);
                    event.dropComplete(this.isInSelection(this.dropOffsetMark.getOffset()) ^ true);
                    return;
                }
            }
            catch (IOException e) {
            }
            catch (UnsupportedFlavorException e) {
                // empty catch block
            }
        }
        super.handleDropEvent(event);
    }

    protected boolean isInSelection(int offset) {
        boolean inSelection = false;
        if (this.editor.getCaret() instanceof BasicCaret) {
            inSelection = ((BasicCaret)this.editor.getCaret()).getEditorSelection().isInSelection(offset);
        } else {
            int selectStart = this.editor.getSelectionStart();
            int selectEnd = this.editor.getSelectionEnd();
            inSelection = selectStart <= offset && offset <= selectEnd;
        }
        return inSelection;
    }

    protected void updateDragCursor(DragSourceEvent event, int dropAction) {
        Cursor cursorToUse = null;
        switch (dropAction) {
            case 1: {
                cursorToUse = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursorToUse = DragSource.DefaultMoveDrop;
                break;
            }
            case 0: {
                cursorToUse = DragSource.DefaultCopyNoDrop;
                break;
            }
        }
        event.getDragSourceContext().setCursor(cursorToUse);
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        String editName = resources.getString("UNDO_DRAG_OPERATION");
        DRAG_DESCRIPTOR = new EditDescriptor(editName);
        editName = resources.getString("UNDO_DRAG_DROP_OPERATION");
        DRAGDROP_DESCRIPTOR = new EditDescriptor(editName);
        String javaVersion = System.getProperty("java.version");
        needsFocusWorkaround = javaVersion != null && (javaVersion.startsWith("1.3") || javaVersion.startsWith("1.2"));
        OUR_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DragTransferable.class.getName(), "Editor Text");
        ourFlavors = null;
    }

    static boolean ra$skipDragGesture(DragDropPlugin dragDropPlugin) {
        return dragDropPlugin.skipDragGesture;
    }

    static void wa$skipDragGesture(DragDropPlugin dragDropPlugin, boolean bl) {
        dragDropPlugin.skipDragGesture = bl;
    }

    static boolean ra$needsFocusWorkaround() {
        return needsFocusWorkaround;
    }

    static DataFlavor[] ra$ourFlavors() {
        return ourFlavors;
    }

    static void wa$ourFlavors(DataFlavor[] dataFlavorArray) {
        ourFlavors = dataFlavorArray;
    }

    protected class DragCaret
    extends BasicCaret {
        public void focusGained(FocusEvent event) {
            super.focusGained(event);
            if (DragDropPlugin.ra$needsFocusWorkaround()) {
                DragDropPlugin.this.focusWasGained = true;
                if (DragDropPlugin.this.selectionClicked) {
                    DragDropPlugin.wa$skipDragGesture(DragDropPlugin.this, true);
                    DragDropPlugin.this.selectionClicked = false;
                }
            }
        }

        public void mouseClicked(MouseEvent event) {
            if (DragDropPlugin.this.dragInProgress || DragDropPlugin.this.selectionClicked) {
                return;
            }
            super.mouseClicked(event);
        }

        public void mouseDragged(MouseEvent event) {
            if (DragDropPlugin.this.dragInProgress || DragDropPlugin.this.selectionClicked) {
                return;
            }
            super.mouseDragged(event);
        }

        public void mousePressed(MouseEvent event) {
            DragDropPlugin.this.queuedPopupTrigger = false;
            if (DragDropPlugin.this.dragInProgress) {
                return;
            }
            if (event.getClickCount() > 1) {
                super.mousePressed(event);
                return;
            }
            if (DragDropPlugin.this.focusWasGained) {
                super.mousePressed(event);
                return;
            }
            int offset = this.getOffsetForMouseEvent(event);
            if (this.offsetInSelection(offset)) {
                DragDropPlugin.this.selectionClicked = true;
                DragDropPlugin.this.queuedPopupTrigger = event.isPopupTrigger();
            } else {
                super.mousePressed(event);
            }
        }

        protected boolean offsetInSelection(int offset) {
            int end;
            int start = Math.min(this.getDot(), this.getMark());
            return start != (end = Math.max(this.getDot(), this.getMark())) && start <= offset && offset < end;
        }

        public void mouseReleased(MouseEvent event) {
            if (DragDropPlugin.this.dragInProgress) {
                return;
            }
            if (DragDropPlugin.this.selectionClicked || DragDropPlugin.ra$skipDragGesture(DragDropPlugin.this)) {
                DragDropPlugin.this.selectionClicked = false;
                DragDropPlugin.wa$skipDragGesture(DragDropPlugin.this, false);
                MouseEvent pressedEvent = new MouseEvent((Component)event.getSource(), 501, event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), DragDropPlugin.this.queuedPopupTrigger, event.getButton());
                super.mousePressed(pressedEvent);
                DragDropPlugin.this.queuedPopupTrigger = false;
            }
            DragDropPlugin.this.focusWasGained = false;
            super.mouseReleased(event);
        }

        public boolean isVisible() {
            return !DragDropPlugin.this.dragInProgress && super.isVisible();
        }

        protected DragCaret() {
        }
    }

    protected class DragTransferable
    implements Transferable {
        private String data;

        protected DragTransferable() {
            this.data = DragDropPlugin.this.editor.getSelectedText();
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (DragDropPlugin.ra$ourFlavors() == null) {
                DragDropPlugin.wa$ourFlavors(new DataFlavor[]{OUR_FLAVOR, DropTargetPlugin.STRING_FLAVOR});
            }
            return DragDropPlugin.ra$ourFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(OUR_FLAVOR) || flavor.equals(DropTargetPlugin.STRING_FLAVOR);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(OUR_FLAVOR)) {
                return this;
            }
            if (flavor.equals(DropTargetPlugin.STRING_FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected BasicEditorPane getEditorPane() {
            return DragDropPlugin.this.editor;
        }
    }
}

