/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;

public final class FindHighlightPlugin
implements EditorPlugin,
DocumentListener {
    private static final boolean FORWARD = true;
    private static final boolean BACKWARDS = false;
    private static HighlightStyle findStyle;
    private HighlightLayer highlightLayer = null;
    private BasicEditorPane editor = null;
    private String lastSearchText = null;
    private boolean lastMatchCase = false;
    private boolean lastWholeWordOnly = false;
    private ArrayList offsetList = new ArrayList();
    private ArrayList highlightList = new ArrayList();
    private ArrayList tempOffsetList = new ArrayList();
    private ArrayList tempHighlightList = new ArrayList();
    public static final int DEFAULT_FIND_PRIORITY = 60;
    public static final String HIGHLIGHT_FIND_RESULT = "find-results-highlight";

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        Document document = editor.getDocument();
        document.addDocumentListener(this);
    }

    public void deinstall(BasicEditorPane editor) {
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
                if (this.highlightLayer != null) {
                    this.highlightLayer.removeAllHighlights();
                }
                this.highlightList.clear();
                this.offsetList.clear();
                if (this.lastSearchText != null) {
                    this.updateFindRegion(0, document.getLength());
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.insertUpdate(event.getOffset(), event.getLength());
    }

    public void removeUpdate(DocumentEvent event) {
        this.removeUpdate(event.getOffset(), event.getLength());
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean highlightOccurrences) {
        return this.findText(searchText, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean wholeWordOnly, boolean highlightOccurrences) {
        if (highlightOccurrences) {
            boolean redoSearch = false;
            if (this.lastSearchText == null) {
                redoSearch = true;
            } else if (!searchText.equals(this.lastSearchText) || matchCase != this.lastMatchCase || wholeWordOnly != this.lastWholeWordOnly) {
                redoSearch = true;
            }
            if (redoSearch) {
                this.clearFindHighlighting();
                this.performFindHighlighting(searchText, matchCase, wholeWordOnly);
            }
            int foundOffset = -1;
            int listSize = this.offsetList.size();
            if (searchForward) {
                int i = 0;
                while (i < listSize) {
                    int highlightOffset = (Integer)this.offsetList.get(i);
                    if (highlightOffset >= startOffset) {
                        foundOffset = highlightOffset;
                        break;
                    }
                    ++i;
                }
                if (wrapAround && foundOffset == -1) {
                    int i2 = 0;
                    while (i2 < listSize) {
                        int highlightOffset = (Integer)this.offsetList.get(i2);
                        if (highlightOffset < startOffset) {
                            foundOffset = highlightOffset;
                            break;
                        }
                        ++i2;
                    }
                }
            } else {
                int textLength = searchText.length();
                int i = listSize - 1;
                while (i >= 0) {
                    int highlightOffset = (Integer)this.offsetList.get(i);
                    if (highlightOffset + textLength <= startOffset) {
                        foundOffset = highlightOffset;
                        break;
                    }
                    --i;
                }
                if (wrapAround && foundOffset == -1) {
                    int i3 = listSize - 1;
                    while (i3 >= 0) {
                        int highlightOffset = (Integer)this.offsetList.get(i3);
                        if (highlightOffset + textLength > startOffset) {
                            foundOffset = highlightOffset;
                            break;
                        }
                        --i3;
                    }
                }
            }
            return foundOffset;
        }
        this.clearFindHighlighting();
        Document document = this.editor.getDocument();
        int foundOffset = -1;
        if (searchForward) {
            foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, startOffset, document.getLength());
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, 0, startOffset);
            }
        } else {
            foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, 0, startOffset);
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, startOffset, document.getLength());
            }
        }
        return foundOffset;
    }

    public void clearFindHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.lastSearchText = null;
        this.offsetList.clear();
        this.highlightList.clear();
    }

    public boolean hasFindHighlighting() {
        return this.lastSearchText != null;
    }

    public boolean getFirstHighlightAfter(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, new Integer(position));
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this.offsetList.size()) {
            Integer intValue = (Integer)this.offsetList.get(i);
            int offset = intValue;
            if (offset > position) {
                HighlightedText highlightedText = (HighlightedText)this.highlightList.get(i);
                range[0] = offset;
                range[1] = highlightedText.getEndOffset();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getFirstHighlightBefore(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, new Integer(position));
        if (i < 0) {
            i = -i - 1;
        }
        while (--i >= 0) {
            Integer intValue = (Integer)this.offsetList.get(i);
            int offset = intValue;
            if (offset >= position) continue;
            HighlightedText highlightedText = (HighlightedText)this.highlightList.get(i);
            range[0] = offset;
            range[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    private void performFindHighlighting(String searchText, boolean matchCase, boolean wholeWordOnly) {
        if (searchText == null) {
            return;
        }
        if (this.editor == null || this.editor.getDocument() == null) {
            return;
        }
        this.lastSearchText = searchText;
        this.lastMatchCase = matchCase;
        this.lastWholeWordOnly = wholeWordOnly;
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        ReadTextBuffer textBuffer = (ReadTextBuffer)document.getTextBuffer();
        document.readLock();
        try {
            this.updateFindRegion(0, document.getLength());
        }
        finally {
            document.readUnlock();
        }
    }

    private void insertUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = offset;
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            int i = 0;
            while (i < listSize) {
                int highlightOffset = (Integer)this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) break;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            HighlightedText highlightToRemove = (HighlightedText)this.highlightList.get(i);
                            highlightLayer.removeHighlight(highlightToRemove);
                            break;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset += count));
                    }
                }
                ++i;
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                int i2 = 0;
                while (i2 < countToRemove) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                    ++i2;
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + count + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void removeUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = Math.min(document.getLength(), offset + count);
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            int i = 0;
            while (i < listSize) {
                int highlightOffset = (Integer)this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) break;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            HighlightedText highlightToRemove = (HighlightedText)this.highlightList.get(i);
                            highlightLayer.removeHighlight(highlightToRemove);
                            break;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset -= count));
                    }
                }
                ++i;
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                int i2 = 0;
                while (i2 < countToRemove) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                    ++i2;
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void updateFindRegion(int startOffset, int endOffset) {
        int listSize;
        if (this.lastSearchText == null) {
            return;
        }
        int insertPoint = listSize = this.offsetList.size();
        int i = 0;
        while (i < listSize) {
            int highlightOffset = (Integer)this.offsetList.get(i);
            if (highlightOffset > startOffset) {
                insertPoint = i;
                break;
            }
            ++i;
        }
        HighlightLayer highlightLayer = this.getHighlightLayer();
        int searchLen = this.lastSearchText.length();
        highlightLayer.beginBlockUpdate();
        try {
            int currentOffset = startOffset;
            while (currentOffset < endOffset) {
                int foundOffset = this.findTextInternal(this.lastSearchText, true, this.lastMatchCase, this.lastWholeWordOnly, currentOffset, endOffset);
                if (foundOffset == -1) {
                    break;
                }
                HighlightedText entry = highlightLayer.addHighlight(findStyle, foundOffset, foundOffset + searchLen);
                this.tempOffsetList.add(new Integer(foundOffset));
                this.tempHighlightList.add(entry);
                currentOffset = foundOffset + 1;
            }
        }
        finally {
            highlightLayer.endBlockUpdate();
        }
        if (this.tempOffsetList.size() > 0) {
            this.offsetList.addAll(insertPoint, this.tempOffsetList);
            this.highlightList.addAll(insertPoint, this.tempHighlightList);
        }
        this.tempOffsetList.clear();
        this.tempHighlightList.clear();
    }

    private int findTextInternal(String searchText, boolean searchForward, boolean matchCase, boolean wholeWordOnly, int startOffset, int endOffset) {
        BasicDocument doc = (BasicDocument)this.editor.getDocument();
        TextBuffer textBuffer = doc.getTextBuffer();
        textBuffer.readLock();
        try {
            int foundOffset;
            while (true) {
                foundOffset = -1;
                foundOffset = matchCase ? (searchForward ? this.searchForwardMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset) : this.searchBackwardMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset)) : (searchForward ? this.searchForwardNoMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset) : this.searchBackwardNoMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset));
                if (foundOffset == -1 || !wholeWordOnly || this.isWholeWordMatch(doc, foundOffset, searchText.length())) break;
                if (searchForward) {
                    startOffset = foundOffset + 1;
                    continue;
                }
                endOffset = foundOffset - 1;
            }
            int n = foundOffset;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private boolean isWholeWordMatch(BasicDocument document, int startOffset, int length) {
        int endOffset = startOffset + length;
        int wordStart = Utilities.getWordStart(document, startOffset);
        int wordEnd = Utilities.getWordEnd(document, endOffset - 1);
        return wordStart == startOffset && wordEnd == endOffset;
    }

    private int searchForwardMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchForwardNoMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardNoMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    static {
        FindHighlightPlugin.registerHighlights();
    }

    public static void registerHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("FIND_OCCURRENCE_HIGHLIGHT");
        findStyle = registry.createStyle(HIGHLIGHT_FIND_RESULT, name, 60, Color.black, new Color(200, 180, 220));
    }
}

