/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;

public final class LineHighlightPlugin
implements CaretListener,
DocumentListener,
EditorPlugin {
    private BasicEditorPane editor;
    private HighlightedText lineHighlight;
    private HighlightLayer highlightLayer;
    public static final int DEFAULT_LINE_PRIORITY = 10;
    public static final String CARET_LINE_HIGHLIGHT = "caret-line-highlight";
    private static HighlightStyle highlightStyle;

    public LineHighlightPlugin() {
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(BasicEditorPane editor) {
        LineHighlightPlugin lineHighlightPlugin = this;
        synchronized (lineHighlightPlugin) {
            this.editor = editor;
        }
        editor.addCaretListener(this);
        Document document = editor.getDocument();
        document.addDocumentListener(this);
        this.updateHighlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(BasicEditorPane editor) {
        this.removeHighlightLayer();
        editor.removeCaretListener(this);
        LineHighlightPlugin lineHighlightPlugin = this;
        synchronized (lineHighlightPlugin) {
            this.editor = null;
        }
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("document")) {
            Object newValue;
            this.clearHighlight();
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
            }
            this.updateHighlight();
        }
    }

    public void caretUpdate(CaretEvent event) {
        this.updateHighlight();
    }

    public void insertUpdate(DocumentEvent event) {
        this.updateHighlight();
    }

    public void removeUpdate(DocumentEvent event) {
        this.updateHighlight();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void $init$() {
        this.lineHighlight = null;
        this.highlightLayer = null;
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private synchronized void removeHighlightLayer() {
        if (this.highlightLayer != null) {
            this.editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
            this.lineHighlight = null;
        }
    }

    private synchronized HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private synchronized void clearHighlight() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.lineHighlight = null;
    }

    private synchronized void updateHighlight() {
        BasicDocument document = this.getDocument();
        if (document != null) {
            document.readLock();
            try {
                LineMap lineMap = document.getLineMap();
                int caretOffset = this.editor.getCaretPosition();
                int caretLine = lineMap.getLineFromOffset(caretOffset);
                HighlightLayer layer = this.getHighlightLayer();
                if (this.lineHighlight == null) {
                    this.lineHighlight = layer.addLineHighlight(highlightStyle, caretLine);
                } else {
                    int caretLineStart = lineMap.getLineStartOffset(caretLine);
                    int caretLineEnd = lineMap.getLineEndOffset(caretLine);
                    if (this.lineHighlight.getStartOffset() != caretLineStart || this.lineHighlight.getEndOffset() != caretLineEnd) {
                        layer.changeHighlight(this.lineHighlight, caretLineStart, caretLineEnd);
                    }
                }
            }
            finally {
                document.readUnlock();
            }
        }
    }

    static {
        LineHighlightPlugin.registerHighlights();
    }

    public static void registerHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("CARET_LINE_HIGHLIGHT");
        highlightStyle = registry.createStyle(CARET_LINE_HIGHLIGHT, name, true, 10, null, Color.lightGray);
    }
}

