/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.Copyable;

public class HTMLGeneratorOptions
extends HashStructureAdapter
implements Copyable {
    private static final String CHARSET_ENCODING = "charsetEncoding";
    private static final String PRINT_COLORS = "printColors";
    private static final String PRINT_FONT_STYLES = "printFontStyles";
    private static final String WRAP_BEHAVIOR = "wrapBehavior";
    public static final int WRAP_NONE = 0;
    public static final int WRAP_FILL_WIDTH = 1;
    private static final String WRAP_COLUMN = "wrapColumn";
    private static final int WRAP_COLUMN_MINIMUM = 10;
    private static final String WRAP_SYMBOL = "wrapSymbol";
    private static final String USE_ANCHORS = "useAnchors";
    private static final String PRINT_LINE_NUMBERS = "printLineNumbers";
    public static final int LINE_NUMBERS_NONE = 0;
    public static final int LINE_NUMBERS_EVERY = 1;
    private static final String PRINT_FILE_HEADER = "printFileHeader";
    private static final String PRINT_TIME_STAMP = "printTimeStamp";
    private static final String USE_FONT_INFO = "useFontInfo";
    private static final String FONT_FAMILY = "fontFamily";
    private static final String FONT_SIZE = "fontSize";

    public HTMLGeneratorOptions() {
        this(HashStructure.newInstance());
    }

    public HTMLGeneratorOptions(HashStructure hash) {
        super(hash);
    }

    public Object clone() {
        return this.copyTo(null);
    }

    public String getCharsetEncoding() {
        return this._hash.getString(CHARSET_ENCODING, "utf-8");
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this._hash.putString(CHARSET_ENCODING, charsetEncoding);
    }

    public boolean getPrintColors() {
        return this._hash.getBoolean(PRINT_COLORS, true);
    }

    public void setPrintColors(boolean printColors) {
        this._hash.putBoolean(PRINT_COLORS, printColors);
    }

    public boolean getPrintFontStyles() {
        return this._hash.getBoolean(PRINT_FONT_STYLES, true);
    }

    public void setPrintFontStyles(boolean printFontStyles) {
        this._hash.putBoolean(PRINT_FONT_STYLES, printFontStyles);
    }

    public int getWrapBehavior() {
        return this._hash.getInt(WRAP_BEHAVIOR, 0);
    }

    public void setWrapBehavior(int wrapBehavior) {
        this._hash.putInt(WRAP_BEHAVIOR, wrapBehavior);
    }

    public int getWrapColumn() {
        return this._hash.getInt(WRAP_COLUMN, 80);
    }

    public void setWrapColumn(int wrapColumn) {
        this._hash.putInt(WRAP_COLUMN, Math.max(wrapColumn, 10));
    }

    public String getWrapSymbol() {
        return this._hash.getString(WRAP_SYMBOL, "\\");
    }

    public void setWrapSymbol(String wrapSymbol) {
        this._hash.putString(WRAP_SYMBOL, wrapSymbol);
    }

    public boolean getUseAnchors() {
        return this._hash.getBoolean(USE_ANCHORS, true);
    }

    public void setUseAnchors(boolean useAnchors) {
        this._hash.putBoolean(USE_ANCHORS, useAnchors);
    }

    public int getPrintLineNumbers() {
        return this._hash.getInt(PRINT_LINE_NUMBERS, 1);
    }

    public void setPrintLineNumbers(int printLineNumbers) {
        this._hash.putInt(PRINT_LINE_NUMBERS, printLineNumbers);
    }

    public boolean getPrintFileHeader() {
        return this._hash.getBoolean(PRINT_FILE_HEADER, true);
    }

    public void setPrintFileHeader(boolean printFileHeader) {
        this._hash.putBoolean(PRINT_FILE_HEADER, printFileHeader);
    }

    public boolean getPrintTimeStamp() {
        return this._hash.getBoolean(PRINT_TIME_STAMP, true);
    }

    public void setPrintTimeStamp(boolean printTimeStamp) {
        this._hash.putBoolean(PRINT_TIME_STAMP, printTimeStamp);
    }

    public boolean getUseFontInfo() {
        return this._hash.getBoolean(USE_FONT_INFO, false);
    }

    public void setUseFontInfo(boolean useFontInfo) {
        this._hash.putBoolean(USE_FONT_INFO, useFontInfo);
    }

    public String getFontFamily() {
        return this._hash.getString(FONT_FAMILY, "DialogInput");
    }

    public void setFontFamily(String fontFamily) {
        this._hash.putString(FONT_FAMILY, fontFamily);
    }

    public int getFontSize() {
        return this._hash.getInt(FONT_SIZE, 12);
    }

    public void setFontSize(int fontSize) {
        this._hash.putInt(FONT_SIZE, fontSize);
    }
}

