/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.history;

import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import oracle.javatools.controls.nicetable.NiceTableAutoSizeModel;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;
import oracle.javatools.history.HistoryProperty;

final class TableModelAdapter
extends AbstractTableModel
implements NiceTableModel,
NiceTableAutoSizeModel,
HistoryModelListener {
    private final HistoryModel _baseModel;
    private final HistoryProperty[] _properties;
    private boolean _useAutoSizeMaximums;

    private void $init$() {
        this._useAutoSizeMaximums = false;
    }

    TableModelAdapter(HistoryModel baseModel) {
        this.$init$();
        this._baseModel = baseModel;
        this._properties = this._baseModel.getProperties();
        this._baseModel.addHistoryModelListener(this);
    }

    public HistoryProperty getProperty(int column) {
        return this._properties[column];
    }

    public Class getColumnClass(int column) {
        return this._properties[column].getType();
    }

    public int getColumnAlignment(int column) {
        return this._properties[column].getPreferredAlignment();
    }

    public int getSortColumn() {
        return 0;
    }

    public Comparator getColumnSortComparator(int column) {
        return this._properties[column].getComparator();
    }

    public boolean isColumnVisible(int column) {
        return true;
    }

    public int getRowCount() {
        return this._baseModel.getSize();
    }

    public int getColumnCount() {
        return this._properties.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._baseModel.getEntry(rowIndex).getValue(this._properties[columnIndex]);
    }

    public String getColumnName(int col) {
        return this._properties[col].getName();
    }

    public void entriesInserted(HistoryModelEvent vhe) {
        super.fireTableRowsInserted(vhe.getStart(), vhe.getEnd());
    }

    public void entriesRemoved(HistoryModelEvent vhe) {
        super.fireTableRowsDeleted(vhe.getStart(), vhe.getEnd());
    }

    public void entriesChanged(HistoryModelEvent vhe) {
        super.fireTableRowsUpdated(vhe.getStart(), vhe.getEnd());
    }

    public void completenessChanged(HistoryModelEvent vhe) {
    }

    public void setUseAutoSizeMaximums(boolean useAutoSizeMaximums) {
        this._useAutoSizeMaximums = useAutoSizeMaximums;
    }

    public int getColumnAutoSizeMaximum(int column) {
        return this._useAutoSizeMaximums ? this.getProperty(column).getAutoSizeMaximum() : Integer.MAX_VALUE;
    }
}

