/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal.xml;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.OmittedWhenNullMarker;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.marshal.xml.PropertyInfo;

public final class PropertyIterator {
    private static final HashMap _infoCache = new HashMap();
    private final PropertyInfo[] _propertyInfos;
    private int _curIndex;

    private void $init$() {
        this._curIndex = 0;
    }

    public PropertyIterator(Object bean) {
        this.$init$();
        this._propertyInfos = bean != null ? PropertyIterator.getPropertyInfos(bean.getClass()) : null;
    }

    public boolean hasNext() {
        return this._propertyInfos == null ? false : this._curIndex < this._propertyInfos.length;
    }

    public PropertyInfo next() {
        return this._propertyInfos[this._curIndex++];
    }

    private static PropertyInfo[] getPropertyInfos(Class beanClass) {
        Object cached = _infoCache.get(beanClass);
        if (cached != null) {
            return (PropertyInfo[])cached;
        }
        PropertyInfo[] explicitInfos = PropertyIterator.getExplicitPropertyInfos(beanClass);
        if (explicitInfos != null) {
            _infoCache.put(beanClass, explicitInfos);
            return explicitInfos;
        }
        Method[] methods = beanClass.getMethods();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        int i = methods.length - 1;
        while (i >= 0) {
            Method method = methods[i];
            String name = method.getName();
            if (name.startsWith("get") && PropertyIterator.hasNoParameters(method) && PropertyIterator.isPersistent(method)) {
                String property = name.substring(3);
                getters.put(property, method);
            } else if (name.startsWith("is") && PropertyIterator.hasNoParameters(method) && PropertyIterator.hasBooleanReturnType(method) && PropertyIterator.isPersistent(method)) {
                String property = name.substring(2);
                getters.put(property, method);
            }
            --i;
        }
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        int i2 = methods.length - 1;
        while (i2 >= 0) {
            Method setter;
            Class<?> setterType;
            Method getter;
            Class<?> getterType;
            String propertyName;
            Method method = methods[i2];
            String name = method.getName();
            if (name.startsWith("set") && PropertyIterator.hasOneParameter(method) && PropertyIterator.hasVoidReturnType(method) && getters.containsKey(propertyName = name.substring(3)) && (getterType = (getter = (Method)getters.get(propertyName)).getReturnType()) == (setterType = (setter = method).getParameterTypes()[0])) {
                String xmlName = Introspector.decapitalize(propertyName);
                boolean isAttribute = PropertyIterator.isAttribute(getter);
                boolean isOmittedWhenNull = PropertyIterator.isOmittedWhenNull(getter);
                PropertyInfo propertyInfo = new PropertyInfo(xmlName, getter, setter, isAttribute, isOmittedWhenNull);
                properties.add(propertyInfo);
            }
            --i2;
        }
        Object[] propertyInfos = properties.toArray(new PropertyInfo[0]);
        Arrays.sort(propertyInfos);
        _infoCache.put(beanClass, propertyInfos);
        return propertyInfos;
    }

    private static PropertyInfo[] getExplicitPropertyInfos(Class beanClass) {
        try {
            Method method = beanClass.getMethod("getPropertyInfos", null);
            PropertyInfo[] propertyInfoArray = (PropertyInfo[])method.invoke(null, null);
            return propertyInfoArray;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasNoParameters(Method method) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 0;
    }

    private static boolean hasOneParameter(Method method) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 1;
    }

    private static boolean hasBooleanReturnType(Method method) {
        Class<?> type = method.getReturnType();
        return type == Boolean.TYPE;
    }

    private static boolean hasVoidReturnType(Method method) {
        Class<?> type = method.getReturnType();
        return type == Void.TYPE;
    }

    private static boolean isPersistent(Method method) {
        return PropertyIterator.throwsException(method, TransientMarker.class) ^ true;
    }

    private static boolean isOmittedWhenNull(Method method) {
        return PropertyIterator.throwsException(method, OmittedWhenNullMarker.class);
    }

    private static boolean isAttribute(Method method) {
        return PropertyIterator.throwsException(method, AttributeMarker.class);
    }

    private static boolean throwsException(Method method, Class exceptionType) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        int i = exceptionTypes.length - 1;
        while (i >= 0) {
            if (exceptionTypes[i] == exceptionType) {
                return true;
            }
            --i;
        }
        return false;
    }
}

