/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.awt.Component;
import javax.swing.JScrollPane;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchModel;

public final class PatchCompareView
implements CompareView {
    private final BasicEditorPane _editorPane;
    private CompareModel _compareModel;
    private JScrollPane _scrollPane;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._editorPane = new BasicEditorPane();
        this._scrollPane = new JScrollPane(this._editorPane);
    }

    static {
        $assertionsDisabled = PatchCompareView.class.desiredAssertionStatus() ^ true;
    }

    public PatchCompareView(CompareMode compareMode) {
        this.$init$();
        if (!$assertionsDisabled && compareMode != CompareMode.TWO_WAY_COMPARE) {
            throw new AssertionError();
        }
        this._editorPane.setEditable(false);
    }

    public void setModel(CompareModel compareModel) {
        if (compareModel == null) {
            this._compareModel = null;
            return;
        }
        if (!$assertionsDisabled && compareModel.getType() != CompareType.TEXT) {
            throw new AssertionError();
        }
        TextBuffer buffer = TextBufferFactory.createTextBuffer();
        PatchModel patchModel = new PatchModel();
        PatchEntry patchEntry = PatchEngine.createPatchEntry((SequenceCompareModel)((SequenceCompareModel)compareModel));
        patchEntry.setFromFile(compareModel.getContributor(ContributorKind.FIRST).getShortLabel());
        patchEntry.setToFile(compareModel.getContributor(ContributorKind.SECOND).getShortLabel());
        patchModel.addEntry(patchEntry);
        buffer.append(new PatchFormat().format(patchModel).toCharArray());
        this._editorPane.setDocument(new BasicDocument(".diff", buffer));
        this._compareModel = compareModel;
    }

    public CompareModel getModel() {
        return this._compareModel;
    }

    public Component getGUI() {
        return this._scrollPane;
    }
}

