/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementProxy;
import oracle.javatools.xml.bind.IndentPrefs;
import oracle.javatools.xml.bind.XMLBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMBindingRuntime {
    private static IndentPrefs _defaultIndentPrefs = new IndentPrefs();
    final Document _document;
    private final ElementProxy _handler;
    final XMLBinding _binding;
    private final Class _rootInterface;
    private Object _proxy;
    final String _eol;
    boolean _enableWhitespace;
    private IndentPrefs _indent;

    private void $init$() {
        this._eol = "\n";
        this._enableWhitespace = true;
    }

    public DOMBindingRuntime(Document document, XMLBinding binding) {
        this.$init$();
        DOMBindingRuntime.checkNull(document, "document must not be null");
        DOMBindingRuntime.checkNull(binding, "binding must not be null");
        this._document = document;
        Element rootElem = document.getDocumentElement();
        if (rootElem == null) {
            throw new NullPointerException("document root element must not be null");
        }
        BindingContext bc = new BindingContext(this, binding.getRootInterface(), rootElem, 1);
        this._handler = new ElementProxy(bc);
        this._binding = binding;
        this._rootInterface = binding.getRootInterface();
        DOMBindingRuntime.checkNull(this._rootInterface, "root interface must not be null");
    }

    public static Element getBoundElement(Object proxyObj) {
        if (proxyObj != null) {
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(proxyObj);
                if (handler instanceof ElementProxy) {
                    Element element = ((ElementProxy)handler)._bc._contextElem;
                    return element;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void checkNull(Object obj, String npeMesg) {
        if (obj == null) {
            throw new NullPointerException(npeMesg);
        }
    }

    public static void setDefaultIndentPrefs(IndentPrefs defaultIndentPrefs) {
        if (defaultIndentPrefs != null) {
            _defaultIndentPrefs = defaultIndentPrefs;
        }
    }

    public void setIndentWidth(int width, boolean useTabs) {
        this.setIndentWidth(width, useTabs, 8);
    }

    public void setIndentWidth(int width, boolean useTabs, int tabSize) {
        this._indent = new 1(this, width, useTabs, tabSize);
    }

    public void setEnableWhitespace(boolean enableWhitespace) {
        this._enableWhitespace = enableWhitespace;
    }

    char[] getIndent(int depth) {
        if (depth == 0 || this._indent.getWidth() == 0) {
            return new char[0];
        }
        int width = this._indent.getWidth();
        width = Math.max(width, 0);
        width = Math.min(width, 1000);
        int numSpaces = depth * width;
        int numTabs = 0;
        if (!this._indent.getUseSpaces()) {
            int tabSize = this._indent.getTabSize();
            if (tabSize <= 0) {
                tabSize = 8;
            }
            numTabs = numSpaces / tabSize;
            numSpaces %= tabSize;
        }
        char[] chars = new char[numTabs + numSpaces];
        int i = 0;
        while (i < numTabs) {
            chars[i] = 9;
            ++i;
        }
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        return chars;
    }

    public Object getProxy() {
        if (this._proxy == null) {
            this._proxy = BindingContext.createProxy(this._rootInterface, this._handler);
        }
        if (this._indent == null) {
            this.setIndentWidth(_defaultIndentPrefs.getWidth(), _defaultIndentPrefs.getUseSpaces() ^ true, _defaultIndentPrefs.getTabSize());
        }
        return this._proxy;
    }

    final class 1
    extends IndentPrefs {
        private final /* synthetic */ int v$width;
        private final /* synthetic */ boolean v$useTabs;
        private final /* synthetic */ int v$tabSize;
        final /* synthetic */ DOMBindingRuntime this$0;

        public int getWidth() {
            return this.v$width;
        }

        public boolean getUseSpaces() {
            return this.v$useTabs ^ true;
        }

        public int getTabSize() {
            return this.v$tabSize;
        }

        public 1(DOMBindingRuntime dOMBindingRuntime, int n, boolean bl, int n2) {
            this.v$tabSize = n2;
            this.v$useTabs = bl;
            this.v$width = n;
            this.this$0 = dOMBindingRuntime;
        }
    }
}

