/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.util.Iterator;
import javax.swing.event.EventListenerList;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementListImpl
extends BindingContext
implements ElementList {
    final XMLBindingInfo _info;
    private final boolean _isStringType;
    private final ElementFilter _filter;
    private EventListenerList _elementListListeners;

    ElementListImpl(BindingContext bc, XMLBindingInfo info, ElementFilter filter) {
        super(bc);
        this._info = info;
        this._isStringType = info != null && info._propertyType == String.class;
        this._filter = filter != null ? filter : new ElementFilter();
    }

    public void add(Object obj) {
        XMLBindingInfo info = this.checkArgType(obj);
        Element newElem = this.listExtractElementFromProxy(obj);
        this.insertElem(info, newElem);
        if (this._elementListListeners != null) {
            int index = this.size() - 1;
            this.fireElementsAdded(index, index);
        }
    }

    public void add(int index, Object obj) {
        NodeList nodes = this.nodes();
        int n = nodes.getLength();
        if (index < 0 || index > n) {
            throw new IndexOutOfBoundsException();
        }
        if (index == n) {
            this.add(obj);
        } else {
            this.checkArgType(obj);
            Element newElem = this.listExtractElementFromProxy(obj);
            Element curElem = (Element)nodes.item(index);
            this.insertElement(newElem, curElem);
            this.fireElementsAdded(index, index);
        }
    }

    @Override
    public void addElementListListener(ElementListListener listener) {
        if (this._elementListListeners == null) {
            this._elementListListeners = new EventListenerList();
        }
        this._elementListListeners.add(ElementListListener.class, listener);
    }

    @Override
    public void clear() {
        NodeList nodes = this.nodes();
        int n = nodes.getLength();
        int i = 0;
        while (i < n) {
            ElementListImpl.deleteElement((Element)nodes.item(i));
            ++i;
        }
        if (n > 0) {
            this.fireElementsRemoved(0, n - 1);
        }
    }

    public Object createElement() {
        return this.callCreateImpl(this._info);
    }

    @Override
    public Class elementType() {
        return this._info._propertyType;
    }

    @Override
    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        NodeList nodes = this.nodes();
        if (index >= nodes.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Element elem = (Element)nodes.item(index);
        return this.createProxy(elem);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator iterator() {
        NodeList nodes = this.nodes();
        return new 1(this, nodes);
    }

    public Object remove(int index) {
        Element elem = (Element)this.nodes().item(index);
        return this.removeImpl(elem, this.createProxy(elem), index);
    }

    @Override
    public void removeElementListListener(ElementListListener listener) {
        if (this._elementListListeners != null) {
            this._elementListListeners.remove(ElementListListener.class, listener);
        }
    }

    public Object set(int index, Object obj) {
        Element curElem = (Element)this.nodes().item(index);
        XMLBindingInfo info = this.checkArgType(obj);
        Element newElem = this.listExtractElementFromProxy(obj);
        this.setElement(newElem, curElem, info);
        this.fireElementsChanged(index, index);
        return this.createProxy(curElem);
    }

    @Override
    public int size() {
        return this.nodes().getLength();
    }

    final ElementFilter getElementFilter() {
        return this._filter;
    }

    NodeList nodes() {
        return ElementListImpl.getChildrenByQName(this._contextElem, this._info._nsURI, this._info._localName, this.getElementFilter());
    }

    Object callCreateImpl(XMLBindingInfo info) {
        return this.callCreateImpl(info, info._propertyType);
    }

    private Object removeImpl(Element elem, Object itemProxy, int index) {
        ElementListImpl.deleteElement(elem);
        this.fireElementsRemoved(index, index);
        return itemProxy;
    }

    XMLBindingInfo checkArgType(Object arg) {
        if (this._info._propertyType.isAssignableFrom(arg.getClass())) {
            return this._info;
        }
        throw new ClassCastException("Wrong type passed to ElementList.");
    }

    Object createProxy(Element elem) {
        if (this._isStringType) {
            return ElementListImpl.getTextValue(elem);
        }
        return this.createProxy(elem, this._info);
    }

    Object createProxy(Element elem, XMLBindingInfo info) {
        return this.createProxy(elem, info._propertyType, info.getType());
    }

    private Element listExtractElementFromProxy(Object obj) {
        if (this._isStringType) {
            Element newElem = this.createElement(this._info);
            Text newText = this._rt._document.createTextNode(obj.toString());
            newElem.appendChild(newText);
            return newElem;
        }
        return ElementListImpl.extractElementFromProxy(obj);
    }

    private void fireElementsAdded(int start, int end) {
        if (this._elementListListeners != null) {
            Object[] listeners = this._elementListListeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent(this, start, end);
                    }
                    try {
                        ((ElementListListener)listeners[i + 1]).elementsAdded(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                i -= 2;
            }
        }
    }

    private void fireElementsRemoved(int start, int end) {
        if (this._elementListListeners != null) {
            Object[] listeners = this._elementListListeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent(this, start, end);
                    }
                    try {
                        ((ElementListListener)listeners[i + 1]).elementsRemoved(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                i -= 2;
            }
        }
    }

    private void fireElementsChanged(int start, int end) {
        if (this._elementListListeners != null) {
            Object[] listeners = this._elementListListeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent(this, start, end);
                    }
                    try {
                        ((ElementListListener)listeners[i + 1]).elementsChanged(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                i -= 2;
            }
        }
    }

    static Object mav$removeImpl(ElementListImpl elementListImpl, Element element, Object object, int n) {
        return elementListImpl.removeImpl(element, object, n);
    }

    final class 1
    implements Iterator {
        private final /* synthetic */ NodeList v$nodes;
        private final int _n;
        private int _i;
        private int _removeCount;
        private Element _elem;
        private Object _itemProxy;
        final /* synthetic */ ElementListImpl this$0;

        private void $init$() {
            this._n = this.v$nodes.getLength();
            this._i = 0;
            this._removeCount = 0;
        }

        public boolean hasNext() {
            return this._i < this._n;
        }

        public Object next() {
            this._elem = (Element)this.v$nodes.item(this._i++);
            this._itemProxy = this.this$0.createProxy(this._elem);
            return this._itemProxy;
        }

        public void remove() {
            if (this._elem == null) {
                throw new IllegalStateException();
            }
            try {
                ElementListImpl.mav$removeImpl(this.this$0, this._elem, this._itemProxy, this._i - ++this._removeCount);
            }
            finally {
                this._elem = null;
                this._itemProxy = null;
            }
        }

        public 1(ElementListImpl elementListImpl, NodeList nodeList) {
            this.v$nodes = nodeList;
            this.this$0 = elementListImpl;
            this.$init$();
        }
    }
}

