/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementListImpl;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class MixedElementListImpl
extends ElementListImpl {
    private final XMLBindingInfo[] _listItemBindings;

    MixedElementListImpl(BindingContext bc, XMLBindingInfo[] listItemBindings) {
        this(bc, listItemBindings, null);
    }

    MixedElementListImpl(BindingContext bc, XMLBindingInfo[] listItemBindings, ElementFilter filter) {
        super(bc, null, filter);
        this._listItemBindings = listItemBindings;
    }

    public Object createElement() {
        throw new IllegalStateException("createElement() is unavailable when an ElementList contains elements of different names");
    }

    public Class elementType() {
        return null;
    }

    NodeList nodes() {
        NodeListImpl nodeList = new NodeListImpl();
        Node curNode = this._contextElem.getFirstChild();
        ElementFilter filter = this.getElementFilter();
        while (curNode != null) {
            Element curElem;
            if (curNode.getNodeType() == 1 && this.findMatchingBinding(curElem = (Element)curNode) != null && filter.accept(curElem)) {
                nodeList.add(curElem);
            }
            curNode = curNode.getNextSibling();
        }
        return nodeList;
    }

    XMLBindingInfo checkArgType(Object arg) {
        Class<?> argClass = arg.getClass();
        int n = this._listItemBindings.length;
        int i = 0;
        while (i < n) {
            XMLBindingInfo binding = this._listItemBindings[i];
            if (binding._propertyType.isAssignableFrom(argClass)) {
                return binding;
            }
            ++i;
        }
        throw new ClassCastException("Wrong type passed to ElementList.");
    }

    Object createProxy(Element elem) {
        XMLBindingInfo binding = this.findMatchingBinding(elem);
        if (binding != null) {
            return this.createProxy(elem, binding);
        }
        throw new IllegalStateException("No XML binding found for the element.");
    }

    private XMLBindingInfo findMatchingBinding(Element elem) {
        String nsURI = elem.getNamespaceURI();
        String lname = elem.getLocalName();
        int n = this._listItemBindings.length;
        int i = 0;
        while (i < n) {
            XMLBindingInfo binding = this._listItemBindings[i];
            if (MixedElementListImpl.areEqual(lname, binding._localName) && MixedElementListImpl.areEqual(nsURI, binding._nsURI)) {
                return binding;
            }
            ++i;
        }
        return null;
    }
}

