/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.IdeAction;
import oracle.ide.diffmerge.DiffMergeConstants;
import oracle.ide.diffmerge.res.ResourceUtil;

public class DiffMergeActions {
    private static Map _actionMap = new HashMap();

    public static final IdeAction getDiffMergeAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.DIFF_MERGE_CMD_ID, DiffMergeActions.getResourceString("DIFF_MERGE_NAME"), DiffMergeActions.getResourceIcon("DIFF_MERGE_ICON"), null);
        return action;
    }

    public static final IdeAction getViewIgnoreWhitespaceAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID, DiffMergeActions.getResourceString("VIEW_IGNORE_WHITESPACE_NAME"), DiffMergeActions.getResourceIcon("VIEW_IGNORE_WHITESPACE_ICON"), null);
        action.putValue("Check", (Object)Boolean.TRUE);
        return action;
    }

    public static final IdeAction getSearchHighlightAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.SEARCH_HIGHLIGHT_CMD_ID, DiffMergeActions.getResourceString("SEARCH_HIGHLIGHT_NAME"), DiffMergeActions.getResourceIcon("SEARCH_HIGHLIGHT_ICON"), KeyStroke.getKeyStroke(72, 10));
        return action;
    }

    public static final IdeAction getSearchClearHighlightsAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.SEARCH_CLEAR_HIGHLIGHTS_CMD_ID, DiffMergeActions.getResourceString("SEARCH_CLEAR_HIGHLIGHTS_NAME"), DiffMergeActions.getResourceIcon("SEARCH_CLEAR_HIGHLIGHTS_ICON"), null);
        return action;
    }

    public static final IdeAction getNavigateFirstDifferenceAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID, DiffMergeActions.getResourceString("NAVIGATE_FIRST_DIFFERENCE_NAME"), DiffMergeActions.getResourceIcon("NAVIGATE_FIRST_DIFFERENCE_ICON"), KeyStroke.getKeyStroke(116, 0));
        return action;
    }

    public static final IdeAction getNavigatePreviousDifferenceAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID, DiffMergeActions.getResourceString("NAVIGATE_PREVIOUS_DIFFERENCE_NAME"), DiffMergeActions.getResourceIcon("NAVIGATE_PREVIOUS_DIFFERENCE_ICON"), KeyStroke.getKeyStroke(117, 0));
        return action;
    }

    public static final IdeAction getNavigateNextDifferenceAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID, DiffMergeActions.getResourceString("NAVIGATE_NEXT_DIFFERENCE_NAME"), DiffMergeActions.getResourceIcon("NAVIGATE_NEXT_DIFFERENCE_ICON"), KeyStroke.getKeyStroke(118, 0));
        return action;
    }

    public static final IdeAction getNavigateLastDifferenceAction() {
        IdeAction action = DiffMergeActions.getAction(DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID, DiffMergeActions.getResourceString("NAVIGATE_LAST_DIFFERENCE_NAME"), DiffMergeActions.getResourceIcon("NAVIGATE_LAST_DIFFERENCE_ICON"), KeyStroke.getKeyStroke(119, 0));
        return action;
    }

    public static final IdeAction getAction(int id, String name, Icon icon, KeyStroke accelerator) {
        IdeAction action = IdeAction.find((int)id);
        if (action != null) {
            return action;
        }
        action = IdeAction.get((int)id);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        action.putValue("Name", (Object)StringUtils.stripMnemonic((String)name));
        action.putValue("ShortDescription", (Object)StringUtils.stripMnemonic((String)name));
        action.putValue("LongDescription", (Object)StringUtils.stripMnemonic((String)name));
        action.putValue("SmallIcon", (Object)(icon != null ? icon : DiffMergeActions.getResourceIcon("SPACER_ICON")));
        action.putValue("MnemonicKey", (Object)(mnemonic != 0 ? new Integer(mnemonic) : null));
        action.putValue("AcceleratorKey", (Object)accelerator);
        _actionMap.put(new Integer(id), action);
        return action;
    }

    public static final IdeAction[] getActions() {
        return _actionMap.values().toArray(new IdeAction[0]);
    }

    public static final IdeAction getAction(int id) {
        return (IdeAction)_actionMap.get(new Integer(id));
    }

    private static final String getResourceString(String name) {
        return ResourceUtil.getResourceBundle().getString(name);
    }

    private static final ImageIcon getResourceIcon(String name) {
        return ResourceUtil.getResourceIcon(name);
    }
}

