/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.diffmerge.DiffMergeActions;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeConstants;
import oracle.ide.diffmerge.DiffMergeEditor;
import oracle.ide.diffmerge.DiffMergeNode;
import oracle.ide.diffmerge.view.DiffMergeView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.editor.BasicEditorPane;

public class DiffMergeController
implements Controller,
ContextMenuListener {
    private static DiffMergeController _instance;
    private ContextMenu _contextMenu;

    private DiffMergeController() {
        this.setControllerOnActions();
    }

    public static DiffMergeController getInstance() {
        if (_instance == null) {
            _instance = new DiffMergeController();
        }
        return _instance;
    }

    protected void setControllerOnActions() {
        this.setControllerOnAction(IdeActions.getEditCopyAction());
        this.setControllerOnAction(IdeActions.getEditCutAction());
        this.setControllerOnAction(IdeActions.getEditDeleteAction());
        this.setControllerOnAction(IdeActions.getEditPasteAction());
        this.setControllerOnAction(IdeActions.getEditRedoAction());
        this.setControllerOnAction(IdeActions.getEditSelectAllAction());
        this.setControllerOnAction(IdeActions.getEditUndoAction());
        this.setControllerOnAction(IdeActions.getFileCloseAction());
        this.setControllerOnAction(IdeActions.getFileExitAction());
        this.setControllerOnAction(IdeActions.getFileOpenAction());
        this.setControllerOnAction(IdeActions.getFileSaveAction());
        this.setControllerOnAction(IdeActions.getHelpAboutAction());
        this.setControllerOnAction(DiffMergeActions.getNavigateFirstDifferenceAction());
        this.setControllerOnAction(DiffMergeActions.getNavigateLastDifferenceAction());
        this.setControllerOnAction(DiffMergeActions.getNavigateNextDifferenceAction());
        this.setControllerOnAction(DiffMergeActions.getNavigatePreviousDifferenceAction());
        this.setControllerOnAction(DiffMergeActions.getSearchClearHighlightsAction());
        this.setControllerOnAction(DiffMergeActions.getSearchHighlightAction());
        this.setControllerOnAction(DiffMergeActions.getViewIgnoreWhitespaceAction());
        this.setControllerOnAction(IdeActions.getViewRefreshAction());
    }

    public boolean update(IdeAction action, Context context) {
        View view;
        if (context != null && (view = context.getView()) instanceof DiffMergeEditor && ((DiffMergeEditor)view).getDiffMergeControl() != null) {
            return this._update(action, context);
        }
        return false;
    }

    private boolean _update(IdeAction action, Context context) {
        DiffMergeEditor editor = (DiffMergeEditor)context.getView();
        DiffMergeView view = editor.getDiffMergeControl();
        DiffMergeNode node = this.getNode(context);
        DiffMergeArguments arguments = this.getArguments(context);
        if (arguments != null && arguments.getCompareType() == CompareType.DIRECTORY && action.getCommandId() == 51) {
            action.setEnabled(node != null && node.isOpen() && !node.isSaved());
            return true;
        }
        if (arguments != null && arguments.isMergeTask() && action.getCommandId() == 11) {
            action.setEnabled(node != null && node.isOpen() && node.isDirty() && !view.hasMergeConflicts());
            return true;
        }
        if (Ide.getProductID().equals("oracle.ide.diffmergevhv") && action.getCommandId() == 9) {
            action.setEnabled(editor.getCustomizer() != null && !editor.getCustomizer().isViewLocked());
            return true;
        }
        if (action.getCommandId() == 48) {
            action.setEnabled(node != null && node.isOpen() && editor.getCustomizer() != null && !editor.getCustomizer().isViewLocked());
            return true;
        }
        if (action.getCommandId() == 5) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(node != null && node.isOpen() && cp != null && cp.canUndo(context));
            String name = cp != null ? cp.getUndoLabel(context) : "";
            action.putValue("Name", (Object)IdeArb.format((int)469, (Object)(name != null ? name : "")));
            return true;
        }
        if (action.getCommandId() == 6) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(node != null && node.isOpen() && cp != null && cp.canRedo(context));
            String name = cp != null ? cp.getRedoLabel(context) : "";
            action.putValue("Name", (Object)IdeArb.format((int)371, (Object)(name != null ? name : "")));
            return true;
        }
        if (node == null || !node.isOpen()) {
            action.setEnabled(false);
            return true;
        }
        if (action.getCommandId() == 51) {
            action.setEnabled(node != null && node.isOpen());
            return true;
        }
        if (action.getCommandId() == 17) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            action.setEnabled(editorPane != null && editorPane.canCut());
            return true;
        }
        if (action.getCommandId() == 18) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            action.setEnabled(editorPane != null && editorPane.canCopy());
            return true;
        }
        if (action.getCommandId() == 19) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            action.setEnabled(editorPane != null && editorPane.canPaste());
            return true;
        }
        if (action.getCommandId() == 20) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            action.setEnabled(editorPane != null && editorPane.isEditable());
            return true;
        }
        if (action.getCommandId() == 22) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            action.setEnabled(editorPane != null);
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID) {
            action.setEnabled((arguments == null || arguments.getCompareType() == CompareType.TEXT && !arguments.isMergeTask()) && view.getCompareView() != null);
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.SEARCH_HIGHLIGHT_CMD_ID) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            String selectedText = editorPane != null ? editorPane.getSelectedText() : null;
            action.setEnabled(selectedText != null && selectedText.length() > 0);
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.SEARCH_CLEAR_HIGHLIGHTS_CMD_ID) {
            action.setEnabled(view.hasFindHighlighting());
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            action.setEnabled(navigableView != null && navigableView.hasNavigableDifferences());
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            action.setEnabled(navigableView != null && navigableView.hasPreviousDifference());
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            action.setEnabled(navigableView != null && navigableView.hasNextDifference());
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            action.setEnabled(navigableView != null && navigableView.hasNavigableDifferences());
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        View view;
        if (context != null && (view = context.getView()) instanceof DiffMergeEditor && ((DiffMergeEditor)view).getDiffMergeControl() != null) {
            return this._handleEvent(action, context);
        }
        return false;
    }

    private boolean _handleEvent(IdeAction action, Context context) {
        DiffMergeView view = ((DiffMergeEditor)context.getView()).getDiffMergeControl();
        DiffMergeNode node = this.getNode(context);
        if (node == null || !node.isOpen()) {
            return true;
        }
        if (action.getCommandId() == 17) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            editorPane.requestFocus();
            editorPane.invokeAction("cut-to-clipboard");
            return true;
        }
        if (action.getCommandId() == 18) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            editorPane.requestFocus();
            editorPane.invokeAction("copy-to-clipboard");
            return true;
        }
        if (action.getCommandId() == 19) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            editorPane.requestFocus();
            editorPane.invokeAction("paste-from-clipboard");
            return true;
        }
        if (action.getCommandId() == 20) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            editorPane.requestFocus();
            editorPane.invokeAction("delete-next");
            return true;
        }
        if (action.getCommandId() == 22) {
            BasicEditorPane editorPane = this.getEditorPane(view);
            editorPane.requestFocus();
            editorPane.invokeAction("select-all");
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID) {
            view.updateIgnoreWhitespace();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.SEARCH_HIGHLIGHT_CMD_ID) {
            view.invokeHighlight();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.SEARCH_CLEAR_HIGHLIGHTS_CMD_ID) {
            view.invokeClearHighlights();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            navigableView.goToFirstDifference();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            navigableView.goToPreviousDifference();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            navigableView.goToNextDifference();
            return true;
        }
        if (action.getCommandId() == DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID) {
            NavigableView navigableView = this.getNavigableView(view);
            navigableView.goToLastDifference();
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        if (popup.getContext() != null) {
            View view = popup.getContext().getView();
            if (!(view instanceof Editor)) {
                view = EditorManager.getEditorManager().getCurrentEditor();
            }
            if (view instanceof DiffMergeEditor && ((DiffMergeEditor)view).getDiffMergeControl() != null) {
                ((DiffMergeEditor)view).getDiffMergeControl().menuWillShow(this.getContextMenu());
                ((DiffMergeEditor)view).getDiffMergeControl().updateEditorContextualActions();
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    protected void setControllerOnAction(IdeAction action) {
        action.removeController((Controller)this);
        action.addController((Controller)this);
    }

    private BasicEditorPane getEditorPane(DiffMergeView view) {
        CompareView compareView = view.getCompareView();
        return compareView instanceof EditorPaneView ? ((EditorPaneView)compareView).getCurrentEditorPane() : null;
    }

    private NavigableView getNavigableView(DiffMergeView view) {
        CompareView compareView = view.getCompareView();
        return compareView instanceof NavigableView ? (NavigableView)compareView : null;
    }

    private DiffMergeNode getNode(Context context) {
        return (DiffMergeNode)((Object)context.getProperty("DiffMergeEditor.NODE"));
    }

    private DiffMergeArguments getArguments(Context context) {
        DiffMergeNode node = this.getNode(context);
        return node != null ? node.getArguments() : null;
    }
}

