/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeEditor;
import oracle.ide.diffmerge.res.ResourceUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.IdeUtil;

public class DiffMergeURLHelper
extends URLFileSystemHelper {
    public static final String PROTOCOL = "ide.diffmerge";
    private static final String SEPARATOR = "/!/!/!/";

    public static URL newDiffMergeURL(DiffMergeArguments arguments) {
        if (!arguments.isMergeTask()) {
            int count = 1;
            if (IdeUtil.getMainWindow() != null) {
                for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                    if (!(editor instanceof DiffMergeEditor) || ((DiffMergeEditor)editor).getArguments().isMergeTask()) continue;
                    ++count;
                }
            }
            return URLFactory.newURL((String)PROTOCOL, (String)("diff/!/!/!/" + arguments.getSource().getPath() + SEPARATOR + arguments.getTarget().getPath() + SEPARATOR + count));
        }
        return URLFactory.newURL((String)PROTOCOL, (String)("merge/!/!/!/" + arguments.getOutput().getName() + SEPARATOR + arguments.getOutput().getPath()));
    }

    public String getFileName(URL url) {
        String[] parts = url.getFile().split(SEPARATOR);
        if (parts[0].equals("diff")) {
            return MessageFormat.format(ResourceUtil.getResourceBundle().getString("COMPARE_SHORT_NAME"), parts[3]);
        }
        return MessageFormat.format(ResourceUtil.getResourceBundle().getString("MERGE_SHORT_NAME"), parts[1]);
    }

    public String getPlatformPathName(URL url) {
        String[] parts = url.getFile().split(SEPARATOR);
        if (parts[0].equals("diff")) {
            return MessageFormat.format(ResourceUtil.getResourceBundle().getString("COMPARE_LONG_NAME"), parts[1], parts[2]);
        }
        return MessageFormat.format(ResourceUtil.getResourceBundle().getString("MERGE_LONG_NAME"), parts[2]);
    }

    public InputStream openInputStream(URL url) throws IOException {
        return new ByteArrayInputStream(new byte[0]);
    }
}

