/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.cmd;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.diffmerge.DiffMergeEditor;
import oracle.ide.diffmerge.DiffMergeNode;
import oracle.ide.diffmerge.res.ResourceUtil;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public class DiffMergeCloseNodeCommand
extends CloseNodeCommand {
    private static String _delegateCommand;

    public static final void setDelegateCommand(String delegateCommand) {
        _delegateCommand = delegateCommand;
    }

    public int checkSave(List dirtyNodes, boolean canCancel) {
        ArrayList dirtyNodes0 = new ArrayList();
        Iterator itr = dirtyNodes.iterator();
        while (itr.hasNext()) {
            dirtyNodes0.add(itr.next());
        }
        ArrayList<Node> contributorNodes = new ArrayList<Node>();
        Iterator itr2 = dirtyNodes0.iterator();
        while (itr2.hasNext()) {
            Node[] nodes;
            Object o = itr2.next();
            if (!(o instanceof DiffMergeNode)) continue;
            itr2.remove();
            Node[] nodeArray = nodes = ((DiffMergeNode)((Object)o)).getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                Node node = nodeArray[n];
                if (node.isDirty()) {
                    contributorNodes.add(node);
                }
                ++n;
            }
        }
        dirtyNodes0.addAll(contributorNodes);
        return super.checkSave(dirtyNodes0, canCancel);
    }

    public int checkSave(Iterator targets, boolean canCancel) {
        if (canCancel) {
            ArrayList targets0 = new ArrayList();
            while (targets.hasNext()) {
                targets0.add(targets.next());
            }
            if (!DiffMergeCloseNodeCommand.confirmCloseMerge(targets0.iterator())) {
                return 1;
            }
            targets = targets0.iterator();
        }
        return super.checkSave(targets, canCancel);
    }

    public int doit() throws Exception {
        Assert.check((_delegateCommand != null ? 1 : 0) != 0);
        return CommandProcessor.getInstance().invoke(CommandProcessor.createCommand((String)_delegateCommand, (Context)this.getContext()));
    }

    static final boolean confirmCloseMerge(Iterator itr) {
        LinkedHashSet<Node> openMergeEditorNodes = new LinkedHashSet<Node>();
        block0: while (itr.hasNext()) {
            Node node = (Node)itr.next();
            for (Object o : EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)node))) {
                DiffMergeEditor editor;
                if (!(o instanceof DiffMergeEditor) || !(editor = (DiffMergeEditor)((Object)o)).getArguments().isMergeTask() || editor.isCompleteState()) continue;
                openMergeEditorNodes.add(node);
                continue block0;
            }
        }
        if (openMergeEditorNodes.isEmpty()) {
            return true;
        }
        CheckBoxListModel listModel = new CheckBoxListModel();
        for (Node node : openMergeEditorNodes) {
            listModel.addElement((Object)node, node.getIcon(), false, false, URLFileSystem.getPlatformPathName((URL)node.getURL()));
        }
        int result = SelectFilesPanel.showDialog((String)DiffMergeCloseNodeCommand.getResourceString("CLOSE_MERGE_TITLE"), (String)MessageFormat.format(DiffMergeCloseNodeCommand.getResourceString("CLOSE_MERGE_FILE_PROMPT"), listModel.findTextForElement(0)), (String)DiffMergeCloseNodeCommand.getResourceString("CLOSE_MERGE_LIST_PROMPT"), (CheckBoxListModel)listModel, (boolean)false, (int)2, null);
        return result == 0;
    }

    private static final String getResourceString(String name) {
        return ResourceUtil.getResourceBundle().getString(name);
    }
}

