/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import oracle.ide.diffmerge.DiffMergeBaseResource;
import oracle.ide.diffmerge.DiffMergeResource;

public class FileResource
extends DiffMergeBaseResource {
    private static final long _timestamp = System.currentTimeMillis();
    private final File _file;

    public FileResource(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public String getPath() {
        return this._file.getAbsolutePath();
    }

    public String getName() {
        return this._file.getName();
    }

    public String getID() {
        return this.isDirectory() ? null : String.valueOf(this.getChecksum());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long getChecksum() {
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(this._file), new Adler32());
        }
        catch (FileNotFoundException fnfe) {
            return new Long(0L);
        }
        try {
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            Long l = new Long(cis.getChecksum().getValue());
            return l;
        }
        catch (IOException ioe) {
            Long l2 = new Long(0L);
            try {
                cis.close();
                return l2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return l2;
        }
        finally {
            try {
                cis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream openOutputStream() throws IOException {
        this.backUpFile(this._file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._file);
            return fileOutputStream;
        }
        catch (FileNotFoundException fnfe) {
            this._file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(this._file);
            return fileOutputStream;
        }
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public boolean canModify() {
        return this.isDirectory() || super.canModify();
    }

    public DiffMergeResource[] listResources() throws IOException {
        File[] files = this._file.listFiles(new 1());
        if (files == null) {
            throw new IOException("I/O error or not a directory: " + this._file);
        }
        DiffMergeResource[] resources = new DiffMergeResource[files.length];
        int i = 0;
        while (i < files.length) {
            resources[i] = new FileResource(files[i]);
            ++i;
        }
        return resources;
    }

    public void setResources(DiffMergeResource[] resources) throws IOException {
        ArrayList<DiffMergeResource> newResources = new ArrayList<DiffMergeResource>(Arrays.asList(resources));
        ArrayList<DiffMergeResource> oldResources = new ArrayList<DiffMergeResource>(Arrays.asList(this.listResources()));
        Iterator itrN = newResources.iterator();
        block0: while (itrN.hasNext()) {
            FileResource newResource = (FileResource)itrN.next();
            Iterator itrO = oldResources.iterator();
            while (itrO.hasNext()) {
                FileResource oldResource = (FileResource)itrO.next();
                if (!oldResource.getPath().equals(newResource.getPath())) continue;
                itrN.remove();
                itrO.remove();
                continue block0;
            }
        }
        for (FileResource fileResource : oldResources) {
            this.backUpFile(fileResource.getFile());
            if (!fileResource.getFile().exists() || this.deleteFile(fileResource.getFile())) continue;
            throw new IOException("could not delete file: " + fileResource.getFile());
        }
        for (FileResource fileResource : newResources) {
            File srcFile = fileResource.getFile();
            File dstFile = new File(this.getFile(), fileResource.getName());
            if (!srcFile.exists()) continue;
            if (dstFile.exists()) {
                throw new IOException("destination file already exists: " + dstFile);
            }
            this.copyFile(srcFile, dstFile);
        }
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean canRead() {
        return this._file.canRead();
    }

    public boolean canWrite() {
        File file = this._file;
        while (file != null) {
            if (file.exists()) {
                return file.canWrite();
            }
            file = file.getParentFile();
        }
        return false;
    }

    private void backUpFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        File backupFile = new File(file.getParentFile(), ".#" + file.getName());
        if (backupFile.exists() && backupFile.lastModified() >= _timestamp) {
            return;
        }
        this.copyFile(file, backupFile);
        backupFile.setLastModified(_timestamp);
    }

    private void copyFile(File srcFile, File dstFile) throws IOException {
        File[] files;
        if (!srcFile.isDirectory()) {
            FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
            FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            dstFile.setLastModified(srcFile.lastModified());
            return;
        }
        if (dstFile.exists() && !this.deleteFile(dstFile)) {
            throw new IOException("could not delete directory: " + dstFile);
        }
        if (!dstFile.mkdirs()) {
            throw new IOException("could not create directory: " + dstFile);
        }
        File[] fileArray = files = srcFile.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            this.copyFile(file, new File(dstFile, file.getName()));
            ++n;
        }
    }

    private boolean deleteFile(File file) {
        File[] files;
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] fileArray = files = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file0 = fileArray[n];
            if (!this.deleteFile(file0)) {
                return false;
            }
            ++n;
        }
        return file.delete();
    }

    public URL getURL() throws IOException {
        return this._file.toURL();
    }

    final class 1
    implements FileFilter {
        public boolean accept(File pathname) {
            return (pathname.isHidden() || pathname.getName().startsWith(".#")) ^ true;
        }
    }
}

