/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.diffmerge.view.ResourceTextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;

public class ResourceDirectoryNode
extends ResourceTextNode {
    private DirectoryList _directoryList;
    private final Observer _directoryListObserver;

    private void $init$() {
        this._directoryListObserver = new 1();
    }

    public ResourceDirectoryNode(DiffMergeResource resource) {
        this(null, resource);
    }

    public ResourceDirectoryNode(DiffMergeArguments arguments, DiffMergeResource resource) {
        super(arguments, resource);
        this.$init$();
        if (!resource.isDirectory()) {
            throw new IllegalArgumentException();
        }
    }

    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (dirty) {
            return;
        }
        if (this._directoryList != null) {
            this._directoryList.clearModified();
            this._directoryList.notifyObservers();
        }
    }

    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        return this._directoryList != null && this._directoryList.isModified();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._directoryList.deleteObserver(this._directoryListObserver);
        this._directoryList = null;
    }

    protected void setUpReadOnly(TextBuffer textBuffer) {
        textBuffer.setReadOnly(this.getResource().canModify() ^ true);
    }

    protected void loadTextBufferData(TextBuffer textBuffer) throws IOException {
        this._directoryList = this.createDirectoryList(this.getResource());
        int i = 0;
        while (i < this._directoryList.getSize()) {
            textBuffer.append((char[])this._directoryList.getFile(i).getData());
            ++i;
        }
        this._directoryList.addObserver(this._directoryListObserver);
    }

    private DirectoryList createDirectoryList(DiffMergeResource resource) throws IOException {
        DiffMergeResource[] resources;
        DirectoryList directoryList = new DirectoryList();
        DiffMergeResource[] diffMergeResourceArray = resources = resource.listResources();
        int n = 0;
        while (n < diffMergeResourceArray.length) {
            DiffMergeResource resource0 = diffMergeResourceArray[n];
            DirectoryFileAdapter directoryFile = new DirectoryFileAdapter(resource0);
            directoryFile.setCanRead(resource0.canRead());
            directoryFile.setCanWrite(resource0.canWrite());
            directoryList.appendFile((DirectoryFile)directoryFile);
            ++n;
        }
        return directoryList;
    }

    protected void saveImpl(DiffMergeResource resource) throws IOException {
        ArrayList<DiffMergeResource> resources = new ArrayList<DiffMergeResource>();
        int i = 0;
        while (i < this._directoryList.getSize()) {
            resources.add(((DirectoryFileAdapter)this._directoryList.getFile(i)).getResource());
            ++i;
        }
        resource.setResources(resources.toArray(new DiffMergeResource[0]));
    }

    public DirectoryList getDirectoryList() {
        return this._directoryList;
    }

    protected void attachTextBufferListener(TextBuffer textBuffer) {
    }

    protected void detachTextBufferListener(TextBuffer textBuffer) {
    }

    final class 1
    implements Observer {
        public void update(Observable o, Object arg) {
            ResourceDirectoryNode.this.markDirty(((DirectoryList)o).isModified());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryFileAdapter
    extends DirectoryFile {
        private final DiffMergeResource _resource;

        DirectoryFileAdapter(DiffMergeResource resource) {
            super(resource.isDirectory(), resource.getName(), resource.getID());
            this._resource = resource;
        }

        DiffMergeResource getResource() {
            return this._resource;
        }
    }
}

