/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import java.io.IOException;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.model.Node;

public abstract class ResourceNode
extends Node {
    private final DiffMergeResource _resource;
    private final DiffMergeArguments _arguments;
    private DiffMergeResource _temporarySaveResource;

    protected ResourceNode(DiffMergeResource resource) {
        this(null, resource);
    }

    protected ResourceNode(DiffMergeArguments arguments, DiffMergeResource resource) {
        this._arguments = arguments;
        this._resource = resource;
        try {
            this.setURL(resource.getURL());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public DiffMergeResource getResource() {
        return this._resource;
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    public String getShortLabel() {
        return this._resource.getLabel();
    }

    protected void saveImpl() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        this.saveImpl(this._temporarySaveResource != null ? this._temporarySaveResource : this._resource);
    }

    public void save(DiffMergeResource resource) throws IOException {
        this._temporarySaveResource = resource;
        this.save();
        this._temporarySaveResource = null;
    }

    protected abstract void saveImpl(DiffMergeResource var1) throws IOException;
}

