/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.diffmerge.view.ResourceNode;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;

public class ResourceTextNode
extends ResourceNode {
    private final Object _internalLock;
    private final ReadWriteLock _bufferLock;
    private TextBuffer _textBuffer;
    private boolean _isLoading;
    private final TextBufferListener _textBufferListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._internalLock = new Object();
        this._bufferLock = new ReadWriteLock();
        this._textBufferListener = new 1();
    }

    public ResourceTextNode(DiffMergeResource resource) {
        this(null, resource);
    }

    public ResourceTextNode(DiffMergeArguments arguments, DiffMergeResource resource) {
        super(arguments, resource);
        this.$init$();
    }

    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (dirty) {
            return;
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            textBuffer.clearModified();
        }
    }

    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            return textBuffer.isModified();
        }
        return false;
    }

    protected void openImpl() throws IOException {
        this.openTextBuffer();
    }

    protected void closeImpl() throws IOException {
        this.closeTextBuffer();
    }

    static {
        $assertionsDisabled = ResourceTextNode.class.desiredAssertionStatus() ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImpl(DiffMergeResource resource) throws IOException {
        TextBuffer textBuffer;
        Object object = this._internalLock;
        synchronized (object) {
            textBuffer = this.lookupTextBuffer();
            if (!$assertionsDisabled && textBuffer == null) {
                throw new AssertionError((Object)"on save, no buffer available");
            }
        }
        Writer writer = null;
        OutputStream outputStream = null;
        try {
            outputStream = resource.openOutputStream();
            writer = new OutputStreamWriter(outputStream);
            textBuffer.write(writer);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                } else if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    protected TextBuffer getTextBufferDirectly() {
        return this.isOpen() ? this.lookupTextBuffer() : null;
    }

    public final TextBuffer acquireTextBuffer() {
        TextBuffer textBuffer = this.getTextBufferDirectly();
        return textBuffer != null ? textBuffer : this.getTextBufferImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer getTextBufferImpl() {
        Object object = this._internalLock;
        synchronized (object) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            if (textBuffer != null) {
                TextBuffer textBuffer2 = textBuffer;
                return textBuffer2;
            }
        }
        this.ensureOpen();
        Object object2 = this._internalLock;
        synchronized (object2) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            return textBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer lookupTextBuffer() {
        Object object = this._internalLock;
        synchronized (object) {
            TextBuffer textBuffer = this._textBuffer;
            return textBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openTextBuffer() throws IOException {
        Object object = this._internalLock;
        synchronized (object) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            if (!$assertionsDisabled && textBuffer != null) {
                throw new AssertionError((Object)"Warning, found existing text buffer on open");
            }
            textBuffer = this.setupTextBuffer();
            this.loadTextBuffer(textBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTextBuffer() {
        Object object = this._internalLock;
        synchronized (object) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            this.detachTextBufferListener(textBuffer);
            this._textBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer setupTextBuffer() {
        Object object = this._internalLock;
        synchronized (object) {
            TextBuffer textBuffer = this.createTextBuffer(this._bufferLock);
            this.attachTextBufferListener(textBuffer);
            TextBuffer textBuffer2 = this._textBuffer = textBuffer;
            return textBuffer2;
        }
    }

    private TextBuffer createTextBuffer(ReadWriteLock lockToUse) {
        return TextBufferFactory.createTextBuffer((ReadWriteLock)lockToUse);
    }

    protected void attachTextBufferListener(TextBuffer textBuffer) {
        textBuffer.addTextBufferListener(this._textBufferListener);
    }

    protected void detachTextBufferListener(TextBuffer textBuffer) {
        textBuffer.removeTextBufferListener(this._textBufferListener);
    }

    private void loadTextBuffer(TextBuffer textBuffer) throws IOException {
        this.setLoading(true);
        try {
            try {
                this.loadTextBufferData(textBuffer);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioe) {
                if (!textBuffer.isReadOnly()) {
                    textBuffer.removeToEnd(0);
                }
                throw ioe;
            }
            this.setUpReadOnly(textBuffer);
        }
        finally {
            textBuffer.clearModified();
            this.setLoading(false);
        }
    }

    protected void setUpReadOnly(TextBuffer textBuffer) {
        if (textBuffer.isReadOnly() != this.getResource().isReadOnly()) {
            textBuffer.setReadOnly(this.getResource().isReadOnly());
        }
    }

    protected void loadTextBufferData(TextBuffer textBuffer) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(this.getResource().openInputStream());
            textBuffer.read((Reader)reader);
        }
        finally {
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLoading(boolean isLoading) {
        Object object = this._internalLock;
        synchronized (object) {
            this._isLoading = isLoading;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoading() {
        Object object = this._internalLock;
        synchronized (object) {
            boolean bl = this._isLoading;
            return bl;
        }
    }

    static boolean mav$isLoading(ResourceTextNode resourceTextNode) {
        return resourceTextNode.isLoading();
    }

    final class 1
    implements TextBufferListener {
        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (ResourceTextNode.mav$isLoading(ResourceTextNode.this) || attribute != 5) {
                return;
            }
            ResourceTextNode.this.markDirty(buffer.isModified());
        }
    }
}

