/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.misc;

import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.StringRef;

public class JTreeStringTemplateModel
implements TreeModel {
    static Map classNameToWrapperMap = new HashMap();
    Wrapper root = null;

    public static Object wrap(Object object) {
        Object object2 = object;
        Class clazz = null;
        try {
            clazz = (Class)classNameToWrapperMap.get(object.getClass().getName());
            Constructor constructor = clazz.getConstructor(Object.class);
            object2 = constructor.newInstance(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    public JTreeStringTemplateModel(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            throw new IllegalArgumentException("root is null");
        }
        this.root = new StringTemplateWrapper(stringTemplate);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public Object getChild(Object object, int n) {
        if (object == null) {
            return null;
        }
        return ((Wrapper)object).getChild(object, n);
    }

    public int getChildCount(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("root is null");
        }
        return ((Wrapper)object).getChildCount(object);
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("root or child is null");
        }
        return ((Wrapper)object).getIndexOfChild(object, object2);
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (object instanceof Wrapper) {
            return ((Wrapper)object).isLeaf(object);
        }
        return true;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("heh, who is calling this mystery method?");
    }

    static {
        classNameToWrapperMap.put("org.antlr.stringtemplate.StringTemplate", StringTemplateWrapper.class);
        classNameToWrapperMap.put("org.antlr.stringtemplate.language.ASTExpr", ExprWrapper.class);
        classNameToWrapperMap.put("java.util.Hashtable", HashMapWrapper.class);
        classNameToWrapperMap.put("java.util.ArrayList", ListWrapper.class);
        classNameToWrapperMap.put("java.util.Vector", ListWrapper.class);
    }

    static class HashMapWrapper
    extends Wrapper {
        HashMap table;

        public HashMapWrapper(Object object) {
            this.table = (HashMap)object;
        }

        public Object getWrappedObject() {
            return this.table;
        }

        public Object getChild(Object object, int n) {
            List list = this.getTableAsListOfKeys();
            String string = (String)list.get(n);
            Object v = this.table.get(string);
            Object object2 = JTreeStringTemplateModel.wrap(v);
            return new MapEntryWrapper(string, object2);
        }

        public int getChildCount(Object object) {
            List list = this.getTableAsListOfKeys();
            return list.size();
        }

        public int getIndexOfChild(Object object, Object object2) {
            List list = this.getTableAsListOfKeys();
            return list.indexOf(object2);
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        public String toString() {
            return "attributes";
        }

        private List getTableAsListOfKeys() {
            if (this.table == null) {
                return new LinkedList();
            }
            Set set = this.table.keySet();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : set) {
                linkedList.add(string);
            }
            return linkedList;
        }
    }

    static class MapEntryWrapper
    extends Wrapper {
        Object key;
        Object value;

        public MapEntryWrapper(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getWrappedObject() {
            return JTreeStringTemplateModel.wrap(this.value);
        }

        public int getChildCount(Object object) {
            if (this.value instanceof Wrapper) {
                return ((Wrapper)this.value).getChildCount(this.value);
            }
            return 1;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (this.value instanceof Wrapper) {
                return ((Wrapper)this.value).getIndexOfChild(this.value, object2);
            }
            return 0;
        }

        public Object getChild(Object object, int n) {
            if (this.value instanceof Wrapper) {
                return ((Wrapper)this.value).getChild(this.value, n);
            }
            return this.value;
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        public String toString() {
            return this.key.toString();
        }
    }

    static class ListWrapper
    extends Wrapper {
        List v = null;

        public ListWrapper(Object object) {
            this.v = (List)object;
        }

        public int getChildCount(Object object) {
            return this.v.size();
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).getWrappedObject();
            }
            return this.v.indexOf(object2);
        }

        public Object getChild(Object object, int n) {
            return this.v.get(n);
        }

        public Object getWrappedObject() {
            return this.v;
        }

        public boolean isLeaf(Object object) {
            return false;
        }
    }

    static class ExprWrapper
    extends Wrapper {
        Expr expr = null;

        public ExprWrapper(Object object) {
            this.expr = (Expr)object;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public Object getWrappedObject() {
            return this.expr;
        }

        public Object getChild(Object object, int n) {
            ASTExpr aSTExpr;
            AST aST;
            Expr expr = ((ExprWrapper)object).getExpr();
            if (expr instanceof ConditionalExpr) {
                return new StringTemplateWrapper(((ConditionalExpr)expr).getSubtemplate());
            }
            if (expr instanceof ASTExpr && (aST = (aSTExpr = (ASTExpr)expr).getAST()).getType() == 7) {
                switch (n) {
                    case 0: {
                        return aST.getFirstChild().getNextSibling().toStringList();
                    }
                    case 1: {
                        String string = aST.getFirstChild().getText();
                        StringTemplate stringTemplate = expr.getEnclosingTemplate();
                        StringTemplateGroup stringTemplateGroup = stringTemplate.getGroup();
                        StringTemplate stringTemplate2 = stringTemplateGroup.getEmbeddedInstanceOf(stringTemplate, string);
                        return new StringTemplateWrapper(stringTemplate2);
                    }
                }
            }
            return "<invalid>";
        }

        public int getChildCount(Object object) {
            if (this.expr instanceof ConditionalExpr) {
                return 1;
            }
            AST aST = ((ASTExpr)this.expr).getAST();
            if (aST.getType() == 7) {
                return 2;
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (this.expr instanceof ConditionalExpr) {
                return 0;
            }
            return -1;
        }

        public boolean isLeaf(Object object) {
            AST aST;
            if (this.expr instanceof ConditionalExpr) {
                return false;
            }
            return !(this.expr instanceof ASTExpr) || (aST = ((ASTExpr)this.expr).getAST()).getType() != 7;
        }

        public String toString() {
            if (this.expr instanceof ASTExpr) {
                AST aST = ((ASTExpr)this.expr).getAST();
                if (aST.getType() == 7) {
                    return "$include$";
                }
                return "$" + ((ASTExpr)this.expr).getAST().toStringList() + "$";
            }
            if (this.expr instanceof StringRef) {
                return this.expr.toString();
            }
            return "<invalid node type>";
        }
    }

    static class StringTemplateWrapper
    extends Wrapper {
        StringTemplate st = null;

        public StringTemplateWrapper(Object object) {
            this.st = (StringTemplate)object;
        }

        public Object getWrappedObject() {
            return this.getStringTemplate();
        }

        public StringTemplate getStringTemplate() {
            return this.st;
        }

        public Object getChild(Object object, int n) {
            StringTemplate stringTemplate = ((StringTemplateWrapper)object).getStringTemplate();
            if (n == 0) {
                return new HashMapWrapper(stringTemplate.getAttributes());
            }
            Expr expr = (Expr)stringTemplate.getChunks().get(n - 1);
            if (expr instanceof StringRef) {
                return expr;
            }
            return new ExprWrapper(expr);
        }

        public int getChildCount(Object object) {
            return this.st.getChunks().size() + 1;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).getWrappedObject();
            }
            int n = this.st.getChunks().indexOf(object2) + 1;
            return n;
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        public String toString() {
            if (this.st == null) {
                return "<invalid template>";
            }
            return this.st.getName();
        }
    }

    static abstract class Wrapper {
        Wrapper() {
        }

        public abstract int getChildCount(Object var1);

        public abstract int getIndexOfChild(Object var1, Object var2);

        public abstract Object getChild(Object var1, int var2);

        public abstract Object getWrappedObject();

        public boolean isLeaf(Object object) {
            return true;
        }
    }
}

