/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundleEvent;
import oracle.dss.rules.RuleBundleListener;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.RuleException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class RuleBundle
implements Serializable,
Cloneable {
    private Vector m_rules;
    private Vector m_listeners;
    private boolean stopAtFirstMatch;
    protected Hashtable m_context;
    public static final String NAME_BUNDLE = "Bundle";
    private static final String a_type = "type";
    private static final String a_id = "id";
    private String id;
    private String d_id;

    private void $init$() {
        this.m_rules = null;
        this.m_listeners = null;
        this.stopAtFirstMatch = false;
        this.m_context = null;
        this.id = "";
        this.d_id = "";
    }

    public RuleBundle() {
        this.$init$();
        this.m_rules = new Vector();
        this.m_listeners = new Vector();
    }

    public Object clone() {
        RuleBundle ruleBundle = new RuleBundle();
        Enumeration e = this.m_rules.elements();
        while (e.hasMoreElements()) {
            ruleBundle.m_rules.addElement((Rule)((Rule)e.nextElement()).clone());
        }
        ruleBundle.m_listeners = (Vector)this.m_listeners.clone();
        return ruleBundle;
    }

    public Rule getRule(int index) {
        return (Rule)this.m_rules.elementAt(index);
    }

    public void addRule(Rule rule) {
        this.m_rules.addElement((Rule)rule.clone());
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void addRule(Rule rule, int index) {
        this.m_rules.insertElementAt((Rule)rule.clone(), index);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void addRuleBundleListener(RuleBundleListener listener) {
        this.m_listeners.addElement(listener);
    }

    public boolean runRules(RuleContext context, Mergeable target) throws RuleException {
        Enumeration rules = this.m_rules.elements();
        Rule myRule = null;
        boolean applies = false;
        boolean foundMatch = false;
        while (!(!rules.hasMoreElements() || this.stopAtFirstMatch && foundMatch)) {
            myRule = (Rule)rules.nextElement();
            applies = myRule.runRule(context, target);
            boolean bl = foundMatch = foundMatch || applies;
        }
        return foundMatch;
    }

    public int getCount() {
        return this.m_rules.size();
    }

    public void removeRuleBundleListener(RuleBundleListener listener) {
        this.m_listeners.removeElement(listener);
    }

    public void fireEvent(RuleBundleEvent e) {
        Vector list = (Vector)this.m_listeners.clone();
        RuleBundleListener listener = null;
        int i = 0;
        while (i < list.size()) {
            listener = (RuleBundleListener)list.elementAt(i);
            listener.ruleBundleModified(e);
            ++i;
        }
    }

    public void removeRule(Rule rule) {
        this.m_rules.removeElement(rule);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void removeRule(int index) {
        this.m_rules.removeElementAt(index);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void removeRulesThatApply(RuleContext context, Mergeable mergeable) throws RuleException {
        Rule myRule = null;
        boolean applies = false;
        int index = 0;
        while (index < this.getCount()) {
            myRule = this.getRule(index);
            if (myRule.applies(context, mergeable)) {
                applies = true;
                this.m_rules.removeElement(myRule);
                continue;
            }
            ++index;
        }
        if (applies) {
            this.fireEvent(new RuleBundleEvent(this, 0));
        }
    }

    public void replaceRule(Rule rule, int index) {
        this.m_rules.removeElementAt(index);
        this.m_rules.insertElementAt((Rule)rule.clone(), index);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void setStopAtFirstMatch(boolean v) {
        this.stopAtFirstMatch = v;
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public boolean isStopAtFirstMatch() {
        return this.stopAtFirstMatch;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    public void setXML(ContainerNode node, ComponentTypeConverter converter, String version, int reset) {
        PropertyNode idNode = node.getProperty(a_id);
        if (idNode != null) {
            this.setID(idNode.getValueAsString());
        }
        Enumeration e = node.getContainedObject();
        while (e.hasMoreElements()) {
            ObjectNode ruleNode = (ObjectNode)e.nextElement();
            if (ruleNode == null) continue;
            if (ruleNode.getName().equals("DiscRule")) {
                DiscriminatorRule discriminatorRule = new DiscriminatorRule();
                if (this.m_context != null) {
                    discriminatorRule.setContext(this.m_context);
                }
                discriminatorRule.setXML(ruleNode, converter, version, reset);
                this.addRule(discriminatorRule);
                continue;
            }
            PropertyNode pNode = ruleNode.getProperty(a_type);
            if (pNode == null) {
                return;
            }
            String undefinedRulePath = pNode.getValueAsString();
            try {
                Class<?> undefinedRuleClass = Class.forName(undefinedRulePath);
                Rule rule = (Rule)undefinedRuleClass.newInstance();
                rule.setXML(ruleNode, version, reset);
                this.addRule(rule);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter dataview) {
        return this.getXML(allProperties, dataview, NAME_BUNDLE);
    }

    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter dataview, String name) {
        ObjectNode node = new ObjectNode(name);
        boolean nodeExists = false;
        if (this.m_rules != null) {
            int i = 0;
            while (i < this.m_rules.size()) {
                if (this.m_rules.elementAt(i) instanceof Rule) {
                    ObjectNode XML;
                    if ((Rule)this.m_rules.elementAt(i) instanceof DiscriminatorRule && this.m_context != null) {
                        ((DiscriminatorRule)this.m_rules.elementAt(i)).setContext(this.m_context);
                    }
                    if ((XML = ((Rule)this.m_rules.elementAt(i)).getXML(allProperties, dataview)) != null) {
                        node.addProperty(XML);
                        nodeExists = true;
                    }
                }
                ++i;
            }
        }
        if (allProperties || !this.d_id.equals(this.id)) {
            node.addProperty(a_id, this.id);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }
}

