/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.util.BIBaseException;
import oracle.dss.util.BIBaseRuntimeException;
import oracle.dss.util.BIException;

public class BIExceptionSupport
implements Serializable {
    protected Throwable m_previous;
    protected String m_sLineTerm;

    private void $init$() {
        this.m_previous = null;
        this.m_sLineTerm = System.getProperty("line.separator");
    }

    public void setPreviousException(Throwable prevException) {
        this.m_previous = prevException;
    }

    public Throwable getPreviousException() {
        return this.m_previous;
    }

    public String toString(Throwable exception) {
        Throwable previous = null;
        if (exception instanceof BIException) {
            previous = ((BIException)((Object)exception)).getPreviousException();
        }
        if (previous == null) {
            return this._myString(exception);
        }
        return this._myString(exception) + this.m_sLineTerm + previous.toString();
    }

    public void printStackTrace(Throwable exception) {
        if (exception != null && !(exception instanceof BIException)) {
            exception.printStackTrace();
            return;
        }
        if (exception instanceof BIException) {
            if (exception instanceof BIBaseException) {
                ((BIBaseException)exception).printStackTraceSuper();
            } else if (exception instanceof BIBaseRuntimeException) {
                ((BIBaseRuntimeException)exception).printStackTraceSuper();
            }
            Throwable nextException = ((BIException)((Object)exception)).getPreviousException();
            this.printStackTrace(nextException);
        }
    }

    public Throwable getBIRootCause(Throwable exception) {
        Throwable _exception = this.getPreviousException();
        if (_exception != null && _exception instanceof BIException) {
            return ((BIException)((Object)_exception)).getBIRootCause();
        }
        return _exception != null ? _exception : exception;
    }

    public Throwable elementAt(int index, Throwable exception) {
        if (index < 0 || index > this.size(exception) - 1) {
            return null;
        }
        Throwable _thr = exception;
        int i = 0;
        while (i < index) {
            _thr = ((BIException)((Object)_thr)).getPreviousException();
            ++i;
        }
        return _thr;
    }

    public Enumeration elements(Throwable exception) {
        return new Enumerator(exception);
    }

    public int size(Throwable exception) {
        int _count = 1;
        Throwable _thr = exception;
        do {
            if ((_thr = ((BIException)((Object)_thr)).getPreviousException()) == null) continue;
            ++_count;
        } while (_thr instanceof BIException && _thr != null);
        return _count;
    }

    public BIException getException(BIException biException, String strMessage) {
        if (biException != null && strMessage != null) {
            int nIndex = 0;
            while (nIndex < biException.size()) {
                String strException;
                Throwable object = biException.elementAt(nIndex);
                if (object instanceof Exception && (strException = ((Exception)object).getMessage()) != null && strException.indexOf(strMessage) != -1) {
                    return (BIException)((Object)biException.elementAt(nIndex));
                }
                ++nIndex;
            }
        }
        return null;
    }

    public BIException findException(BIException biException, int nErrorCode) {
        BIException biExceptionFound = null;
        String strErrorCode = Integer.toString(nErrorCode);
        if (strErrorCode != null && (strErrorCode.length() == 4 || strErrorCode.length() == 5)) {
            biExceptionFound = this.getException(biException, strErrorCode);
        }
        return biExceptionFound;
    }

    private String _myString(Throwable exception) {
        String s = exception.getClass().getName();
        String message = exception.getMessage();
        return message != null ? s + ": " + message : s;
    }

    public BIExceptionSupport() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumerator
    implements Enumeration {
        int m_index;
        Throwable[] m_throwables;

        private void $init$() {
            this.m_index = 0;
        }

        public Enumerator(Throwable exception) {
            this.$init$();
            this.m_throwables = new Throwable[BIExceptionSupport.this.size(exception)];
            int i = 0;
            while (i < this.m_throwables.length) {
                this.m_throwables[i] = BIExceptionSupport.this.elementAt(i, exception);
                ++i;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_index < this.m_throwables.length;
        }

        public Object nextElement() {
            if (this.m_index < this.m_throwables.length) {
                return this.m_throwables[this.m_index++];
            }
            throw new NoSuchElementException();
        }
    }
}

