/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;

public class CustomStyle
implements Persistable {
    private String _title;
    private String _xmlString;
    private CustomStyle _baseStyle;
    private String _persistableObjectType;
    private PersistableAttributes _attrs;

    public CustomStyle() {
        this.$init$();
    }

    public CustomStyle(String xml) {
        this.$init$();
        this.setXMLAsString(xml);
    }

    public CustomStyle(Class object, String stylePath) throws IOException {
        this.$init$();
        InputStream stream = object.getResourceAsStream(stylePath);
        if (stream == null) {
            throw new FileNotFoundException();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException();
        }
        char[] charArray = new char[2048];
        int charRead = 0;
        StringBuffer xmlString = new StringBuffer();
        while ((charRead = ((Reader)reader).read(charArray, 0, charArray.length)) != -1) {
            xmlString.append(charArray, 0, charRead);
        }
        this.setXMLAsString(xmlString.toString());
    }

    public CustomStyle getBaseStyle() {
        return this._baseStyle;
    }

    public void setBaseStyle(CustomStyle baseStyle) {
        this._baseStyle = baseStyle;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getPersistableObjectType() {
        return this._persistableObjectType;
    }

    public void setPersistableObjectType(String persistableObjectType) {
        this._persistableObjectType = persistableObjectType;
    }

    public void initialize(Hashtable env) {
    }

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregates = null;
        CustomStyle style = this.getBaseStyle();
        if (style != null && style instanceof Persistable) {
            aggregates = new AggregateInfo[]{new AggregateInfo(style, 0)};
        }
        return aggregates;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null && persistables.length > 0) {
            this.setBaseStyle((CustomStyle)persistables[0].getPersistable());
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes attrs) {
        String type;
        PersistableAttributes result = null;
        result = this._attrs == null ? new PersistableAttributes() : (PersistableAttributes)this._attrs.clone();
        if (attrs != null) {
            result.merge(attrs);
        }
        if ((type = this.getPersistableObjectType()) != null) {
            result.setObjectType(type);
        } else {
            result.setObjectType("GraphStyle");
        }
        result.setTitle(this.getTitle());
        return result;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this._attrs = attrs;
    }

    public String getXMLAsString() {
        return this._xmlString;
    }

    public boolean setXMLAsString(String xml) {
        this._xmlString = xml;
        return true;
    }

    private void $init$() {
        this._title = "Unnamed Style";
        this._xmlString = null;
        this._baseStyle = null;
        this._persistableObjectType = null;
    }
}

