/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.BIException;
import oracle.dss.util.ErrorHandler;

public class DefaultErrorHandler
implements ErrorHandler,
Serializable {
    public static final int SHOW_NONE = 0;
    public static final int SHOW_ERROR = 2;
    public static final int SHOW_LOG = 4;
    public static final int SHOW_TRACE = 8;
    public static final int SHOW_ALL = 255;
    private int m_mode;
    private static final String LOGGER_NAME = "DVTLogger";

    private void $init$() {
        this.m_mode = 255;
    }

    public void setDebugMode(int mode) {
        if ((mode & 4) > 0 || (mode & 8) > 0 || (mode & 2) > 0 || mode == 0 || mode == 255) {
            this.m_mode = mode;
        }
    }

    public int getDebugMode() {
        return this.m_mode;
    }

    public void resetDebugMode() {
        this.m_mode = 255;
    }

    public void error(Throwable e, String _class, String routine) {
        if ((this.m_mode & 2) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.SEVERE, _class, routine, "", e);
            if (e instanceof BIException) {
                ((BIException)((Object)e)).getBIRootCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
    }

    public void log(String message, String _class, String routine) {
        if ((this.m_mode & 4) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.FINE, _class, routine, message);
        }
    }

    public void trace(String message, String _class, String routine) {
        if ((this.m_mode & 8) > 0 || this.m_mode == 255) {
            Logger.getLogger(LOGGER_NAME).logp(Level.FINE, _class, routine, message);
        }
    }

    protected String getDate() {
        return new Date().toString();
    }

    public DefaultErrorHandler() {
        this.$init$();
    }
}

