/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.HierarchicalQDR;

public class DimensionSortInfo {
    public static final int ALPHABETICAL = 0;
    public static final int HIERARCHICAL = 1;
    public static final int CHRONOLOGICAL = 2;
    public static final int ATTRIBUTE = 3;
    public static final int MEASURE = 4;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private String m_dimension;
    private String[] m_hierarchy;
    private int[] m_sortType;
    private int[] m_sortDirection;
    private String[] m_sortObject;
    private HierarchicalQDR[] m_qdr;
    private String[] m_sortLabel;
    private boolean[] m_sortWithinLevel;

    public DimensionSortInfo(String dimension) {
        this.setDimension(dimension);
    }

    public DimensionSortInfo(String dimension, String[] hierarchy, int[] sortType, int[] sortDirection, String[] sortObject, HierarchicalQDR[] qdr, String[] sortLabel) {
        this(dimension, hierarchy, sortType, sortDirection, sortObject, qdr, sortLabel, DimensionSortInfo.createTrueArray(hierarchy.length));
    }

    public DimensionSortInfo(String dimension, String[] hierarchy, int[] sortType, int[] sortDirection, String[] sortObject, HierarchicalQDR[] qdr, String[] sortLabel, boolean[] sortWithinLevel) {
        this(dimension);
        this.setHierarchy(hierarchy);
        this.setType(sortType);
        this.setDirection(sortDirection);
        this.setObject(sortObject);
        this.setQDR(qdr);
        this.setLabel(sortLabel);
        this.setWithinLevel(sortWithinLevel);
    }

    private static boolean[] createTrueArray(int length) {
        boolean[] array = new boolean[length];
        int i = 0;
        while (i < array.length) {
            array[i] = true;
            ++i;
        }
        return array;
    }

    public void setDimension(String dimension) {
        this.m_dimension = dimension;
    }

    public String getDimension() {
        return this.m_dimension;
    }

    public void setHierarchy(String[] hierarchy) {
        this.m_hierarchy = hierarchy;
    }

    public String[] getHierarchy() {
        return this.m_hierarchy;
    }

    public void setType(int[] sortType) {
        this.m_sortType = sortType;
    }

    public int[] getType() {
        return this.m_sortType;
    }

    public void setDirection(int[] sortDirection) {
        this.m_sortDirection = sortDirection;
    }

    public int[] getDirection() {
        return this.m_sortDirection;
    }

    public void setObject(String[] sortObject) {
        this.m_sortObject = sortObject;
    }

    public String[] getObject() {
        return this.m_sortObject;
    }

    public void setQDR(HierarchicalQDR[] qdr) {
        this.m_qdr = qdr;
    }

    public HierarchicalQDR[] getQDR() {
        return this.m_qdr;
    }

    public void setLabel(String[] sortLabel) {
        this.m_sortLabel = sortLabel;
    }

    public String[] getLabel() {
        return this.m_sortLabel;
    }

    public void setWithinLevel(boolean[] sortWithinLevel) {
        this.m_sortWithinLevel = sortWithinLevel;
    }

    public boolean[] isWithinLevel() {
        return this.m_sortWithinLevel;
    }
}

