/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DefaultMetadataPrinter;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.MetadataPrinter;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;

public class DumpContext {
    public static void dumpMetadata(PrintWriter pw, DataAccess da, int edge, MetadataMap map) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpMetadata(pw, da, edge, map, new DefaultMetadataPrinter());
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpResults(pw, da, map, new DefaultMetadataPrinter());
    }

    public static void dumpCurrentIndex(PrintWriter pw, DataAccess da, int edge, int index, MetadataMap map) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCurrentIndex(pw, da, edge, index, map, new DefaultMetadataPrinter());
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdgeCursor(pw, da, edge, new DefaultMetadataPrinter());
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, dataType, new DefaultMetadataPrinter());
    }

    public static void dumpEdge(PrintWriter pw, DataAccess da, int edge) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdge(pw, da, edge, new DefaultMetadataPrinter());
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, new DefaultMetadataPrinter());
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpResults(pw, da, map, "value", mp);
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map, String type, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue", type, mp);
        DumpContext.dumpMetadata(pw, da, 2, map, mp);
    }

    public static void dumpMetadata(PrintWriter pw, DataAccess da, int edge, MetadataMap map, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (da != null) {
            String[] types = (String[])Utility.copyVectorToArray(map);
            int dimcount = da.getLayerCount(edge);
            int dim = 0;
            while (dim < dimcount) {
                pw.println(mp.getMetadataName(DumpContext._getString(da.getLayerMetadata(edge, dim, "dimName")), mp.getDimensionType()));
                int[] dimArray = new int[dim + 1];
                int count = da.getMemberSiblingCount(edge, dimArray, dim);
                int value = 0;
                while (value < count) {
                    int type = 0;
                    while (type < types.length - 1) {
                        pw.print(mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, dimArray, dim, value, types[type])), mp.getValueType()) + ",");
                        ++type;
                    }
                    String obj = mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, dimArray, dim, value, types[types.length - 1])), mp.getValueType());
                    if (obj != null) {
                        pw.println(obj.toString());
                    } else {
                        pw.println();
                    }
                    ++value;
                }
                pw.println();
                ++dim;
            }
        }
    }

    public static void dumpEdge(PrintWriter pw, DataAccess da, int edge, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        pw.println("------------DataAccess edge member contents start-----------");
        int layerCount = da.getLayerCount(edge);
        int i = 0;
        while (i < layerCount) {
            pw.print(mp.getMetadataName(DumpContext._getString(da.getLayerMetadata(edge, i, "dimName")), mp.getDimensionType()) + ",");
            ++i;
        }
        pw.println();
        pw.println();
        int[] depthIndex = da.getFirstHPos(edge);
        do {
            if (depthIndex == null) continue;
            int i2 = 0;
            while (i2 < depthIndex.length) {
                if (depthIndex[i2] != -1) {
                    pw.print(mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, depthIndex, i2, depthIndex[i2], "value")), mp.getValueType()));
                }
                pw.print(",");
                ++i2;
            }
            depthIndex = da.getNextHPos(edge, depthIndex);
            pw.println();
        } while (depthIndex != null);
        pw.println();
        pw.println();
        pw.println("------------DataAccess edge member contents end-----------");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, dataType, "value", mp);
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType, String metadataType, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        pw.println("---------------DataAccess cursor start---------------");
        if (da != null) {
            pw.println("Page values:");
            DumpContext.dumpCurrentIndex(pw, da, 2, da.getEdgeCurrentSlice(2), new MetadataMap(new String[]{"value"}), mp);
            pw.println();
            pw.println("Column header:");
            int edge = 0;
            DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), metadataType, mp);
            pw.println();
            pw.println("Row header:");
            edge = 1;
            DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), metadataType, mp);
            pw.println();
            Object val = null;
            int rowExtent = da.getEdgeExtent(1);
            int row = 0;
            while (row < rowExtent) {
                int colExtent = da.getEdgeExtent(0);
                int column = 0;
                while (column < colExtent) {
                    val = da.getValue(row, column, dataType);
                    try {
                        Class bvfhClass = Utility.loadClass("oracle.dss.util.format.BaseViewFormatHandle");
                        if (bvfhClass.isInstance(val)) {
                            Method m = bvfhClass.getMethod("getBaseViewFormat", null);
                            val = m.invoke(val, null);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (val != null) {
                        pw.print(val.toString() + ",");
                    } else {
                        pw.print("NA,");
                    }
                    ++column;
                }
                pw.println();
                ++row;
            }
        }
        pw.println("----------------DataAccess cursor end----------------");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue", mp);
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), "value", mp);
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge, int count, String type, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (pw != null) {
            pw.println("------------DataAccess edge metadata start-----------");
        }
        if (da != null) {
            Object obj = null;
            int dimCount = da.getLayerCount(edge);
            int depth = 0;
            while (depth < dimCount) {
                obj = da.getLayerMetadata(edge, depth, "dimName");
                if (pw != null) {
                    pw.println(mp.getMetadataName(DumpContext._getString(obj), mp.getDimensionType()));
                }
                int index = 0;
                while (index < count) {
                    int start2;
                    int start1;
                    if (depth > 0 && index > 0 && (start1 = da.getMemberStartSlice(edge, depth - 1, index)) == (start2 = da.getMemberStartSlice(edge, depth, index)) && pw != null) {
                        pw.print(" | ");
                    }
                    if (da.getMemberStartLayer(edge, depth, index) == depth) {
                        obj = da.getMemberMetadata(edge, depth, index, type);
                        if (pw != null) {
                            pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + ",");
                        }
                    } else if (pw != null) {
                        pw.print("----- ");
                    }
                    index += DumpContext._calcSpan(da, edge, depth, index);
                }
                if (pw != null) {
                    pw.println();
                }
                ++depth;
            }
        }
        if (pw != null) {
            pw.println("-------------DataAccess edge metadata end------------");
        }
    }

    public static void dumpCurrentIndex(PrintWriter pw, DataAccess da, int edge, int index, MetadataMap map, MetadataPrinter mp) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (da != null) {
            Object obj = null;
            int pageDimCount = da.getLayerCount(edge);
            if (pageDimCount == 0) {
                return;
            }
            int[] context = da.getMemberHPos(edge, pageDimCount - 1, da.getEdgeCurrentSlice(edge));
            int page = 0;
            while (page < pageDimCount) {
                obj = da.getLayerMetadata(edge, page, "dimName");
                if (pw != null) {
                    pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getDimensionType()) + ": ");
                }
                if (context == null) {
                    if (pw != null) {
                        pw.println();
                    }
                } else {
                    obj = da.getMemberMetadata(edge, context, page, context[page], map.getTypeAt(0));
                    if (pw != null) {
                        pw.println(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()));
                    }
                }
                ++page;
            }
        }
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, da.getEdgeExtent(0), da.getEdgeExtent(1), "value", mp);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, "value", mp);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, mp, null);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, false, mp, df);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, boolean outline, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, "dataValue", outline, mp, df);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, String dataType, boolean outline, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (pw != null) {
            pw.println("---------------DataAccess crosstab body start---------------");
        }
        if (da != null) {
            if (pw != null) {
                pw.println("Page values:");
            }
            DumpContext.dumpCurrentIndex(pw, da, 2, da.getEdgeCurrentSlice(2), new MetadataMap(new String[]{type}), mp);
            if (pw != null) {
                pw.println();
            }
            if (pw != null) {
                pw.println("Column header:");
            }
            int edge = 0;
            DumpContext.dumpEdgeCursor(pw, da, edge, colBound, type, mp);
            if (pw != null) {
                pw.println();
            }
            Object val = null;
            Object obj = null;
            int rowExtent = rowBound;
            int row = 0;
            while (row < rowExtent) {
                int layers = da.getLayerCount(1);
                int depth = 0;
                while (depth < layers) {
                    if (outline) {
                        int startLayer = da.getSliceOutlineLayer(1, row);
                        if (startLayer == depth) {
                            obj = da.getMemberMetadata(1, depth, row, type);
                            if (pw == null) break;
                            pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + " | ");
                            break;
                        }
                        if (pw != null) {
                            pw.print("     ");
                        }
                    } else if (da.getMemberStartLayer(1, depth, row) == depth) {
                        obj = da.getMemberMetadata(1, depth, row, type);
                        if (pw != null) {
                            pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + " | ");
                        }
                    } else if (pw != null) {
                        pw.print("----- ");
                    }
                    ++depth;
                }
                int colExtent = colBound;
                int column = 0;
                while (column < colExtent) {
                    val = da.getValue(row, column, dataType);
                    if (val != null) {
                        if (df != null && val instanceof Number) {
                            if (pw != null) {
                                pw.print(df.format(val) + ",");
                            }
                        } else if (pw != null) {
                            pw.print(val.toString() + ",");
                        }
                    } else if (pw != null) {
                        pw.print("NA,");
                    }
                    ++column;
                }
                if (pw != null) {
                    pw.println();
                }
                ++row;
            }
        }
        if (pw != null) {
            pw.println("----------------DataAccess crosstab body end----------------");
        }
    }

    private static int _calcSpan(DataAccess da, int edge, int depth, int index) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (depth == da.getLayerCount(edge) - 1) {
            return 1;
        }
        return da.getMemberExtent(edge, depth, index);
    }

    private static String _getString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

