/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.Comparison;
import oracle.dss.util.NameConverter;
import oracle.dss.util.QDRMember;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.PropertyNode;

public class HierarchicalQDRMember
extends QDRMember {
    public static final String XML_NAME_OLAP = "OlapQDRMember";
    public static final String XML_LIST_NAME_OLAP = "ListOlapQDRMember";
    private static final String HIERARCHY_PROPERTY = "Hierarchy";
    private static final String LEVEL_PROPERTY = "Level";
    private static final String TYPE_PROPERTY = "MemberType";
    private static final String MEMBER_PROPERTY = "Member";
    private static final String MEMBER_DATATYPE_PROPERTY = "MemberDataType";
    private static final String XML_FIXED = "FIXED";
    private static final String XML_VARIES = "VARIES";
    private static final String XML_CURRENT = "CURRENT";
    private static final String XML_LIST = "LIST";
    protected Object m_hier;
    protected Object m_level;

    private void $init$() {
        this.m_hier = null;
        this.m_level = null;
    }

    public HierarchicalQDRMember() {
        this.$init$();
    }

    public HierarchicalQDRMember(int type) {
        super(type);
        this.$init$();
    }

    public HierarchicalQDRMember(String dimMember) {
        super(dimMember);
        this.$init$();
    }

    public HierarchicalQDRMember(int type, Object member, Object hierarchy, Object level) {
        super(type, member);
        this.$init$();
        this.setHierarchy(hierarchy);
        this.setLevel(level);
    }

    public HierarchicalQDRMember(String member, String hierarchy, String level) {
        super(member);
        this.$init$();
        this.setHierarchy(hierarchy);
        this.setLevel(level);
    }

    public void setHierarchy(Object newHier) {
        this.m_hier = newHier;
    }

    public Object getHierarchy() {
        return this.m_hier;
    }

    public void setLevel(Object newLevel) {
        this.m_level = newLevel;
    }

    public Object getLevel() {
        return this.m_level;
    }

    public int hashCode() {
        int code = super.hashCode();
        if (this.m_hier instanceof String) {
            code += this.m_hier.hashCode();
        }
        if (this.m_level instanceof String) {
            code += this.m_level.hashCode();
        }
        return code;
    }

    public Object clone() throws CloneNotSupportedException {
        HierarchicalQDRMember newQDRMember = (HierarchicalQDRMember)super.clone();
        if (this.m_hier != null && this.m_hier instanceof Vector) {
            newQDRMember.setHierarchy(((Vector)this.m_hier).clone());
        }
        if (this.m_level != null && this.m_level instanceof Vector) {
            newQDRMember.setLevel(((Vector)this.m_level).clone());
        }
        return newQDRMember;
    }

    public String getTagName() {
        if (this.getType() == 3) {
            return XML_LIST_NAME_OLAP;
        }
        return XML_NAME_OLAP;
    }

    protected String getMemberTag() {
        return MEMBER_PROPERTY;
    }

    protected String getLevelTag() {
        return LEVEL_PROPERTY;
    }

    protected String getHierarchyTag() {
        return HIERARCHY_PROPERTY;
    }

    protected String getMemberTypeTag() {
        return MEMBER_DATATYPE_PROPERTY;
    }

    public Object getXML(XMLContext context) {
        String name = this.getTagName();
        ContainerNode root = new ContainerNode(name);
        root.addProperty(TYPE_PROPERTY, this.convertTypeIntToString(this.getType()));
        if (this.getData() != null) {
            if (this.getData() instanceof String) {
                root.addProperty(this.getMemberTag(), (String)this.getData(), false);
            } else if (this.getData() instanceof Vector) {
                Enumeration members = ((Vector)this.getData()).elements();
                while (members.hasMoreElements()) {
                    String member = (String)members.nextElement();
                    root.addContainedObject(new PropertyNode(this.getMemberTag(), member));
                }
            } else {
                Utility.PropertyType.storeData(root, this.getData(), this.getMemberTag(), this.getMemberTypeTag());
            }
        }
        if (this.m_hier != null) {
            if (this.m_hier instanceof String) {
                root.addProperty(this.getHierarchyTag(), (String)this.m_hier, false);
            } else if (this.m_hier instanceof Vector) {
                Enumeration members = ((Vector)this.m_hier).elements();
                while (members.hasMoreElements()) {
                    String member = (String)members.nextElement();
                    root.addContainedObject(new PropertyNode(this.getHierarchyTag(), member));
                }
            }
        }
        if (this.m_level != null) {
            if (this.m_level instanceof String) {
                root.addProperty(this.getLevelTag(), (String)this.m_level, false);
            } else if (this.m_level instanceof Vector) {
                Enumeration members = ((Vector)this.m_level).elements();
                while (members.hasMoreElements()) {
                    String member = (String)members.nextElement();
                    root.addContainedObject(new PropertyNode(this.getLevelTag(), member));
                }
            }
        }
        return root;
    }

    public void setXML(XMLContext context, Object node) {
        ContainerNode containerNode = (ContainerNode)node;
        try {
            int type = this.convertTypeStringToInt(containerNode.getPropertyValueAsString(TYPE_PROPERTY));
            this.setType(type);
            if (type == 0) {
                this.setData(containerNode.getPropertyValueAsString(this.getMemberTag()));
                String dataType = null;
                PropertyNode dataTypeNode = containerNode.getProperty(this.getMemberTypeTag());
                if (dataTypeNode != null) {
                    dataType = dataTypeNode.getValueAsString();
                }
                this.setData(Utility.PropertyType.getData(containerNode.getPropertyValueAsString(this.getMemberTag()), dataType));
            } else if (type == 3) {
                Vector<String> temp = new Vector<String>();
                Enumeration members = containerNode.getPropertyNodes(this.getMemberTag());
                while (members.hasMoreElements()) {
                    PropertyNode memberNode = (PropertyNode)members.nextElement();
                    temp.addElement(memberNode.getValueAsString());
                }
                if (temp.size() > 0) {
                    this.setData(temp);
                }
            }
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        if (this.getType() == 0) {
            try {
                this.setHierarchy(containerNode.getPropertyValueAsString(this.getHierarchyTag()));
            }
            catch (NoSuchPropertyException nspe) {}
        } else if (this.getType() == 3) {
            Vector<String> temp = new Vector<String>();
            Enumeration members = containerNode.getPropertyNodes(this.getHierarchyTag());
            if (members != null) {
                while (members.hasMoreElements()) {
                    PropertyNode memberNode = (PropertyNode)members.nextElement();
                    temp.addElement(memberNode.getValueAsString());
                }
                if (temp.size() > 0) {
                    this.m_hier = temp;
                }
            }
        }
        if (this.getType() == 0) {
            try {
                this.setLevel(containerNode.getPropertyValueAsString(this.getLevelTag()));
            }
            catch (NoSuchPropertyException nspe) {}
        } else if (this.getType() == 3) {
            Vector<String> temp = new Vector<String>();
            Enumeration members = containerNode.getPropertyNodes(this.getLevelTag());
            if (members != null) {
                while (members.hasMoreElements()) {
                    PropertyNode memberNode = (PropertyNode)members.nextElement();
                    temp.addElement(memberNode.getValueAsString());
                }
                if (temp.size() > 0) {
                    this.m_level = temp;
                }
            }
        }
    }

    protected String convertTypeIntToString(int type) {
        String strType = XML_FIXED;
        switch (type) {
            case 0: {
                strType = XML_FIXED;
                break;
            }
            case 1: {
                strType = XML_VARIES;
                break;
            }
            case 2: {
                strType = XML_CURRENT;
                break;
            }
            case 3: {
                strType = XML_LIST;
                break;
            }
        }
        return strType;
    }

    protected int convertTypeStringToInt(String strType) {
        if (strType.equals(XML_FIXED)) {
            return 0;
        }
        if (strType.equals(XML_VARIES)) {
            return 1;
        }
        if (strType.equals(XML_CURRENT)) {
            return 2;
        }
        if (strType.equals(XML_LIST)) {
            return 3;
        }
        return -1;
    }

    public Vector getAllDependentIDs(String measDim, NameConverter nc) {
        Vector depIDs = super.getAllDependentIDs(measDim, nc);
        if (this.m_hier != null) {
            depIDs.addElement(this.m_hier);
        }
        if (this.m_level != null) {
            depIDs.addElement(this.m_level);
        }
        return depIDs.size() == 0 ? null : depIDs;
    }

    public String toString() {
        String output = "";
        switch (this.getType()) {
            case 0: 
            case 3: {
                if (this.getData() == null) break;
                output = output + this.getDataString();
                break;
            }
            case 1: {
                output = output + XML_VARIES;
                break;
            }
            case 2: {
                output = output + XML_CURRENT;
                break;
            }
        }
        if (this.m_hier != null) {
            output = output + " | " + this.getHierString();
        }
        if (this.m_level != null) {
            output = output + " | " + this.getLevelString();
        }
        return output;
    }

    protected String getHierString() {
        if (this.m_hier != null) {
            return this.m_hier.toString();
        }
        return null;
    }

    protected String getLevelString() {
        if (this.m_level != null) {
            return this.m_level.toString();
        }
        return null;
    }

    protected String getDataString() {
        return this.getData().toString();
    }

    protected boolean comparePieces(Object data, Object cmpData, Comparison comparator) {
        if (data == null && cmpData == null) {
            return true;
        }
        if (data != null && cmpData != null) {
            if (comparator == null ? data.equals(cmpData) : data instanceof String && cmpData instanceof String && comparator.areLevelIDsEquivalent((String)data, (String)cmpData)) {
                return true;
            }
            if (this.getType() == 3 && data instanceof Vector && cmpData instanceof Vector) {
                Vector vData = (Vector)data;
                Vector vCmpData = (Vector)cmpData;
                if (comparator == null) {
                    return vData.size() == vCmpData.size() && Utility.contains(vData, vCmpData);
                }
                return this.contains(vData, vCmpData, comparator);
            }
        }
        return false;
    }

    protected boolean contains(Vector v1, Vector v2, Comparison comparator) {
        if (v1.size() == v2.size()) {
            Enumeration dataElements = v1.elements();
            Enumeration cmpDataElements = v2.elements();
            Object dataStr = null;
            String cmpDataStr = null;
            while (cmpDataElements.hasMoreElements()) {
                cmpDataStr = (String)cmpDataElements.nextElement();
                if (v1.contains(cmpDataStr)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean contains(HierarchicalQDRMember qdrMember, Comparison comparator) {
        if (this.getType() == 1) {
            return true;
        }
        if (qdrMember == null) {
            return false;
        }
        if (this.equals(qdrMember, comparator)) {
            return true;
        }
        int cmpType = qdrMember.getType();
        if (this.getType() == 3 && this.getData() instanceof Vector) {
            Vector vData = (Vector)this.getData();
            Vector vHier = (Vector)this.getHierarchy();
            Vector vLevel = (Vector)this.getLevel();
            Object cmpData = qdrMember.getData();
            if (cmpData != null && vData != null) {
                if (cmpType == 0) {
                    int elementCount = vData.size();
                    int i = 0;
                    while (i < elementCount) {
                        HierarchicalQDRMember tempMember = new HierarchicalQDRMember((String)vData.elementAt(i), (String)vHier.elementAt(i), (String)vLevel.elementAt(i));
                        if (qdrMember.equals(tempMember, comparator)) {
                            return true;
                        }
                        ++i;
                    }
                } else if (cmpType == 3 && cmpData instanceof Vector) {
                    Vector vCmp = (Vector)cmpData;
                    int cmpElementCount = vCmp.size();
                    int i = 0;
                    while (i < cmpElementCount) {
                        HierarchicalQDRMember tempMember = new HierarchicalQDRMember((String)vCmp.elementAt(i), (String)((Vector)qdrMember.getHierarchy()).elementAt(i), (String)((Vector)qdrMember.getLevel()).elementAt(i));
                        if (!this.contains(tempMember, comparator)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean contains(HierarchicalQDRMember qdrMember) {
        return this.contains(qdrMember, null);
    }

    public boolean equals(HierarchicalQDRMember qdrMember, Comparison comparator) {
        boolean membersEqual = super.equals(qdrMember);
        if (membersEqual) {
            boolean hierarchiesEqual = this.comparePieces(this.getHierarchy(), qdrMember.getHierarchy(), null);
            if (hierarchiesEqual) {
                return this.comparePieces(this.getLevel(), qdrMember.getLevel(), null);
            }
            return this.comparePieces(this.getLevel(), qdrMember.getLevel(), comparator);
        }
        return false;
    }

    public boolean equals(HierarchicalQDRMember qdrMember) {
        return this.equals(qdrMember, null);
    }

    public boolean equals(Object obj, Comparison comparator) {
        if (obj instanceof HierarchicalQDRMember) {
            return this.equals((HierarchicalQDRMember)obj, comparator);
        }
        return false;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, null);
    }
}

