/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.util.DependentID;
import oracle.dss.util.IDResolver;
import oracle.dss.util.MemberContext;
import oracle.dss.util.NameConverter;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RuleMemberContext;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.persistence.XMLizable;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDR
implements QDRInterface,
DependentID,
XMLizable {
    public static final String XML_NAME = "QDR";
    public static final String XML_NAME_NEW = "dvt-cube" + ":" + "QDR";
    public static final String ALL_PROPERTIES = "allProperties";
    private static final String MEASURE_DIM_NAME_PROPERTY = "measureDimName";
    private static final String DIM_MEMBER_PAIR_PROPERTY = "DimMemPair";
    private static final String DIMENSION_PROPERTY = "dim";
    private static final String MEMBER_PROPERTY = "mem";
    private static final String TARGET_PROPERTY = "QDRTarget";
    protected static final String PROBLEM_SEPARATOR = "::";
    protected static final String REPLACEMENT_SEPARATOR = "\u0001\u0001";
    protected static final char ELEMENT_SEPARATOR = ':';
    protected static final char PAIR_SEPARATOR = ';';
    private static boolean DEBUG = false;
    private static final char PROPERTY_SEPARATOR = '_';
    private static final String PROPERTY_SEPARATOR_S = String.valueOf('_');
    protected QDRMember m_target;
    protected Vector m_dimensions;
    protected Vector m_members;
    protected String m_measureDim;
    protected QDRMember m_memberVaries;

    public QDR() {
        this.$init$();
        this.m_dimensions = new Vector();
        this.m_members = new Vector();
    }

    public QDR(QDR qdr) {
        this.$init$();
        this.setMeasureDim(qdr.m_measureDim);
        this.m_dimensions = (Vector)qdr.m_dimensions.clone();
        try {
            this.m_members = this.cloneVector(qdr.m_members);
            if (qdr.getTarget() != null) {
                this.setTarget((QDRMember)qdr.getTarget().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public QDR(String measureDim) {
        this();
        this.setMeasureDim(measureDim);
    }

    public QDR(String measureDim, String dim, String member) {
        this(measureDim);
        this.addDimMemberPair(dim, member);
    }

    public QDR(String measureDim, String dim, QDRMember member) {
        this(measureDim);
        this.addDimMemberPair(dim, member);
    }

    public QDR(String measureDim, String dimMemberPairs) {
        this(measureDim);
        this.setDimMemberPairs(dimMemberPairs);
    }

    public char getElementSeparator() {
        return ':';
    }

    public char getPairSeparator() {
        return ';';
    }

    @Override
    public Vector getMembers() {
        return this.m_members;
    }

    protected Vector cloneVector(Vector v) throws CloneNotSupportedException {
        Vector<Object> newV = new Vector<Object>();
        Enumeration vlist = v.elements();
        while (vlist.hasMoreElements()) {
            QDRMember element = (QDRMember)vlist.nextElement();
            if (element != null) {
                newV.addElement(element.clone());
                continue;
            }
            newV.addElement(element);
        }
        return newV;
    }

    public String getMeasureDim() {
        return this.m_measureDim;
    }

    public void setMeasureDim(String measureDim) {
        if (measureDim != null) {
            this.m_measureDim = measureDim;
        }
    }

    @Override
    public void addDimMemberPair(String dimension, String member) {
        QDRMember qdrMember = null;
        qdrMember = member != null ? new QDRMember(member) : this.m_memberVaries;
        this.addDimMemberPair(dimension, qdrMember);
    }

    public void addDimMemberPair(String dim, QDRMember member) {
        if (dim == null) {
            return;
        }
        if (member == null) {
            member = this.m_memberVaries;
        }
        if (this.isDimensionOnlyQDR()) {
            this.m_dimensions.setElementAt(dim, 0);
        } else {
            int index = this.m_dimensions.indexOf(dim);
            if (index >= 0) {
                this.m_members.setElementAt(member, index);
            } else {
                this.m_dimensions.addElement(dim);
                this.m_members.addElement(member);
            }
        }
    }

    @Override
    public QDRMember getDimMember(String dim) {
        if (dim == null) {
            return null;
        }
        int index = this.m_dimensions.indexOf(dim);
        if (index >= 0) {
            return (QDRMember)this.m_members.elementAt(index);
        }
        return null;
    }

    public boolean isDimensionOnlyQDR() {
        return this.size() == 1 && this.m_members.elementAt(0).equals(this.m_memberVaries);
    }

    @Override
    public void removeDimMemberPair(String dim) {
        int index = this.m_dimensions.indexOf(dim);
        if (index >= 0) {
            this.m_dimensions.removeElementAt(index);
            this.m_members.removeElementAt(index);
        }
    }

    @Override
    public Vector getDims() {
        return this.m_dimensions;
    }

    @Override
    public Enumeration getDimensions() {
        return this.m_dimensions.elements();
    }

    @Override
    public int size() {
        return this.m_dimensions.size();
    }

    protected String replaceSeparator(String base, String separator, String replacement) {
        StringBuffer buf = new StringBuffer(256);
        int sepLen = separator.length();
        int pos = 0;
        int len = base.length();
        while (pos < len) {
            int next = base.indexOf(separator, pos);
            if (next > -1) {
                if (buf.length() > 0) {
                    buf.append(replacement);
                }
                buf.append(base.substring(pos, next));
                pos = next + sepLen;
                continue;
            }
            if (buf.length() > 0) {
                buf.append(replacement);
            }
            buf.append(base.substring(pos, len));
            pos = len;
        }
        return buf.toString();
    }

    public void setDimMemberPairs(String dimMemberPairs) {
        if (dimMemberPairs != null) {
            dimMemberPairs = this.replaceSeparator(dimMemberPairs, PROBLEM_SEPARATOR, REPLACEMENT_SEPARATOR);
            boolean oneString = true;
            if (dimMemberPairs.indexOf(59) != -1 || dimMemberPairs.indexOf(58) != -1) {
                oneString = false;
            }
            if (!oneString) {
                StringTokenizer pairs = new StringTokenizer(dimMemberPairs, String.valueOf(';'));
                while (pairs.hasMoreTokens()) {
                    StringTokenizer tokens = new StringTokenizer(pairs.nextToken(), String.valueOf(':'));
                    if (tokens.countTokens() != 2) continue;
                    String dim = this.replaceSeparator(tokens.nextToken(), REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR);
                    String member = this.replaceSeparator(tokens.nextToken(), REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR);
                    this.addDimMemberPair(dim, new QDRMember(member));
                }
            } else {
                QDRMember member = null;
                this.addDimMemberPair(this.replaceSeparator(dimMemberPairs, REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR), member);
            }
        }
    }

    protected boolean isFixedType(QDRMember member) {
        int type = member.getType();
        return type == 0 || type == 4 || type == 5;
    }

    public String getDimMemberPairs() {
        if (this.isDimensionOnlyQDR()) {
            return (String)this.m_dimensions.elementAt(0);
        }
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        Enumeration keys = this.m_dimensions.elements();
        Enumeration values = this.m_members.elements();
        while (keys.hasMoreElements()) {
            Object data;
            QDRMember qdrMember;
            String dim = (String)keys.nextElement();
            Object member = values.nextElement();
            if (member != null && this.isFixedType(qdrMember = (QDRMember)member) && (data = qdrMember.getData()) != null) {
                if (!first) {
                    buffer.append(';');
                }
                buffer.append(dim);
                buffer.append(':');
                buffer.append(data.toString());
            }
            first = false;
        }
        return buffer.toString();
    }

    public void setTarget(QDRMember target) {
        this.m_target = target;
    }

    public QDRMember getTarget() {
        return this.m_target;
    }

    protected static boolean contains(QDRInterface qdr1, QDRInterface qdr2) {
        if (qdr1 == null || qdr2 == null) {
            return false;
        }
        Vector qdr1Dims = qdr1.getDims();
        int qdr1Size = qdr1Dims.size();
        boolean index = false;
        QDRMember member1 = null;
        QDRMember member2 = null;
        Vector qdr1Members = qdr1.getMembers();
        int i = 0;
        while (i < qdr1Size) {
            member1 = (QDRMember)qdr1Members.elementAt(i);
            if (!member1.contains(member2 = qdr2.getDimMember((String)qdr1Dims.elementAt(i)))) {
                return false;
            }
            ++i;
        }
        if (qdr1 instanceof QDR && qdr2 instanceof QDR) {
            QDRMember target1 = ((QDR)qdr1).getTarget();
            QDRMember target2 = ((QDR)qdr2).getTarget();
            if (target1 != null || target2 != null) {
                if (target2 == null) {
                    return false;
                }
                if (target1 != null && !target1.contains(target2)) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(QDR q2) {
        if (q2 == null) {
            return false;
        }
        if (this.isDimensionOnlyQDR()) {
            return q2.isDimensionOnlyQDR() && this.m_dimensions.elementAt(0).equals(q2.m_dimensions.elementAt(0));
        }
        return QDR.contains(this, q2) && QDR.contains(q2, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof QDR) {
            return this.equals((QDR)obj);
        }
        return false;
    }

    public boolean isProperSupersetOf(QDR q2) {
        return QDR.contains(this, q2) && !QDR.contains(q2, this);
    }

    public boolean isProperSubsetOf(QDR q2) {
        return QDR.contains(q2, this) && !QDR.contains(this, q2);
    }

    @Override
    public boolean isSubsetOf(QDRInterface q2) {
        return QDR.contains(q2, this);
    }

    public boolean isSupersetOf(QDRInterface q2) {
        return QDR.contains(this, q2);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.m_dimensions != null) {
            Object obj = null;
            Enumeration dims = this.m_dimensions.elements();
            while (dims.hasMoreElements()) {
                obj = dims.nextElement();
                if (obj == null) continue;
                hashCode += obj.hashCode();
            }
        }
        if (this.m_members != null) {
            Object obj = null;
            Enumeration members = this.m_members.elements();
            while (members.hasMoreElements()) {
                obj = members.nextElement();
                if (obj == null) continue;
                hashCode += obj.hashCode();
            }
        }
        if (this.m_target != null) {
            hashCode += this.m_target.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() {
        QDR copy = null;
        try {
            copy = (QDR)this.getClass().newInstance();
        }
        catch (Exception e) {
            Object var4_3 = null;
            return var4_3;
        }
        copy.setMeasureDim(this.m_measureDim);
        copy.m_dimensions = (Vector)this.m_dimensions.clone();
        try {
            copy.m_members = this.cloneVector(this.m_members);
            if (this.m_target != null) {
                copy.m_target = (QDRMember)this.m_target.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        first = true;
        buffer = new StringBuffer();
        measureDim = this.getMeasureDim();
        if (measureDim != null && !measureDim.equals("")) {
            buffer.append(measureDim);
            buffer.append("(");
        }
        keys = this.m_dimensions.elements();
        values = this.m_members.elements();
        if (keys != null) ** GOTO lbl34
        return null;
lbl-1000:
        // 1 sources

        {
            key = (String)keys.nextElement();
            member = values.nextElement();
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(key);
            if (member == null) continue;
            buffer.append(" ");
            if (this.isFixedType((QDRMember)member)) {
                buffer.append("'");
                buffer.append(member.toString());
                buffer.append("'");
                continue;
            }
            buffer.append(member.toString());
lbl34:
            // 4 sources

            ** while (keys.hasMoreElements())
        }
lbl35:
        // 1 sources

        if (measureDim != null && !measureDim.equals("")) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_dimensions != null && this.m_dimensions.indexOf(key) > -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_members != null && this.m_members.indexOf(value) > -1;
    }

    @Override
    public Object get(Object key) {
        QDRMember member;
        if (key instanceof String && (member = this.getDimMember((String)key)) != null) {
            return member.getData();
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.remove(key);
        this.addDimMemberPair(key, new QDRMember(0, value));
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = this.get(key);
        if (old != null && key instanceof String) {
            this.removeDimMemberPair((String)key);
        }
        return old;
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.m_dimensions.clear();
        this.m_members.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.m_dimensions);
    }

    @Override
    public Collection<Object> values() {
        if (this.m_members != null) {
            Vector<Object> objs = new Vector<Object>();
            Enumeration memberEnum = this.m_members.elements();
            Object obj = null;
            while (memberEnum.hasMoreElements()) {
                obj = memberEnum.nextElement();
                if (obj instanceof QDRMember) {
                    objs.addElement(((QDRMember)obj).getData());
                    continue;
                }
                objs.addElement(null);
            }
            return objs;
        }
        return null;
    }

    @Override
    public Set entrySet() {
        if (this.m_dimensions == null) {
            return null;
        }
        ArrayList<QDRMapEntry> entryList = new ArrayList<QDRMapEntry>();
        Enumeration dims = this.m_dimensions.elements();
        String dim = null;
        while (dims.hasMoreElements()) {
            dim = (String)dims.nextElement();
            entryList.add(new QDRMapEntry(dim, this.get(dim)));
        }
        return new HashSet(entryList);
    }

    protected Vector cloneMembers(Vector v) throws CloneNotSupportedException {
        Vector newV = new Vector();
        Enumeration vlist = v.elements();
        while (vlist.hasMoreElements()) {
            Object element = vlist.nextElement();
            if (element != null) {
                newV.addElement(element);
                continue;
            }
            newV.addElement(element);
        }
        return newV;
    }

    @Override
    public Object getXML(XMLContext context) {
        ObjectScope scope;
        IDResolver resolver = null;
        boolean allProperties = true;
        String measDim = null;
        if (context != null && (scope = context.getScope()) != null) {
            resolver = (IDResolver)scope.getObject("PersistableIDResolver");
            Boolean allprops = (Boolean)scope.getObject(ALL_PROPERTIES);
            if (allprops != null) {
                allProperties = allprops;
            }
            measDim = (String)scope.getObject("MeasDimName");
        }
        ContainerNode root = new ContainerNode("dvt-cube:QDR");
        root.addProperty("xmlns:dvt-cube", "www.oracle.com/technology/");
        if (allProperties || !this.getMeasureDim().equals("")) {
            root.addProperty(MEASURE_DIM_NAME_PROPERTY, this.getMeasureDim());
        }
        Enumeration dimensions = this.getDimensions();
        while (dimensions.hasMoreElements()) {
            ObjectNode dimMemberPairNode = new ObjectNode("dvt-cube:DimMemPair");
            String dimension = (String)dimensions.nextElement();
            dimMemberPairNode.addProperty(DIMENSION_PROPERTY, dimension);
            QDRMember member = this.getDimMember(dimension);
            if (member != null) {
                QDRMember tempMember = null;
                try {
                    tempMember = (QDRMember)member.clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                Object qdrMemberNode = tempMember.getXML(context);
                if (qdrMemberNode instanceof ObjectNode) {
                    dimMemberPairNode.addProperty((ObjectNode)qdrMemberNode);
                } else {
                    dimMemberPairNode.addContainer((ContainerNode)qdrMemberNode);
                }
            }
            root.addContainedObject(dimMemberPairNode);
        }
        if (measDim == null) {
            measDim = this.m_measureDim;
        }
        Utility.setDependentID(context, this.getQDRMeasures(measDim, context), false, null);
        if (this.m_target != null) {
            ObjectNode targetObject = new ObjectNode(TARGET_PROPERTY);
            QDRMember tempMember = null;
            try {
                tempMember = (QDRMember)this.m_target.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            Object targetMemberNode = tempMember.getXML(context);
            if (targetMemberNode instanceof ObjectNode) {
                targetObject.addProperty((ObjectNode)targetMemberNode);
            } else {
                targetObject.addContainer((ContainerNode)targetMemberNode);
            }
            root.addContainedObject(targetObject);
        }
        return root;
    }

    @Override
    public void setXML(XMLContext context, Object node) {
        Enumeration targets;
        Vector oldMeas;
        Vector newMeas;
        Enumeration dimMemberPairs;
        ContainerNode qdrNode = (ContainerNode)node;
        PropertyNode pNode = qdrNode.getProperty(MEASURE_DIM_NAME_PROPERTY);
        if (pNode == null) {
            pNode = qdrNode.getProperty("dvt-cube:measureDimName");
        }
        if (pNode != null) {
            this.m_measureDim = pNode.getValueAsString();
        }
        if (!(dimMemberPairs = qdrNode.getContainedObject(DIM_MEMBER_PAIR_PROPERTY)).hasMoreElements()) {
            dimMemberPairs = qdrNode.getContainedObject("dvt-cube:DimMemPair");
        }
        while (dimMemberPairs.hasMoreElements()) {
            ObjectNode dimMemberPairNode = (ObjectNode)dimMemberPairs.nextElement();
            pNode = dimMemberPairNode.getProperty(DIMENSION_PROPERTY);
            if (pNode == null) {
                pNode = dimMemberPairNode.getProperty("dvt-cube:dim");
            }
            String dimension = pNode.getValueAsString();
            BaseObjectNode qdrMemberNode = dimMemberPairNode.getPropertyValueAsObjectNode("QDRMem", true);
            if (qdrMemberNode == null && (qdrMemberNode = dimMemberPairNode.getPropertyValueAsObjectNode("dvt-cube:QDRMem", true)) == null && (qdrMemberNode = dimMemberPairNode.getContainer("ListQDRMem")) == null) {
                qdrMemberNode = dimMemberPairNode.getContainer("dvt-cube:ListQDRMem");
            }
            if (qdrMemberNode == null) continue;
            QDRMember member = new QDRMember();
            member.setXML(context, qdrMemberNode);
            this.addDimMemberPair(dimension, member);
        }
        String measDim = Utility.getMeasureDimName(context);
        if (measDim == null) {
            measDim = this.m_measureDim;
        }
        if ((newMeas = Utility.getDependentID(context, oldMeas = this.getQDRMeasures(measDim, context), false, null)) != null) {
            this.setQDRMeasures(measDim, newMeas, context);
        }
        if ((targets = qdrNode.getContainedObject(TARGET_PROPERTY)) != null && targets.hasMoreElements()) {
            ObjectNode target = (ObjectNode)targets.nextElement();
            BaseObjectNode qdrMemberNode = target.getPropertyValueAsObjectNode("QDRMem", true);
            if (qdrMemberNode == null) {
                qdrMemberNode = target.getContainer("ListQDRMem");
            }
            if (qdrMemberNode != null) {
                QDRMember member = new QDRMember();
                member.setXML(context, qdrMemberNode);
                this.setTarget(member);
            }
        } else {
            this.setTarget(null);
        }
    }

    @Override
    public String getTagName() {
        return XML_NAME;
    }

    public static QDR setStateString(List memberContext, String stateString) {
        QDR qdr = new QDR();
        StringTokenizer entry = new StringTokenizer(stateString, PROPERTY_SEPARATOR_S);
        String dimensionMembers = null;
        Vector<String> target = new Vector<String>();
        while (entry.hasMoreTokens()) {
            if (dimensionMembers == null) {
                dimensionMembers = entry.nextToken();
                continue;
            }
            String dmPairs = entry.nextToken();
            int dimIndex = Integer.parseInt(dmPairs);
            MemberContext context = (MemberContext)memberContext.get(dimIndex);
            target.addElement(context.getDimID());
        }
        if (target.size() == 0) {
            qdr.setTarget(null);
        } else if (target.size() == 1) {
            qdr.setTarget(new QDRMember(0, target.elementAt(0)));
        } else {
            qdr.setTarget(new QDRMember(3, target));
        }
        if (dimensionMembers != null) {
            entry = new StringTokenizer(dimensionMembers, MemberContext.ENTRY_SEPARATOR_S);
            int begin = 0;
            while (entry.hasMoreTokens()) {
                String dmPairs = entry.nextToken();
                int end = dmPairs.indexOf(MemberContext.DIMENSION_SEPARATOR_S);
                if (end == -1) continue;
                int dimIndex = Integer.parseInt(dmPairs.substring(begin, end));
                MemberContext context = (MemberContext)memberContext.get(dimIndex);
                String dimension = context.getDimID();
                String members = dmPairs.substring(end + 1);
                StringTokenizer memList = new StringTokenizer(members, MemberContext.MEMBER_SEPARATOR_S);
                Vector<String> memVector = new Vector<String>();
                while (memList.hasMoreTokens()) {
                    int memIndex = Integer.parseInt(memList.nextToken());
                    String member = context.getMemberID(memIndex);
                    memVector.addElement(member);
                }
                if (memVector.size() == 0) {
                    qdr.addDimMemberPair(dimension, new QDRMember(null));
                    continue;
                }
                if (memVector.size() == 1) {
                    qdr.addDimMemberPair(dimension, new QDRMember(0, memVector.elementAt(0)));
                    continue;
                }
                qdr.addDimMemberPair(dimension, new QDRMember(3, memVector));
            }
        }
        return qdr;
    }

    public String getStateString(List memberContext) {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        Enumeration dimList = this.m_dimensions.elements();
        if (dimList == null) {
            return null;
        }
        int dimIndex = -1;
        Enumeration memList = this.m_members.elements();
        while (dimList.hasMoreElements()) {
            String dim = (String)dimList.nextElement();
            Object member = memList.nextElement();
            if (!first) {
                buffer.append(MemberContext.ENTRY_SEPARATOR_S);
            }
            first = false;
            dimIndex = RuleMemberContext.addDimensionMembers(memberContext, dim);
            buffer.append(dimIndex);
            if (DEBUG) {
                System.out.println(dim + ": " + dimIndex);
            }
            int memIndex = -1;
            if (!(member instanceof QDRMember)) continue;
            buffer.append(MemberContext.DIMENSION_SEPARATOR_S);
            buffer.append(((QDRMember)member).getStateString((MemberContext)memberContext.get(dimIndex)));
        }
        if (this.m_target != null) {
            Object data = this.m_target.getData();
            if (data instanceof String) {
                dimIndex = RuleMemberContext.addDimensionMembers(memberContext, (String)data);
                buffer.append('_');
                buffer.append(dimIndex);
            } else if (data instanceof Vector) {
                Enumeration values = ((Vector)data).elements();
                while (values.hasMoreElements()) {
                    String dim = (String)values.nextElement();
                    dimIndex = RuleMemberContext.addDimensionMembers(memberContext, dim);
                    buffer.append('_');
                    buffer.append(dimIndex);
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public Vector getDependentIDs(String measDim) {
        if (measDim == null) {
            measDim = this.m_measureDim;
        }
        return this.getQDRMeasures(measDim, null);
    }

    @Override
    public Vector getAllDependentIDs(String measDim, NameConverter nc) {
        if (this.m_dimensions == null) {
            return null;
        }
        Vector<String> depIDs = new Vector<String>();
        Enumeration dims = this.m_dimensions.elements();
        while (dims.hasMoreElements()) {
            Vector memberIDs;
            String dim = (String)dims.nextElement();
            depIDs.addElement(dim);
            QDRMember member = this.getDimMember(dim);
            if (member == null || (memberIDs = member.getAllDependentIDs(measDim, nc)) == null) continue;
            depIDs.addAll(memberIDs);
        }
        return depIDs.size() == 0 ? null : depIDs;
    }

    @Override
    public Vector setDependentIDs(String measDim, Vector newIDs) {
        if (measDim == null) {
            measDim = this.m_measureDim;
        }
        return this.setQDRMeasures(measDim, newIDs, null);
    }

    protected Vector getQDRMeasures(String strMeasure, XMLContext context) {
        Object obj;
        ObjectScope scope;
        boolean migrating = false;
        if (context != null && (scope = context.getScope()) != null && (obj = scope.getObject("migration")) != null) {
            migrating = true;
        }
        Vector<Object> vstrMeasureIDs = null;
        Enumeration enumDimensions = this.getDimensions();
        migrating = (strMeasure == null || strMeasure.equals("")) && migrating;
        while (enumDimensions.hasMoreElements()) {
            QDRMember qdrMember;
            String strDimension = (String)enumDimensions.nextElement();
            if (!strDimension.equals(strMeasure) && !migrating || (qdrMember = this.getDimMember(strDimension)) == null || !this.isFixedType(qdrMember) || !(qdrMember.getData() instanceof String)) continue;
            if (vstrMeasureIDs == null) {
                vstrMeasureIDs = new Vector<Object>();
            }
            vstrMeasureIDs.addElement(qdrMember.getData());
            if (!migrating) break;
        }
        return vstrMeasureIDs;
    }

    protected Vector setQDRMeasures(String strMeasure, Vector vstrMeasures, XMLContext context) {
        if (vstrMeasures != null) {
            Object obj;
            ObjectScope scope;
            boolean migrating = false;
            if (context != null && (scope = context.getScope()) != null && (obj = scope.getObject("migration")) != null) {
                migrating = true;
            }
            Enumeration enumDimensions = this.getDimensions();
            migrating = (strMeasure == null || strMeasure.equals("")) && migrating;
            while (enumDimensions.hasMoreElements()) {
                QDRMember qdrMember;
                String strDimension = (String)enumDimensions.nextElement();
                if (!strDimension.equals(strMeasure) && !migrating || (qdrMember = this.getDimMember(strDimension)) == null || !this.isFixedType(qdrMember) || !(qdrMember.getData() instanceof String)) continue;
                qdrMember.setData(vstrMeasures.firstElement());
                vstrMeasures.removeElementAt(0);
                if (!migrating) break;
            }
        }
        return vstrMeasures;
    }

    public boolean isDimensionSubsetOf(QDR qdr) {
        if (qdr == null) {
            return false;
        }
        Enumeration e = this.getDimensions();
        while (e.hasMoreElements()) {
            if (qdr.getDimMember((String)e.nextElement()) != null) continue;
            return false;
        }
        return true;
    }

    private void $init$() {
        this.m_target = null;
        this.m_dimensions = null;
        this.m_members = null;
        this.m_measureDim = "";
        this.m_memberVaries = new QDRMember(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QDRMapEntry
    implements Map.Entry {
        protected String m_key;
        protected Object m_value;

        private void $init$() {
            this.m_key = null;
            this.m_value = null;
        }

        public QDRMapEntry(String key, Object value) {
            this.$init$();
            this.m_key = key;
            this.m_value = value;
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object value) {
            Object old = this.m_value;
            this.m_value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry e2;
            Map.Entry entry = e2 = o instanceof Map.Entry ? (Map.Entry)o : null;
            return (this.getKey() == null ? e2.getKey() == null : this.getKey().equals(e2.getKey())) && this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue());
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

