/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dss.util.MemberContext;
import oracle.dss.util.Utility;

public class RuleMemberContext
implements MemberContext {
    protected int m_dimIndex;
    protected String m_dimension;
    protected List m_members;

    public RuleMemberContext() {
    }

    public RuleMemberContext(String dimension) {
        this.m_dimension = dimension;
        this.m_members = new ArrayList();
    }

    public String getDimID() {
        return this.m_dimension;
    }

    public void setDimIndex(int dimIndex) {
        this.m_dimIndex = dimIndex;
    }

    public int getDimIndex() {
        return this.m_dimIndex;
    }

    public String getMemberID(int memberIndex) {
        return (String)this.m_members.get(memberIndex);
    }

    public int getMemberCount() {
        return this.m_members.size();
    }

    public int getMemberIndex(String member) {
        int i = 0;
        while (i < this.m_members.size()) {
            String entry = (String)this.m_members.get(i);
            if (entry.equals(member)) {
                return i;
            }
            ++i;
        }
        this.m_members.add(member);
        return this.m_members.size() - 1;
    }

    public static int addDimensionMembers(List dimMembers, String dimString) {
        RuleMemberContext dimension = new RuleMemberContext(dimString);
        int i = 0;
        while (i < dimMembers.size()) {
            MemberContext entry = (MemberContext)dimMembers.get(i);
            if (entry.equals(dimension)) {
                return i;
            }
            ++i;
        }
        int dimIndex = dimMembers.size();
        dimMembers.add(dimension);
        dimension.setDimIndex(dimIndex);
        return dimIndex;
    }

    public boolean equals(MemberContext member) {
        return Utility.compareObj(member.getDimID(), this.getDimID());
    }

    public boolean equals(Object o) {
        if (o instanceof RuleMemberContext) {
            RuleMemberContext entry = (RuleMemberContext)o;
            return Utility.compareObj(entry.getDimID(), this.getDimID());
        }
        return false;
    }

    public void setStateString(String dimensionMembers, boolean isCheckpoint) {
        String strMembers = Utility.unescapeStateString(dimensionMembers, MemberContext.ESCAPE_CHARS, null, '-');
        int separator = strMembers.indexOf(MemberContext.DIMENSION_SEPARATOR_S);
        if (separator == -1) {
            return;
        }
        this.m_dimension = strMembers.substring(0, separator);
        strMembers = strMembers.substring(separator + 1);
        this.m_members = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(strMembers, MemberContext.MEMBER_SEPARATOR_S);
        while (tokenizer.hasMoreTokens()) {
            this.m_members.add(tokenizer.nextToken());
        }
    }

    public String getStateString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Utility.escapeStateString(this.getDimID(), MemberContext.ESCAPE_CHARS, null, '-'));
        String separator = MemberContext.DIMENSION_SEPARATOR_S;
        int i = 0;
        while (i < this.m_members.size()) {
            buffer.append(separator);
            separator = MemberContext.MEMBER_SEPARATOR_S;
            buffer.append(Utility.escapeStateString((String)this.m_members.get(i), MemberContext.ESCAPE_CHARS, null, '-'));
            ++i;
        }
        return buffer.toString();
    }

    public static List deserializeDimMembersContext(String dimMemberPairs) {
        ArrayList<RuleMemberContext> list = new ArrayList<RuleMemberContext>();
        if (dimMemberPairs != null && dimMemberPairs.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(dimMemberPairs, MemberContext.ENTRY_SEPARATOR_S);
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                RuleMemberContext context = new RuleMemberContext();
                context.setDimIndex(list.size());
                list.add(context);
                context.setStateString(entry, false);
            }
        }
        return list;
    }

    public static String serializeDimMembersContext(List dimMembers) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < dimMembers.size()) {
            Object entry = dimMembers.get(i);
            if (entry instanceof RuleMemberContext) {
                buffer.append(((RuleMemberContext)entry).getStateString());
                if (i < dimMembers.size() - 1) {
                    buffer.append(MemberContext.ENTRY_SEPARATOR_S);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

