/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class SeriesComponentInfo
extends ComponentInfo {
    private int _series;
    private int m_edge;

    public SeriesComponentInfo(int series) {
        this._series = series;
        this.m_edge = 1;
    }

    public SeriesComponentInfo(int series, int edge) {
        this._series = series;
        this.m_edge = edge;
    }

    public Object clone() {
        return new SeriesComponentInfo(this._series, this.m_edge);
    }

    public int getSeries() {
        return this._series;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SeriesComponentInfo)) {
            return false;
        }
        return this.getSeries() == ((SeriesComponentInfo)o).getSeries() && this.getEdge() == ((SeriesComponentInfo)o).getEdge();
    }

    public QDR getQDR(DataAccess dataAccess, int flags) {
        try {
            QDR qDR = dataAccess.getSliceQDR(this.m_edge, this.getSeries(), flags);
            return qDR;
        }
        catch (Exception e) {
            QDR qDR = null;
            return qDR;
        }
    }

    public int hashCode() {
        return this._series ^ this._series >> 32;
    }

    public String toString() {
        return "series=" + this._series;
    }
}

