/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.dss.util.Collection;
import oracle.dss.util.UpdatableSet;
import oracle.dss.util.Utility;

public class UpdatableSetImpl
implements UpdatableSet,
Serializable {
    protected Vector m_objects;
    protected int m_initialCapacity;
    protected int m_capacityIncrement;

    private void $init$() {
        this.m_objects = null;
    }

    public UpdatableSetImpl() {
        this.$init$();
        this.m_initialCapacity = -1;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector();
    }

    public UpdatableSetImpl(int initialCapacity) {
        this.$init$();
        this.m_initialCapacity = initialCapacity;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector(this.m_initialCapacity);
    }

    public UpdatableSetImpl(int initialCapacity, int capacityIncrement) {
        this.$init$();
        this.m_initialCapacity = initialCapacity;
        this.m_capacityIncrement = capacityIncrement;
        this.m_objects = new Vector(this.m_initialCapacity, this.m_capacityIncrement);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UpdatableSetImpl)) {
            return false;
        }
        UpdatableSetImpl set = (UpdatableSetImpl)obj;
        return Utility.compareVectors(this.m_objects, set.m_objects);
    }

    public Collection duplicate() {
        Collection c = null;
        try {
            c = (Collection)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        ((UpdatableSetImpl)c).m_objects = (Vector)this.m_objects.clone();
        return c;
    }

    public int size() {
        return this.m_objects.size();
    }

    public boolean isEmpty() {
        return this.m_objects.isEmpty();
    }

    public boolean includes(Object element) {
        return this.m_objects.contains(element);
    }

    public Enumeration elements() {
        return this.m_objects.elements();
    }

    public void clear() {
        this.m_objects.removeAllElements();
    }

    public void include(Object element) {
        if (!this.m_objects.contains(element)) {
            this.m_objects.addElement(element);
        }
    }

    public void removeOneOf(Object element) {
        this.m_objects.removeElement(element);
    }

    public void exclude(Object element) {
        while (this.m_objects.contains(element)) {
            this.m_objects.removeElement(element);
        }
    }

    public Object take() throws NoSuchElementException {
        Object o = this.m_objects.firstElement();
        this.m_objects.removeElementAt(0);
        return o;
    }

    public void includeElements(Enumeration e) {
        Object element = null;
        while (e.hasMoreElements()) {
            element = e.nextElement();
            if (this.m_objects.contains(element)) continue;
            this.m_objects.addElement(element);
        }
    }

    public void removeElements(Enumeration e) {
        while (e.hasMoreElements()) {
            this.removeOneOf(e.nextElement());
        }
    }

    public static void main(String[] argv) {
        UpdatableSetImpl c = new UpdatableSetImpl();
        c.include(new String("This"));
        c.include(new String("is"));
        c.include(new String("Spinal"));
        c.include(new String("Tap"));
        System.out.println(c.size());
        Enumeration e = c.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            System.out.println(s);
        }
    }
}

