/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.IDResolver;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.GUIDConverter;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.PropertyNode;

public class Utility {
    public static final int START_UNDERLINE = 2;
    public static final int SPACE_UNDERLINE = 2;
    public static final char SC_TRUE = '1';
    public static final char SC_FALSE = '0';

    public static Vector cloneVector(Vector v) throws CloneNotSupportedException {
        Vector<Object> newV = new Vector<Object>();
        Enumeration vlist = v.elements();
        while (vlist.hasMoreElements()) {
            Object element = vlist.nextElement();
            if (element != null) {
                if (!(element instanceof VectorClone)) continue;
                newV.addElement(((VectorClone)element).clone());
                continue;
            }
            newV.addElement(element);
        }
        return newV;
    }

    public static Hashtable cloneHashtable(Hashtable t) throws CloneNotSupportedException {
        Hashtable newtable = new Hashtable();
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            VectorClone value = (VectorClone)t.get(key);
            newtable.put(key, value.clone());
        }
        return newtable;
    }

    public static boolean compareArrays(Object[] list1, Object[] list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        int i = 0;
        while (i < list1.length) {
            if (list1[i] == null ? list2[i] != null : !list1[i].equals(list2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean compareHashtables(Hashtable table1, Hashtable table2) {
        if (table1 == null && table2 == null) {
            return true;
        }
        if (table1 == null || table2 == null) {
            return false;
        }
        if (table1.size() != table2.size()) {
            return false;
        }
        Enumeration keys1 = table1.keys();
        Enumeration keys2 = table2.keys();
        while (keys1.hasMoreElements()) {
            Object obj2;
            Object key2;
            Object key1 = keys1.nextElement();
            if (!Utility.compareObj(key1, key2 = keys2.nextElement())) {
                return false;
            }
            Object obj1 = table1.get(key1);
            if (Utility.compareObj(obj1, obj2 = table2.get(key2))) continue;
            return false;
        }
        return true;
    }

    public static Object[][] arraycopy(Object[][] src) {
        if (src == null) {
            return null;
        }
        int[] dims = new int[]{src.length, 5};
        Object[][] dest = (Object[][])Array.newInstance(src.getClass().getComponentType().getComponentType(), dims);
        Object temp = null;
        int i = 0;
        while (i < src.length) {
            dest[i] = Utility.arraycopy(src[i]);
            ++i;
        }
        return dest;
    }

    public static Object[] arraycopy(Object[] src) {
        if (src == null) {
            return null;
        }
        Object[] dest = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length);
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static Object[] copyVectorToArray(Vector vector) {
        return Utility.copyVectorToArray(vector, null);
    }

    public static Object[] copyVectorToArray(Vector vObjects, Class classBase) {
        if (vObjects == null || vObjects.size() == 0) {
            return null;
        }
        Enumeration enumeration = vObjects.elements();
        Object object = null;
        while (enumeration.hasMoreElements() && object == null) {
            object = enumeration.nextElement();
        }
        if (object == null) {
            return null;
        }
        if (classBase == null) {
            classBase = object.getClass();
        }
        Object[] objectArray = (Object[])Array.newInstance(classBase, vObjects.size());
        vObjects.copyInto(objectArray);
        return objectArray;
    }

    public static Vector copyArrayToVector(Object[] array) {
        if (array == null) {
            return new Vector();
        }
        Vector<Object> ret = new Vector<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            ret.addElement(array[i]);
            ++i;
        }
        return ret;
    }

    public static boolean compareVectors(Vector v1, Vector v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        Object element1 = null;
        Object element2 = null;
        int element = 0;
        while (element < v1.size()) {
            element1 = v1.elementAt(element);
            element2 = v2.elementAt(element);
            if (element1 == null) {
                if (element2 != null) {
                    return false;
                }
            } else if (!element1.equals(element2)) {
                return false;
            }
            ++element;
        }
        return true;
    }

    public static boolean compareLists(String[] list1, String[] list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < list1.length) {
            int j = 0;
            while (j < list2.length) {
                if (list2[j].equals(list1[i])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            found = false;
            ++i;
        }
        return true;
    }

    public static boolean compareListsExact(String[] list1, String[] list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        int i = 0;
        while (i < list1.length) {
            if (list1[i] == null ? list2[i] != null : !list1[i].equals(list2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] combineArrays(String[] one, String[] two) {
        if (one == null && two == null) {
            return null;
        }
        int oneCount = one != null ? one.length : 0;
        int twoCount = two != null ? two.length : 0;
        String[] combined = new String[oneCount + twoCount];
        int pos = 0;
        int i = 0;
        while (i < oneCount) {
            combined[pos++] = one[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < twoCount) {
            combined[pos++] = two[i2];
            ++i2;
        }
        return combined;
    }

    public static String[] flattenArray(String[][] twod) {
        if (twod == null) {
            return null;
        }
        int count = 0;
        int i = 0;
        while (i < twod.length) {
            count += twod[i].length;
            ++i;
        }
        String[] ret = new String[count];
        count = 0;
        i = 0;
        while (i < twod.length) {
            int j = 0;
            while (j < twod[i].length) {
                ret[count++] = twod[i][j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return null;
        }
        Object obj = null;
        if (array.getClass().isArray()) {
            String tmp = "{";
            int length = Array.getLength(array);
            int i = 0;
            while (i < length - 1) {
                obj = Array.get(array, i);
                tmp = obj.getClass().isArray() ? tmp + Utility.arrayToString(obj) + "," : tmp + obj + ",";
                ++i;
            }
            if (length > 0) {
                obj = Array.get(array, length - 1);
                tmp = obj.getClass().isArray() ? tmp + Utility.arrayToString(obj) : tmp + obj;
            }
            tmp = tmp + "}";
            return tmp;
        }
        return array.toString();
    }

    public static String ObjectToString(Object object) {
        int nValue = 0;
        String string = new String();
        byte[] buffer = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            buffer = byteArrayOutputStream.toByteArray();
            int nIndex = 0;
            while (nIndex < buffer.length) {
                nValue = buffer[nIndex];
                if (nValue < 0) {
                    nValue += 256;
                } else if (nValue >= 0 && nValue < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(nValue);
                ++nIndex;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return string;
    }

    public static Object StringToObject(String string) {
        int nBufferIndex = 0;
        byte[] buffer = new byte[string.length() / 2];
        Object object = null;
        int nIndex = 0;
        while (nIndex < string.length()) {
            int nValue = Integer.parseInt(string.substring(nIndex, nIndex + 2), 16);
            Integer Int = new Integer(nValue);
            buffer[nBufferIndex] = Int.byteValue();
            nIndex += 2;
            ++nBufferIndex;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return object;
    }

    public static Object instantiateClass(String strClassName, Class[] classConstructorArgs, Object[] objectArgs, ErrorHandler eh) {
        Object objectOutput;
        block11: {
            objectOutput = null;
            Class classOutput = null;
            if (strClassName != null) {
                block9: {
                    try {
                        classOutput = Utility.loadClass(strClassName);
                    }
                    catch (ClassNotFoundException e) {
                        if (eh == null) break block9;
                        eh.error(e, "Utility", "instantiateClass");
                    }
                }
                if (classOutput != null && classConstructorArgs != null) {
                    Constructor constructor;
                    block10: {
                        constructor = null;
                        try {
                            constructor = classOutput.getConstructor(classConstructorArgs);
                        }
                        catch (NoSuchMethodException e) {
                            if (eh == null) break block10;
                            eh.error(e, "Utility", "instantiateClass");
                        }
                    }
                    if (constructor != null && objectArgs != null) {
                        try {
                            objectOutput = constructor.newInstance(objectArgs);
                        }
                        catch (Exception e) {
                            if (eh == null) break block11;
                            eh.error(e, "Utility", "instantiateClass");
                        }
                    }
                }
            }
        }
        return objectOutput;
    }

    public static boolean contains(Vector vector1, Vector vector2) {
        if (vector1.size() < vector2.size()) {
            return false;
        }
        Enumeration e = vector2.elements();
        while (e.hasMoreElements()) {
            if (vector1.contains(e.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static boolean compareObj(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        if (obj2 != null) {
            return obj2.equals(obj1);
        }
        return true;
    }

    public static int compareXMLVersions(String ver1, String ver2) {
        int[] version1 = Utility._convertXMLVersionToIntArray(ver1);
        int[] version2 = Utility._convertXMLVersionToIntArray(ver2);
        int i = 0;
        while (i < version1.length) {
            if (version2.length < i + 1) {
                return 1;
            }
            if (version1[i] < version2[i]) {
                return -1;
            }
            if (version1[i] > version2[i]) {
                return 1;
            }
            ++i;
        }
        if (version1.length == version2.length) {
            return 0;
        }
        return -1;
    }

    private static int[] _convertXMLVersionToIntArray(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        String token = null;
        int tokenCount = st.countTokens();
        int[] versionArray = new int[tokenCount];
        int i = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            Integer n = null;
            try {
                n = Integer.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                n = new Integer(0);
            }
            versionArray[i++] = n;
        }
        return versionArray;
    }

    public static String escapeStateString(String str, char[] escapeChars, char[] replaceChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        int escapeCount = escapeChars.length;
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            char ch = str.charAt(i);
            boolean charProcessed = false;
            if (ch == escapeChar) {
                buffer.append(escapeChar);
                buffer.append(0);
                charProcessed = true;
            } else {
                int j = 0;
                while (j < escapeCount) {
                    if (ch == escapeChars[j]) {
                        buffer.append(escapeChar);
                        buffer.append(j + 1);
                        charProcessed = true;
                        break;
                    }
                    if (replaceChars != null && ch == replaceChars[j]) {
                        buffer.append(escapeChars[j]);
                        charProcessed = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!charProcessed) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unescapeStateString(String str, char[] escapeChars, char[] replaceChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        int escapeCharsCount = escapeChars.length;
        int count = 0;
        StringBuffer buffer = new StringBuffer(length);
        while (count < length) {
            char ch = str.charAt(count);
            if (ch == escapeChar && ++count < length) {
                char nextCh = str.charAt(count);
                if (Character.isDigit(nextCh)) {
                    int index = Character.digit(nextCh, 10);
                    if (index == 0) {
                        buffer.append(escapeChar);
                    } else if (index <= escapeCharsCount) {
                        buffer.append(escapeChars[index - 1]);
                    }
                }
            } else {
                boolean charProcessed = false;
                if (replaceChars != null) {
                    int j = 0;
                    while (j < escapeCharsCount) {
                        if (ch == escapeChars[j]) {
                            buffer.append(replaceChars[j]);
                            charProcessed = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!charProcessed) {
                    buffer.append(ch);
                }
            }
            ++count;
        }
        return buffer.toString();
    }

    public static void setDependentID(XMLContext context, Vector ids, boolean onlyIfMeasureDim, String dim) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        IDResolver resolver = null;
        String measDimName = Utility.getMeasureDimName(context);
        if (onlyIfMeasureDim && dim != null && !dim.equals(measDimName)) {
            return;
        }
        resolver = Utility.getIDResolver(context);
        if (resolver == null) {
            return;
        }
        String id = null;
        Enumeration idsEnum = ids.elements();
        while (idsEnum.hasMoreElements()) {
            id = (String)idsEnum.nextElement();
            if (id == null) continue;
            resolver.setDependentID(id);
        }
    }

    public static Vector getDependentID(XMLContext context, Vector ids, boolean onlyIfMeasureDim, String dim) {
        IDResolver resolver = null;
        String measDimName = Utility.getMeasureDimName(context);
        if (onlyIfMeasureDim && dim != null && !dim.equals(measDimName)) {
            return ids;
        }
        resolver = Utility.getIDResolver(context);
        if (ids == null) {
            return null;
        }
        Vector<String> retIDs = new Vector<String>();
        String id = null;
        GUIDConverter converter = null;
        if (Utility.getMigrationFlag(context) != null) {
            converter = Utility.getGUIDConverter(context);
        }
        Enumeration idsEnum = ids.elements();
        while (idsEnum.hasMoreElements()) {
            id = (String)idsEnum.nextElement();
            if (id != null) {
                String oldID = id;
                if (converter != null) {
                    try {
                        String tempID = oldID;
                        id = converter.getGUIDForPath(tempID, true, "PSR");
                    }
                    catch (NamingException e) {
                        id = null;
                    }
                } else if (resolver != null) {
                    id = resolver.getDependentID(oldID);
                }
                if (id == null || id.equals("invalid id")) {
                    retIDs.addElement(oldID);
                    continue;
                }
                retIDs.addElement(id);
                continue;
            }
            retIDs.addElement(id);
        }
        return retIDs;
    }

    public static String getMeasureDimName(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (String)scope.getObject("MeasDimName");
        }
        return null;
    }

    public static IDResolver getIDResolver(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (IDResolver)scope.getObject("PersistableIDResolver");
        }
        return null;
    }

    public static Object getMigrationFlag(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return scope.getObject("migration");
        }
        return null;
    }

    public static GUIDConverter getGUIDConverter(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (GUIDConverter)scope.getObject("full_path_to_guid_converter");
        }
        return null;
    }

    public static boolean compareVersionStrings(String version1, String version2) {
        if (version2 == null) {
            return true;
        }
        if (version1 == null) {
            return false;
        }
        int verPos1 = 0;
        int verPos2 = 0;
        do {
            int num2;
            int num1;
            if ((num1 = Utility._getNextVersionNumber(version1, verPos1)) > (num2 = Utility._getNextVersionNumber(version2, verPos2))) {
                return true;
            }
            if (num2 > num1) {
                return false;
            }
            verPos1 = version1.indexOf(".", verPos1) + 1;
            verPos2 = version2.indexOf(".", verPos2) + 1;
        } while (verPos1 > 0 && verPos1 <= version1.length() && verPos2 > 0 && verPos2 <= version2.length());
        return verPos1 > 0 && verPos1 <= version1.length();
    }

    private static int _getNextVersionNumber(String version, int start) {
        if (start >= version.length()) {
            return -1;
        }
        int sepPos = version.indexOf(".", start);
        String num = null;
        num = sepPos == -1 ? version.substring(start) : version.substring(start, sepPos);
        return Integer.parseInt(num);
    }

    public static Class loadClass(String a_classname) throws ClassNotFoundException {
        Class<?> bClass = null;
        if (a_classname == null) {
            return null;
        }
        try {
            bClass = Class.forName(a_classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (bClass == null) {
            bClass = Class.forName(a_classname);
        }
        return bClass;
    }

    public static char getBooleanAsChar(boolean value) {
        return value ? (char)'1' : '0';
    }

    public static boolean getValueAsBoolean(PropertyNode node) {
        return node.getValueAsCharacter() == '1';
    }

    public static class PropertyType {
        protected static final String DATE = "date";
        protected static final String INTEGER = "integer";
        protected static final String LONG = "long";
        protected static final String DOUBLE = "double";
        protected static final String FLOAT = "float";
        protected static final String BOOLEAN = "boolean";
        protected static final String STRING = "string";

        public static void storeData(BaseObjectNode node, Object data, String memberPropertyName, String typePropertyName) {
            String strData = null;
            String type = PropertyType.getType(data);
            if (data instanceof Date) {
                long longDate = ((Date)data).getTime();
                data = new Long(longDate);
            }
            strData = data.toString();
            node.addProperty(memberPropertyName, strData);
            node.addProperty(typePropertyName, type);
        }

        public static Object retrieveData(BaseObjectNode node, String memberPropertyName, String typePropertyName) throws NoSuchPropertyException {
            String type = node.getPropertyValueAsString(typePropertyName);
            String data = node.getPropertyValueAsString(memberPropertyName);
            return PropertyType.getData(data, type);
        }

        public static Object getData(String data, String type) {
            if (type == null) {
                return data;
            }
            if (type.equals(STRING)) {
                return data;
            }
            if (type.equals(DATE)) {
                return new Date(new Long(data));
            }
            if (type.equals(INTEGER)) {
                return new Integer(data);
            }
            if (type.equals(LONG)) {
                return new Long(data);
            }
            if (type.equals(FLOAT)) {
                return new Float(data);
            }
            if (type.equals(DOUBLE)) {
                return new Double(data);
            }
            if (type.equals(BOOLEAN)) {
                return new Boolean(data);
            }
            return data;
        }

        public static String getType(Object data) {
            if (data instanceof Date) {
                return DATE;
            }
            if (data instanceof Integer) {
                return INTEGER;
            }
            if (data instanceof Double) {
                return DOUBLE;
            }
            if (data instanceof Float) {
                return FLOAT;
            }
            if (data instanceof Boolean) {
                return BOOLEAN;
            }
            if (data instanceof Long) {
                return LONG;
            }
            if (data instanceof String) {
                return STRING;
            }
            return null;
        }
    }
}

