/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLInfo;
import oracle.dss.util.converter.ResourceBundleToXMLProductCodeInfo;
import oracle.dss.util.converter.ResourceBundleToXMLUtil;

public class ResourceBundleToXMLFile {
    public String m_strFilePath = null;
    public ResourceBundleToXMLUtil m_rb2XmlUtil = null;

    public ResourceBundleToXMLFile(String strFilePath, ResourceBundleToXMLUtil rb2XmlUtil) {
        this.m_strFilePath = strFilePath;
        this.m_rb2XmlUtil = rb2XmlUtil;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processErrorFile() {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            boolean bl;
            try {
                boolean flag2;
                this.m_rb2XmlUtil.logMessage("Error codes for resource " + this.m_strFilePath + ":");
                fis = new FileInputStream(this.m_strFilePath);
                br = new BufferedReader(new InputStreamReader(fis));
                Vector<String> vLines = new Vector<String>();
                String strCurLine = br.readLine();
                while (br.ready()) {
                    vLines.addElement(new String(strCurLine));
                    strCurLine = br.readLine();
                }
                if (vLines.size() == 0) {
                    boolean flag1;
                    bl = flag1 = false;
                    return bl;
                }
                boolean bl2 = flag2 = this.reallyProcessErrorFile(vLines);
                return bl2;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fis == null) return bl;
                    fis.close();
                    return bl;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable t) {
            boolean flag;
            t.printStackTrace();
            this.m_rb2XmlUtil.logMessage("Error processing file = " + this.m_strFilePath + "." + t);
            boolean bl = flag = false;
            try {
                if (br != null) {
                    br.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean reallyProcessErrorFile(Vector vLines) {
        boolean bInComment = false;
        int nLastTagCode = -1;
        ResourceBundleToXMLInfo rbInfo = null;
        int i = 0;
        while (i < vLines.size()) {
            block54: {
                String strCurLine;
                block60: {
                    String strFirstWord;
                    block67: {
                        block66: {
                            block65: {
                                block64: {
                                    int nWhitespaceIndex;
                                    block63: {
                                        block62: {
                                            block61: {
                                                String strTemp;
                                                block56: {
                                                    ResourceBundleToXMLProductCodeInfo curEdpci;
                                                    HashMap hCompNames;
                                                    block58: {
                                                        block59: {
                                                            block57: {
                                                                int _separatorIdx;
                                                                block55: {
                                                                    strCurLine = new String((String)vLines.elementAt(i));
                                                                    if ((strCurLine = strCurLine.trim()).length() == 0) break block54;
                                                                    if (strCurLine.equalsIgnoreCase("/**")) {
                                                                        bInComment = true;
                                                                        nLastTagCode = -1;
                                                                        rbInfo = new ResourceBundleToXMLInfo(this.m_strFilePath);
                                                                    }
                                                                    if (!strCurLine.equalsIgnoreCase("*/") && !strCurLine.equalsIgnoreCase("**/")) break block55;
                                                                    bInComment = false;
                                                                    nLastTagCode = -1;
                                                                    break block54;
                                                                }
                                                                if (!strCurLine.startsWith("{") || rbInfo == null || !rbInfo.isValidInfo()) break block56;
                                                                int lastBracketIdx = strCurLine.lastIndexOf("}");
                                                                if (lastBracketIdx <= 0) break block57;
                                                                String _keyAndText = strCurLine.substring(1, lastBracketIdx);
                                                                char _c1 = _keyAndText.charAt(0);
                                                                String firstChar = String.valueOf(_c1);
                                                                boolean _shouldSkipKey = false;
                                                                if (firstChar.equals("\"")) {
                                                                    int lastQuoteIdx = _keyAndText.indexOf("\"", 1);
                                                                    _separatorIdx = _keyAndText.indexOf(",", lastQuoteIdx);
                                                                    _shouldSkipKey = true;
                                                                } else {
                                                                    _separatorIdx = _keyAndText.indexOf(",");
                                                                }
                                                                String _errKey = new String();
                                                                if (!_shouldSkipKey) {
                                                                    _errKey = _keyAndText.substring(0, _separatorIdx);
                                                                    _errKey = _errKey.trim();
                                                                } else {
                                                                    _errKey = "DVT-" + rbInfo.m_strErrNum;
                                                                }
                                                                String _errText = _keyAndText.substring(_separatorIdx + 1);
                                                                _errText = _errText.trim();
                                                                _errText = _errText.substring(1, _errText.length() - 1);
                                                                if (_errText.startsWith("DVT-")) {
                                                                    int spaceIdx = _errText.indexOf(" ");
                                                                    _errText = _errText.substring(spaceIdx + 1).trim();
                                                                }
                                                                rbInfo.m_strErrorKey = _errKey;
                                                                rbInfo.m_strErrorText = _errText;
                                                                this.m_rb2XmlUtil.logMessage("   " + rbInfo.m_strErrNum);
                                                                if (rbInfo.m_oUnknownTags.size() <= 0) break block58;
                                                                break block59;
                                                            }
                                                            this.m_rb2XmlUtil.logMessage("Error: the {key, error text} component has invalid format. Missing closing paranthesis }");
                                                            rbInfo.m_lErrNum = -1;
                                                            break block54;
                                                        }
                                                        rbInfo.m_lErrNum = -1;
                                                    }
                                                    if ((hCompNames = this.m_rb2XmlUtil.getComponentNames()).containsKey(rbInfo.m_strProdCode) && (curEdpci = (ResourceBundleToXMLProductCodeInfo)hCompNames.get(rbInfo.m_strProdCode)) != null) {
                                                        curEdpci.m_vErrorComments.add(rbInfo);
                                                    }
                                                    rbInfo = null;
                                                }
                                                if (!bInComment) break block54;
                                                strCurLine = this.processLine(strCurLine);
                                                strCurLine = strCurLine.replace("<code>", "");
                                                if ((strCurLine = strCurLine.replace("</code>", "")).length() == 0) break block54;
                                                if (!strCurLine.startsWith("@")) break block60;
                                                strFirstWord = this._getFirstWord(strCurLine);
                                                if (!strFirstWord.equalsIgnoreCase("@Error") || rbInfo == null) break block61;
                                                nLastTagCode = 0;
                                                if (rbInfo != null && (strTemp = strCurLine.substring(strFirstWord.length())) != null) {
                                                    rbInfo.m_strError = strTemp.trim();
                                                }
                                                try {
                                                    int nHyphenIndex = rbInfo.m_strError.indexOf("-");
                                                    if (nHyphenIndex < 0) {
                                                        throw new Exception();
                                                    }
                                                    String strProdCode = rbInfo.m_strError.substring(0, nHyphenIndex);
                                                    if (strProdCode.equalsIgnoreCase("BIB")) {
                                                        strProdCode = "DVT";
                                                    }
                                                    String strTemp2 = rbInfo.m_strError.substring(nHyphenIndex + 1);
                                                    int nNextWhitespaceIndex = strTemp2.indexOf(" ");
                                                    String strErrorNum = strTemp2.substring(0, nNextWhitespaceIndex);
                                                    long lErrorNum = -1;
                                                    try {
                                                        strErrorNum = this.paddingString(strErrorNum, 5, '0', true);
                                                        StringBuffer _sb = new StringBuffer();
                                                        boolean wrongNumber = false;
                                                        int _i = 0;
                                                        while (_i < strErrorNum.length()) {
                                                            char _c = strErrorNum.charAt(_i);
                                                            if (Character.isDigit(_c)) {
                                                                _sb.append(String.valueOf(_c));
                                                            } else if (_i != 0 && _i != strErrorNum.length() - 1) {
                                                                wrongNumber = true;
                                                                break;
                                                            }
                                                            ++_i;
                                                        }
                                                        if (!wrongNumber) {
                                                            strErrorNum = _sb.toString();
                                                            lErrorNum = Long.parseLong(strErrorNum);
                                                        } else {
                                                            lErrorNum = -1;
                                                        }
                                                    }
                                                    catch (NumberFormatException nfe) {
                                                        lErrorNum = -1;
                                                    }
                                                    HashMap hProdCodes = this.m_rb2XmlUtil.getComponentNames();
                                                    if (this.m_rb2XmlUtil.shouldInferProdCodesFromErrorComments()) {
                                                        if (!hProdCodes.containsKey(strProdCode)) {
                                                            hProdCodes.put(strProdCode, ResourceBundleToXMLProductCodeInfo.createObject(strProdCode, null));
                                                        }
                                                        rbInfo.m_strProdCode = strProdCode;
                                                        rbInfo.m_lErrNum = lErrorNum;
                                                        rbInfo.m_strErrNum = strErrorNum;
                                                        break block54;
                                                    }
                                                    if (!hProdCodes.containsKey(strProdCode)) break block54;
                                                    if ((long)-1 == lErrorNum) {
                                                        rbInfo.m_strProdCode = strProdCode;
                                                        rbInfo.m_lErrNum = -1;
                                                        break block54;
                                                    }
                                                    ResourceBundleToXMLProductCodeInfo edpci = (ResourceBundleToXMLProductCodeInfo)hProdCodes.get(strProdCode);
                                                    if ((long)-1 == edpci.m_lLowerBound && (long)-1 == edpci.m_lUpperBound) {
                                                        rbInfo.m_strProdCode = strProdCode;
                                                        rbInfo.m_lErrNum = lErrorNum;
                                                        rbInfo.m_strErrNum = strErrorNum;
                                                        break block54;
                                                    } else if (edpci.m_lLowerBound <= lErrorNum && lErrorNum <= edpci.m_lUpperBound) {
                                                        rbInfo.m_strProdCode = strProdCode;
                                                        rbInfo.m_lErrNum = lErrorNum;
                                                    }
                                                    break block54;
                                                }
                                                catch (Throwable t) {
                                                    this.m_rb2XmlUtil.logMessage("Error encountered while parsing documentation comments. File = " + this.m_strFilePath + ". ");
                                                    this.m_rb2XmlUtil.logMessage("@error = " + rbInfo.m_strError);
                                                    this.m_rb2XmlUtil.logMessage("Warning. The error is expected to be in the format DVT-XXXX <Error Message> or the format DVT-XXXXX <Error Message>.");
                                                    rbInfo.m_lErrNum = -1;
                                                }
                                                break block54;
                                            }
                                            if (!strFirstWord.equalsIgnoreCase("@Cause") || rbInfo == null) break block62;
                                            nLastTagCode = 1;
                                            String strTemp = strCurLine.substring(strFirstWord.length());
                                            if (strTemp != null) {
                                                rbInfo.m_strCause = strTemp.trim();
                                            }
                                            break block54;
                                        }
                                        if (!strFirstWord.equalsIgnoreCase("@Action") || rbInfo == null) break block63;
                                        nLastTagCode = 2;
                                        String strTemp = strCurLine.substring(strFirstWord.length());
                                        if (strTemp != null) {
                                            rbInfo.m_strAction = strTemp.trim();
                                        }
                                        break block54;
                                    }
                                    if (!strFirstWord.equalsIgnoreCase("@Status") || rbInfo == null) break block64;
                                    nLastTagCode = 3;
                                    String strTextAfterTag = strCurLine.substring(strFirstWord.length());
                                    if (strTextAfterTag != null) {
                                        strTextAfterTag = strTextAfterTag.trim();
                                    }
                                    if ((nWhitespaceIndex = strTextAfterTag.indexOf(" ")) > 0) {
                                        rbInfo.m_oStatusInfo.m_strValue = strTextAfterTag.substring(0, nWhitespaceIndex);
                                        rbInfo.m_oStatusInfo.m_strComment = strTextAfterTag.substring(nWhitespaceIndex + 1);
                                        break block54;
                                    } else {
                                        rbInfo.m_oStatusInfo.m_strValue = strTextAfterTag;
                                        rbInfo.m_oStatusInfo.m_strComment = "";
                                    }
                                    break block54;
                                }
                                if (!strFirstWord.equalsIgnoreCase("@category") || rbInfo == null) break block65;
                                nLastTagCode = 6;
                                String strTextAfterTag = strCurLine.substring(strFirstWord.length());
                                if (strTextAfterTag != null && rbInfo.isValidCategory(strTextAfterTag = strTextAfterTag.trim())) {
                                    rbInfo.m_strErrorCategory = strTextAfterTag;
                                }
                                break block54;
                            }
                            if (!strFirstWord.equalsIgnoreCase("@type") || rbInfo == null) break block66;
                            nLastTagCode = 7;
                            String strTextAfterTag = strCurLine.substring(strFirstWord.length());
                            if (strTextAfterTag != null && rbInfo.isValidType(strTextAfterTag = strTextAfterTag.trim())) {
                                rbInfo.m_strErrorType = strTextAfterTag;
                            }
                            break block54;
                        }
                        if (!strFirstWord.equalsIgnoreCase("@level") || rbInfo == null) break block67;
                        nLastTagCode = 8;
                        String strTextAfterTag = strCurLine.substring(strFirstWord.length());
                        if (strTextAfterTag != null) {
                            strTextAfterTag = strTextAfterTag.trim();
                            try {
                                int nLevel = Integer.parseInt(strTextAfterTag);
                                if (nLevel < 1 || nLevel > 32) {
                                    throw new Exception();
                                }
                                rbInfo.m_strErrorLevel = nLevel;
                                break block54;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        this.m_rb2XmlUtil.logMessage("Warning. The Level is expected to be a number ranging from 1 to 32.");
                        break block54;
                    }
                    if (strFirstWord.equalsIgnoreCase("@SeverityCode") && rbInfo != null) {
                        nLastTagCode = 5;
                        String strTemp = strCurLine.substring(strFirstWord.length());
                        strTemp = strTemp.trim();
                        int nSeverityCode = -1;
                        try {
                            nSeverityCode = Integer.parseInt(strTemp);
                            if (nSeverityCode < 1 || nSeverityCode > 32) {
                                throw new Exception();
                            }
                            rbInfo.m_nSeverityCode = nSeverityCode;
                            rbInfo.m_strErrorLevel = nSeverityCode;
                        }
                        catch (Throwable t) {
                            rbInfo.m_nSeverityCode = -1;
                            this.m_rb2XmlUtil.logMessage("Error encountered while parsing documentation comments. File = " + this.m_strFilePath + ". ");
                            this.m_rb2XmlUtil.logMessage("@Severity Code = " + strTemp);
                            this.m_rb2XmlUtil.logMessage("Warning. The Severity Code is expected to be a number ranging from 1 to 32.");
                        }
                        break block54;
                    } else {
                        nLastTagCode = 4;
                        if (rbInfo != null) {
                            rbInfo.m_oUnknownTags.addElement(new String(strCurLine));
                        }
                    }
                    break block54;
                }
                if (nLastTagCode == 0 && rbInfo != null) {
                    rbInfo.m_strError = rbInfo.m_strError.concat("<>");
                    rbInfo.m_strError = rbInfo.m_strError.concat(strCurLine);
                } else if (1 == nLastTagCode) {
                    rbInfo.m_strCause = rbInfo.m_strCause.concat("<>");
                    rbInfo.m_strCause = rbInfo.m_strCause.concat(strCurLine);
                } else if (2 == nLastTagCode) {
                    rbInfo.m_strAction = rbInfo.m_strAction.concat("<>");
                    rbInfo.m_strAction = rbInfo.m_strAction.concat(strCurLine);
                } else if (3 == nLastTagCode) {
                    rbInfo.m_oStatusInfo.m_strComment = rbInfo.m_oStatusInfo.m_strComment.concat("<>");
                    rbInfo.m_oStatusInfo.m_strComment = rbInfo.m_oStatusInfo.m_strComment.concat(strCurLine);
                } else if (5 != nLastTagCode && 4 == nLastTagCode) {
                    String strTemp = (String)rbInfo.m_oUnknownTags.elementAt(rbInfo.m_oUnknownTags.size() - 1);
                    strTemp = strTemp.concat("<>");
                    strTemp = strTemp.concat(strCurLine);
                    rbInfo.m_oUnknownTags.setElementAt(strTemp, rbInfo.m_oUnknownTags.size() - 1);
                }
            }
            ++i;
        }
        return true;
    }

    private String _getFirstWord(String strCurLine) {
        int nWhitespaceIndex = strCurLine.indexOf(" ");
        if (nWhitespaceIndex < 0) {
            return strCurLine;
        }
        return strCurLine.substring(0, nWhitespaceIndex);
    }

    protected boolean isValidChar(String strCheck) {
        return !strCheck.equalsIgnoreCase("*") && !strCheck.equalsIgnoreCase("/") && !strCheck.equalsIgnoreCase(" ");
    }

    protected String processLine(String strCurLine) {
        StringBuffer strNewLine = new StringBuffer("");
        for (int i = 0; i < strCurLine.length(); ++i) {
            char chTemp = strCurLine.charAt(i);
            String strChar = new String();
            strChar = String.valueOf(chTemp);
            if (!this.isValidChar(strChar)) continue;
            strNewLine = strNewLine.append(strCurLine.substring(i));
            break;
        }
        return strNewLine.toString().trim();
    }

    public synchronized String paddingString(String s, int n, char c, boolean paddingLeft) {
        StringBuffer str = new StringBuffer(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            int i = 0;
            while (i <= n) {
                if (paddingLeft) {
                    if (i < n - strLength) {
                        str.insert(0, c);
                    }
                } else if (i > strLength) {
                    str.append(c);
                }
                ++i;
            }
        }
        return str.toString();
    }
}

