/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.File;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLUtil;

class ResourceBundleToXMLInfo {
    public static final long INVALID_ERROR_NUMBER = -1L;
    public static final int INVALID_SEVERITY_CODE = -1;
    public static final int SEVERITY_CODE_MIN = 1;
    public static final int SEVERITY_CODE_MAX = 32;
    public long m_lErrNum;
    public String m_strErrNum;
    public String m_strProdCode;
    public int m_nSeverityCode;
    public String m_strError;
    public String m_strErrorKey;
    public String m_strErrorText;
    public String m_strErrorCategory;
    public String m_strErrorType;
    public Integer m_strErrorLevel;
    public String m_strCause;
    public String m_strAction;
    public ResourceBundleToXMLStatusInfo m_oStatusInfo;
    public Vector m_oUnknownTags;
    public String m_strFilePath;
    public String m_strFileName;
    public String[] m_categories;
    public String[] m_errType;

    ResourceBundleToXMLInfo(String strFilePath) {
        this.$init$();
        this.m_lErrNum = -1;
        this.m_strErrNum = null;
        this.m_nSeverityCode = -1;
        this.m_strError = null;
        this.m_strErrorKey = null;
        this.m_strErrorText = null;
        this.m_strCause = null;
        this.m_strAction = null;
        this.m_oStatusInfo = null;
        this.m_oUnknownTags = null;
        this.m_strFilePath = null;
        this.m_strFileName = null;
        this.m_oStatusInfo = new ResourceBundleToXMLStatusInfo();
        this.m_oUnknownTags = new Vector();
        this.m_strFilePath = new String(strFilePath);
    }

    public boolean isValidCategory(String catName) {
        boolean bRetVal = false;
        if (catName != null) {
            int i = 0;
            while (i < this.m_categories.length) {
                if (this.m_categories[i].equals(catName)) {
                    bRetVal = true;
                    break;
                }
                ++i;
            }
        }
        return bRetVal;
    }

    public boolean isValidType(String typeName) {
        boolean bRetVal = false;
        if (typeName != null) {
            int i = 0;
            while (i < this.m_errType.length) {
                if (this.m_errType[i].equals(typeName)) {
                    bRetVal = true;
                    break;
                }
                ++i;
            }
        }
        return bRetVal;
    }

    public String getFileName() {
        if (this.m_strFileName == null) {
            try {
                File fTemp = new File(this.m_strFilePath);
                this.m_strFileName = fTemp.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_strFileName;
    }

    public boolean isValidInfo() {
        return this.m_strError != null && this.m_strError.length() > 0 || this.m_strCause != null && this.m_strCause.length() > 0 || this.m_strAction != null && this.m_strAction.length() > 0;
    }

    private void $init$() {
        this.m_strErrorType = new String("ERROR");
        this.m_strErrorLevel = 1;
        this.m_categories = new String[]{"Backup and Recovery", "Browser", "Cloning", "Compliance", "Configuration", "Data", "Deployment", "Failover", "Files", "Installation", "Logging", "Memory", "Network", "Operating System", "Other", "Performance", "Ports", "Process", "Programmatic", "Requests/Responses", "Security", "Session", "Threads", "Topology", "Upgrade"};
        this.m_errType = new String[]{"ERROR", "INTERNAL_ERROR", "INCIDENT_ERROR", "NOTIFICATION", "TRACE", "WARNING", "SET_AT_RUNTIME"};
    }

    class ResourceBundleToXMLStatusInfo {
        public String m_strValue;
        public String m_strComment;

        public boolean isValidInfo() {
            return this.m_strValue.length() > 0 && ResourceBundleToXMLUtil.isValidStatusType(this.m_strValue, false);
        }

        ResourceBundleToXMLStatusInfo() {
        }
    }
}

