/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLFile;
import oracle.dss.util.converter.ResourceBundleToXMLInfo;
import oracle.dss.util.converter.ResourceBundleToXMLProductCodeInfo;

public class ResourceBundleToXMLUtil {
    public String BASEDIR;
    public static final String ERRORTAG_ERROR = "@Error";
    public static final String ERRORTAG_CAUSE = "@Cause";
    public static final String ERRORTAG_ACTION = "@Action";
    public static final String ERRORTAG_STATUS = "@Status";
    public static final String ERRORTAG_SEVERITY_CODE = "@SeverityCode";
    public static final int ERRORCODE_ERROR = 0;
    public static final int ERRORCODE_CAUSE = 1;
    public static final int ERRORCODE_ACTION = 2;
    public static final int ERRORCODE_STATUS = 3;
    public static final int ERRORCODE_UNKNOWN = 4;
    public static final int ERRORCODE_SEVERITY_CODE = 5;
    public static final String STATUSTYPE_STATUSNEW = "new";
    public static final String STATUSTYPE_STATUSDOCUMENTED = "documented";
    public static final String STATUSTYPE_STATUSREVIEWED = "reviewed";
    public static final String STATUSTYPE_STATUSNEEDSCHANGE = "needschange";
    public static final String STATUSTYPE_INVALID = "invalid";
    protected static final String INPUTERRFILEEXT = "txt";
    public static final String CMD_PARAM_LOG_FILE = "-logFile";
    public static final String CMD_PARAM_INPUT_RESOURCE_FILES_LIST = "@";
    public static final String CMD_PARAM_OUTPUT_FILE = "-htmlFile";
    public static final String CMD_PARAM_COMMON_DELIMITER = ";";
    public static final String CMD_PARAM_PRODUCT_CODES = "-productCodes";
    public static final String ERROR_COMM_FILE_PARENT_FOLDER_PATTERN = "resource";
    public static final String ERROR_COMM_FILE_BUNDLE_PATTERN = "Bundle";
    public static final String DEFAULT_ERROR_MSG_UTILITY_LOG = "defaultRB2XML.log";
    public static final String INDENT = "\t";
    protected Vector m_vInputFilesList;
    protected String m_strOutputFile;
    protected HashMap m_hCompNames = new HashMap();
    protected String m_compName;
    protected String m_compCode;
    protected boolean m_bInferProdCodesFromErrorComments = false;
    protected String m_strLogFilePath;
    protected PrintWriter m_logFile = null;

    public static Vector _arrayToVector(String[] args) {
        Vector<String> vArgs = new Vector<String>();
        int nIndex = 0;
        while (nIndex < args.length) {
            vArgs.addElement(args[nIndex]);
            ++nIndex;
        }
        return vArgs;
    }

    public static void main(String[] arRealArgs) {
        Vector vRealArgs = ResourceBundleToXMLUtil._arrayToVector(arRealArgs);
        ResourceBundleToXMLUtil _rb2xml = new ResourceBundleToXMLUtil();
        _rb2xml.processConversion(vRealArgs);
    }

    /*
     * Exception decompiling
     */
    protected boolean processConversion(Vector vArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean processArgs(Vector vArgs) {
        if (vArgs == null || vArgs.size() == 0) {
            return false;
        }
        this.BASEDIR = this.getBaseDirectoryFromArgs(vArgs);
        if (this.BASEDIR == null || this.BASEDIR.length() == 0) {
            return false;
        }
        if (!this._processLogFileArgs(vArgs)) {
            return false;
        }
        if (!this._processInputFilesArgs(vArgs)) {
            return false;
        }
        if (!this._processOutputArgs(vArgs)) {
            return false;
        }
        if (!this._processProductCodeArgs(vArgs)) {
            return false;
        }
        this.logMessage("BEGIN logging processed arguments.");
        this.logMessage("Log File = " + this.m_strLogFilePath + ".");
        this.logMessage("Begin Input File List.");
        if (this.m_vInputFilesList == null || this.m_vInputFilesList.size() == 0) {
            this.logMessage("Input File List is empty or could not be built.");
            this.logMessage("End Input File List.");
            return false;
        }
        int i = 0;
        while (i < this.m_vInputFilesList.size()) {
            this.logMessage(" Input File " + i + " = " + this.m_vInputFilesList.elementAt(i) + ".");
            ++i;
        }
        this.logMessage("End Input File List.");
        this.logMessage("Output File = " + this.m_strOutputFile + ".");
        this.logMessage("Begin Product Code List.");
        for (String curProdCode : this.m_hCompNames.keySet()) {
            ResourceBundleToXMLProductCodeInfo rbpci = (ResourceBundleToXMLProductCodeInfo)this.m_hCompNames.get(curProdCode);
            this.logMessage(" Product Code = " + curProdCode + ", Message Id Lower Bound = " + rbpci.lowerBoundAsString() + ", Message Id Upper Bound = " + rbpci.upperBoundAsString() + ".");
        }
        this.logMessage("END Product Code List.");
        this.logMessage("END logging processed arguments.");
        return true;
    }

    private String getBaseDirectoryFromArgs(Vector vArgs) {
        String strRetVal = null;
        int nLogFileArgIndex = vArgs.indexOf("-baseDir");
        if (nLogFileArgIndex != -1) {
            strRetVal = (String)vArgs.elementAt(nLogFileArgIndex + 1);
        }
        if (!this.isValidDirectory(strRetVal)) {
            this.logMessage("Error. The value of baseDir argument is an invalid directory.Verify the value of the -baseDir program argument.");
        } else {
            int i = strRetVal.lastIndexOf("\\");
            if (i == strRetVal.length() - 1) {
                strRetVal = strRetVal.substring(0, strRetVal.length() - 1);
            }
            this.logMessage("ResourceBundleToXMLUtil Log. BASEDIR = " + strRetVal);
        }
        return strRetVal;
    }

    private boolean _processLogFileArgs(Vector vArgs) {
        String strLogFilePath = null;
        int nLogFileArgIndex = vArgs.indexOf(CMD_PARAM_LOG_FILE);
        if (nLogFileArgIndex != -1) {
            strLogFilePath = (String)vArgs.elementAt(nLogFileArgIndex + 1);
        }
        if (strLogFilePath == null || strLogFilePath.length() == 0) {
            strLogFilePath = DEFAULT_ERROR_MSG_UTILITY_LOG;
        }
        try {
            if (!this._canWriteToFile(strLogFilePath)) {
                this.logMessage("Error. Unable to write to the specified log file. Verify the value of the -logFile program argument. Sending output to System.out.");
            } else {
                this.m_logFile = this.initFile(strLogFilePath);
            }
            this.logMessage("ResourceBundleToXMLUtil Log. Run Date = " + new Date().toString());
        }
        catch (Throwable t) {
            boolean flag;
            this.m_logFile = null;
            this.logMessage("Error initializing the log file. " + t.getMessage());
            boolean bl = flag = false;
            return bl;
        }
        this.m_strLogFilePath = strLogFilePath;
        return true;
    }

    private boolean _processInputFilesArgs(Vector vArgs) {
        return !this._buildInputFilesList(vArgs) ? true : true;
    }

    public void logMessage(String strMessage) {
        if (strMessage == null || strMessage.length() == 0) {
            System.out.println("");
            return;
        }
        System.out.println(strMessage);
        if (this.m_logFile != null) {
            this.m_logFile.println(strMessage);
        }
    }

    public HashMap getComponentNames() {
        return this.m_hCompNames;
    }

    public boolean getOutputMode() {
        return this.getOutputFile() != null;
    }

    public String getOutputFile() {
        return this.m_strOutputFile;
    }

    public boolean shouldInferProdCodesFromErrorComments() {
        return this.m_bInferProdCodesFromErrorComments;
    }

    public static boolean isValidStatusType(String strArg, boolean bStrict) {
        boolean bRetVal = false;
        if (STATUSTYPE_STATUSNEW.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSDOCUMENTED.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSREVIEWED.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSNEEDSCHANGE.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (!bStrict && STATUSTYPE_INVALID.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        bRetVal = false;
        return bRetVal;
    }

    protected boolean isValidDirectory(String strDirPath) {
        if (strDirPath == null || strDirPath.length() == 0) {
            return false;
        }
        File dir = null;
        try {
            dir = new File(strDirPath);
            if (dir.exists() && dir.isDirectory()) {
                boolean flag;
                boolean bl = flag = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dir = null;
        return false;
    }

    protected boolean isValidFile(String strFilePath, String strExt) {
        if (strFilePath == null || strFilePath.length() == 0) {
            return false;
        }
        if (strExt != null && strFilePath.endsWith(strExt)) {
            return false;
        }
        File file = null;
        try {
            file = new File(strFilePath);
            if (file.exists() && file.isFile()) {
                boolean flag;
                boolean bl = flag = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        file = null;
        return false;
    }

    private boolean _canWriteToFile(String strFilePath) {
        PrintWriter pw = this.initFile(strFilePath);
        if (pw == null) {
            return false;
        }
        try {
            pw.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    protected boolean processResourceBundleFiles(Vector m_vInputFilesList) {
        try {
            int i = 0;
            while (i < m_vInputFilesList.size()) {
                String strCurInputFile = (String)m_vInputFilesList.elementAt(i);
                ResourceBundleToXMLFile edf = new ResourceBundleToXMLFile(strCurInputFile, this);
                edf.processErrorFile();
                ++i;
            }
        }
        catch (Throwable t) {
            boolean flag;
            this.logMessage("Error processing file. " + t.toString());
            boolean bl = flag = false;
            return bl;
        }
        return true;
    }

    private boolean _createOutput() {
        return !this.getOutputMode() || this.getOutputFile() == null || this.getOutputFile().length() <= 0 || this._createXMLOutput(this.getOutputFile());
    }

    protected PrintWriter initFile(String strFile) {
        try {
            PrintWriter printwriter;
            PrintWriter printWriter = printwriter = new PrintWriter(new FileWriter(strFile));
            return printWriter;
        }
        catch (Throwable t) {
            this.logMessage("Error initing file for write operation." + t);
            return null;
        }
    }

    private String _swapExpression(String strText, String strSrchExpr, String strSwapExpr) {
        int nLenSrchExpr = -1;
        int nPos = -1;
        String strNewText = null;
        nLenSrchExpr = strSrchExpr.length();
        nPos = strText.indexOf(strSrchExpr);
        strNewText = new String();
        if (nPos == -1) {
            return strText;
        }
        while (true) {
            if (nPos < 0) break;
            strNewText = strNewText.concat(strText.substring(0, nPos));
            strNewText = strNewText + strSwapExpr;
            strText = strText.substring(nPos + nLenSrchExpr, strText.length());
            nPos = strText.indexOf(strSrchExpr);
        }
        strNewText = strNewText.concat(strText);
        return strNewText;
    }

    private boolean _createXMLOutputForProductCode(PrintWriter xmlFile, String strCurProdCode) {
        ResourceBundleToXMLProductCodeInfo edpci = (ResourceBundleToXMLProductCodeInfo)this.m_hCompNames.get(strCurProdCode);
        Vector vValidErrorComments = edpci.getValidErrorCommentsSortedByErrorNumber();
        int i = 0;
        while (i < vValidErrorComments.size()) {
            ResourceBundleToXMLInfo curEdi = (ResourceBundleToXMLInfo)vValidErrorComments.elementAt(i);
            xmlFile.println("\t\t<message>");
            xmlFile.println("\t\t\t<prefix>" + curEdi.m_strProdCode + "</prefix>");
            xmlFile.println("\t\t\t<number>" + curEdi.m_strErrNum + "</number>");
            xmlFile.println("\t\t\t<text>" + curEdi.m_strErrorText + "</text>");
            xmlFile.println("\t\t\t<category>" + (curEdi.m_strErrorCategory == null ? "Programmatic" : curEdi.m_strErrorCategory) + "</category>");
            xmlFile.println("\t\t\t<type>" + curEdi.m_strErrorType + "</type>");
            xmlFile.println("\t\t\t<level>" + curEdi.m_strErrorLevel + "</level>");
            xmlFile.println("\t\t\t<name>" + curEdi.m_strErrorKey + "</name>");
            if (curEdi.m_oStatusInfo.m_strValue != null) {
                xmlFile.println("\t\t\t<documented>" + (curEdi.m_oStatusInfo.m_strValue.equalsIgnoreCase("DOCUMENTED") ? "Yes" : "No") + "</documented>");
            } else {
                xmlFile.println("\t\t\t<documented> No </documented>");
            }
            xmlFile.println("\t\t\t<causes>");
            String _cause = this._swapExpression(curEdi.m_strCause, "<>", " ");
            xmlFile.println("\t\t\t\t<cause>" + this._escapeExpression(_cause) + "</cause>");
            String _action = this._swapExpression(curEdi.m_strAction, "<>", " ");
            xmlFile.println("\t\t\t\t<action>" + this._escapeExpression(_action) + "</action>");
            xmlFile.println("\t\t\t</causes>");
            xmlFile.println("\t\t\t</message>");
            ++i;
        }
        return true;
    }

    private String _escapeExpression(String expression) {
        String _strRetVal = null;
        if (expression != null && expression.length() > 0 && expression.indexOf("<") > 0) {
            StringBuffer _sb = new StringBuffer(expression);
            int i = 0;
            while (i < _sb.length()) {
                if (_sb.charAt(i) == '<') {
                    _sb = _sb.replace(i, i + 1, "&lt;");
                } else if (_sb.charAt(i) == '>') {
                    _sb = _sb.replace(i, i + 1, "&gt;");
                }
                ++i;
            }
            _strRetVal = _sb.toString();
        } else {
            _strRetVal = expression;
        }
        return _strRetVal;
    }

    /*
     * Exception decompiling
     */
    private boolean _createXMLOutput(String strOutputFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean _processProductCodeArgs(Vector vArgs) {
        String strComponentName = null;
        int nCompNamesArgIndex = vArgs.indexOf("-component");
        strComponentName = nCompNamesArgIndex != -1 ? (String)vArgs.elementAt(nCompNamesArgIndex + 1) : "DVT";
        this.m_compName = strComponentName;
        String strCompCode = null;
        int nCompCodeArgIndex = vArgs.indexOf("-compCode");
        strCompCode = nCompCodeArgIndex != -1 ? (String)vArgs.elementAt(nCompCodeArgIndex + 1) : "12330";
        this.m_compCode = strCompCode;
        this.m_hCompNames = new HashMap();
        this.m_bInferProdCodesFromErrorComments = true;
        return true;
    }

    private boolean _canHaveErrorComments(File targetFile, File parentDir) {
        String strFileAbsPath = targetFile.getAbsolutePath();
        if (strFileAbsPath != null && strFileAbsPath.endsWith(".rts")) {
            return true;
        }
        String strFileName = targetFile.getName();
        int nExtIndex = strFileName.lastIndexOf(".");
        if (nExtIndex > 0 && strFileName.substring(nExtIndex + 1).equalsIgnoreCase("JAVA")) {
            strFileName = strFileName.substring(0, nExtIndex);
        }
        return strFileName != null && strFileName.endsWith(ERROR_COMM_FILE_BUNDLE_PATTERN);
    }

    private void _reallyBuildInputFilesForSingleInputDir(HashMap hInputFiles, File parentDir) {
        File[] arChildren = parentDir.listFiles();
        if (arChildren == null) {
            return;
        }
        int i = 0;
        while (i < arChildren.length) {
            File curFile = arChildren[i];
            if (curFile.isDirectory() && !curFile.getAbsolutePath().endsWith(".ade_path")) {
                this._reallyBuildInputFilesForSingleInputDir(hInputFiles, curFile);
            } else if (curFile.isFile() && this._canHaveErrorComments(curFile, parentDir)) {
                String strFilePath = curFile.getAbsolutePath();
                hInputFiles.put(strFilePath, strFilePath);
            }
            ++i;
        }
    }

    private HashMap _buildInputFilesForSingleInputDir(String strInputDir) {
        HashMap hInputFiles = new HashMap();
        try {
            File dir = new File(strInputDir);
            this._reallyBuildInputFilesForSingleInputDir(hInputFiles, dir);
        }
        catch (Throwable t) {
            this.logMessage("Error. Error building list of input files for " + strInputDir + "directory.");
            hInputFiles.clear();
        }
        return hInputFiles;
    }

    private Vector _buildInputFilesListFromInputDirs(Vector vValidDirs) {
        HashMap hInputFiles = new HashMap();
        int i = 0;
        while (i < vValidDirs.size()) {
            HashMap hInputFilesForSingleDir = this._buildInputFilesForSingleInputDir((String)vValidDirs.elementAt(i));
            hInputFiles.putAll(hInputFilesForSingleDir);
            ++i;
        }
        return new Vector(hInputFiles.keySet());
    }

    private boolean _buildInputFilesList(Vector vArgs) {
        String strInputParamFile = null;
        int nInputDirsArgIndex = vArgs.indexOf("-inputParamFile");
        if (nInputDirsArgIndex == -1) {
            return false;
        }
        strInputParamFile = (String)vArgs.elementAt(nInputDirsArgIndex + 1);
        BufferedReader inReader = null;
        try {
            inReader = new BufferedReader(new FileReader(strInputParamFile));
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found" + strInputParamFile);
            boolean bl = false;
            return bl;
        }
        Vector<String> vValidInputDirs = new Vector<String>();
        String thisLine = null;
        try {
            thisLine = inReader.readLine();
            while (thisLine != null) {
                String strCurDirPath = thisLine;
                if (strCurDirPath.startsWith("#")) {
                    thisLine = inReader.readLine();
                    continue;
                }
                strCurDirPath = this.BASEDIR + strCurDirPath;
                vValidInputDirs.add(strCurDirPath);
                if (!this.isValidDirectory(strCurDirPath)) {
                    this.logMessage("Error. Cannot resolve path to input directory. Check the " + strCurDirPath + " path of the " + "-inputDirs" + " program argument.");
                    boolean bl = false;
                    return bl;
                }
                thisLine = inReader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading from bundle!");
            System.exit(0);
        }
        if (vValidInputDirs.size() == 0) {
            this.logMessage("Error. No valid input directories specified. Check the -inputParamFile program argument.");
            return false;
        }
        Vector vInputFilesList = this._buildInputFilesListFromInputDirs(vValidInputDirs);
        if (vInputFilesList.size() > 0) {
            this.m_vInputFilesList = vInputFilesList;
        }
        return true;
    }

    private boolean _processOutputArgs(Vector vArgs) {
        String strOutputFilePath = null;
        int nOutputFileArgIndex = vArgs.indexOf("-xmlFile");
        if (nOutputFileArgIndex != -1) {
            strOutputFilePath = (String)vArgs.elementAt(nOutputFileArgIndex + 1);
        }
        if (!this._canWriteToFile(strOutputFilePath)) {
            this.logMessage("Error. Unable to write to the specified output file. Verify the value of the -xmlFile program argument.");
            return false;
        }
        this.m_strOutputFile = strOutputFilePath;
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortByProductCodeComparator
    implements Comparator {
        public int compare(Object first, Object second) {
            String strFirstProdCode = first.toString();
            String strSecondProdCode = second.toString();
            if (strFirstProdCode == null || strSecondProdCode == null) {
                return 0;
            }
            return strFirstProdCode.compareTo(strSecondProdCode);
        }

        SortByProductCodeComparator() {
        }
    }
}

