/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccess2;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.dimensionList.DefaultListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;

public class DataAccessDimensionModel
implements DimListDataModel,
Serializable {
    private transient DataAccess m_dataAccess;
    private transient MemberListAccess m_memberAccess;
    private boolean m_isDragable;
    private boolean m_isDropTarget;
    private transient Vector m_listeners;
    private transient Object m_selItem;
    private String m_labelType;
    private transient boolean m_initOK;
    private String m_dimensionName;
    private boolean m_verbose;
    private transient int m_dimEdge;
    private transient int m_dimDepth;
    private boolean m_first;
    private boolean m_isHierarchical;
    private Vector slices;
    private boolean m_isTable;
    private Vector m_values;
    private Vector m_names;
    private boolean _memberListExist;
    private List m_list;

    public DataAccessDimensionModel() {
        this.$init$();
    }

    public DataAccessDimensionModel(DataAccess dataAccess, String dimension) {
        this(dataAccess, null, dimension, false);
    }

    public DataAccessDimensionModel(DataAccess dataAccess, MemberListAccess memberAccess, String dimension, boolean isTable) {
        this.$init$();
        this.setDimensionName(dimension);
        this.setDataAccess(dataAccess);
        this.m_memberAccess = memberAccess;
        this.m_isTable = isTable;
    }

    public void addElement(Object o) {
    }

    public boolean collapseAll() {
        return true;
    }

    public boolean expandAll() {
        return true;
    }

    public boolean drill(int index, int drillType) {
        return true;
    }

    public boolean isHierarchical() {
        return this.m_isHierarchical;
    }

    public void insertElementAt(Object o, int index) {
    }

    public void setElementAt(Object o, int index) {
    }

    public void refresh() {
        long nowCount = this.size();
        this.notifyListDataListeners(new ListDataEvent(this, 0, 0, (int)nowCount));
    }

    public void removeAllElements() {
    }

    public void removeElementAt(int index) {
    }

    public void moveElement(int indexFrom, int indexTo) {
    }

    public int find(String search, int flags, int startPos) {
        boolean bInStatus = true;
        int result = -1;
        if (startPos > 0) {
            // empty if block
        }
        int[] hpos = new int[]{++startPos};
        if (this.m_initOK) {
            try {
                if (this.m_dataAccess instanceof DataAccess) {
                    result = this.m_dataAccess.findMember(0, hpos, 0, search, this.m_labelType, flags);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Object getSelectedItem() {
        return this.m_selItem;
    }

    public void setSelectedItem(Object item) {
        this.m_selItem = item;
    }

    public Object elementAt(int index) {
        return this.getElementAt(index);
    }

    public int getSize() {
        long ret = 0L;
        if (this.m_initOK) {
            try {
                if (!this.m_isTable || this.m_dimEdge == 2) {
                    if (this.m_memberAccess != null) {
                        ret = this.m_memberAccess.getAllMembers(this.m_dimEdge, this.m_dimDepth, "value").length;
                    } else {
                        if (this.m_dataAccess instanceof DataAccess2) {
                            if (!this._memberListExist) {
                                this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "hierLevel", "drillState"}, 0, -1);
                                this._memberListExist = true;
                            }
                            if (this.m_list != null) {
                                ret = this.m_list.size();
                            }
                        }
                        if (this.m_list == null) {
                            int[] hPos = new int[this.m_dimDepth];
                            int count = this.m_dataAccess.getMemberSiblingCount(this.m_dimEdge, hPos, this.m_dimDepth);
                            if ((long)count == ret) {
                                int n = (int)ret;
                                return n;
                            }
                            int startslice = 0;
                            Vector<Object> members = new Vector<Object>();
                            this.slices = new Vector();
                            while (startslice < this.m_dataAccess.getEdgeExtent(this.m_dimEdge)) {
                                Object member;
                                if (this.m_dataAccess.getMemberStartLayer(this.m_dimEdge, this.m_dimDepth, startslice) == this.m_dimDepth && members.indexOf(member = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, startslice, "value")) == -1) {
                                    members.addElement(member);
                                    this.slices.addElement(new Integer(startslice));
                                }
                                startslice += this.m_dataAccess.getMemberExtent(this.m_dimEdge, this.m_dimDepth, startslice);
                            }
                            ret = members.size();
                        }
                    }
                } else if (this.m_dimEdge == 0) {
                    this.m_values = new Vector();
                    this.m_names = new Vector();
                    Object[] values = null;
                    if (this.m_list == null) {
                        if (this.m_memberAccess != null) {
                            values = this.m_memberAccess.getAllMembers(0, this.m_dimDepth, "dataValue");
                        }
                        int i = 0;
                        while (i < this.m_dataAccess.getEdgeExtent(1)) {
                            Object val = null;
                            Object name = values != null ? values[i] : this.m_dataAccess.getValue(i, this.m_dimDepth, "dataValue");
                            val = this.m_dataAccess.getValue(i, this.m_dimDepth, "value");
                            if (val == null) {
                                val = this.m_dataAccess.getValue(i, this.m_dimDepth, "dataValue");
                            }
                            if (this.m_names.indexOf(name) == -1) {
                                this.m_names.addElement(name);
                                this.m_values.addElement(new ValueData(val, name));
                            }
                            ++i;
                        }
                        ret = this.m_values.size();
                    }
                }
            }
            catch (SliceOutOfRangeException e1) {
                e1.printStackTrace();
            }
            catch (LayerOutOfRangeException e2) {
                e2.printStackTrace();
            }
            catch (EdgeOutOfRangeException e3) {
                e3.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)ret;
    }

    public int size() {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListDataListeners(ListDataEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v = null;
            DataAccessDimensionModel dataAccessDimensionModel = this;
            synchronized (dataAccessDimensionModel) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            int i = 0;
            while (i < count) {
                ListDataListener client = (ListDataListener)v.elementAt(i);
                if (client != null) {
                    if (e.getType() == 1) {
                        client.intervalAdded(e);
                    } else if (e.getType() == 2) {
                        client.intervalRemoved(e);
                    } else {
                        client.contentsChanged(e);
                    }
                }
                ++i;
            }
        }
    }

    public void addListDataListener(ListDataListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
            long nowCount = this.size();
            ListDataEvent e = new ListDataEvent(this, 0, 0, (int)nowCount);
            l.contentsChanged(e);
        }
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.m_listeners != null && this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    public boolean isDragable(long index) {
        return this.m_isDragable;
    }

    public void setIsDragable(boolean draggable) {
        this.m_isDragable = draggable;
    }

    public boolean isDropTarget(long index, Object o) {
        return this.m_isDropTarget;
    }

    public void setIsDropTarget(boolean dropTarget) {
        this.m_isDropTarget = dropTarget;
    }

    public Object getElementAt(int index) {
        DefaultListDataItem di = null;
        Object name = null;
        Object value = null;
        String hierLevel = "";
        int indentLevel = -1;
        int drillState = 0;
        if (this.m_initOK && index != -1) {
            if (this.m_isTable && this.m_dimEdge != 2) {
                try {
                    hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "relHierInfo");
                    if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                        hierLevel = "";
                    }
                    try {
                        indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "hierLevel");
                        drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "drillState");
                    }
                    catch (Exception ex2) {
                        indentLevel = 0;
                        drillState = 0;
                    }
                    if (this.m_list == null) {
                        name = this.m_names.elementAt(index);
                        value = ((ValueData)this.m_values.elementAt((int)index)).value;
                    }
                    di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                }
                catch (Exception ePlus) {
                    ePlus.printStackTrace();
                }
            } else {
                if (this.m_dataAccess instanceof DataAccess2) {
                    try {
                        if (!this._memberListExist) {
                            this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "hierLevel", "drillState"}, 0, -1);
                            this._memberListExist = true;
                        }
                        if (this.m_list != null) {
                            Object[] item = (Object[])this.m_list.get(index);
                            value = item[0];
                            name = item[1];
                            hierLevel = (String)item[2];
                            indentLevel = item[3] != null ? (Integer)item[3] : 0;
                            drillState = item[4] != null ? (Integer)item[4] : 0;
                            di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                        }
                    }
                    catch (EdgeOutOfRangeException e1) {
                    }
                    catch (LayerOutOfRangeException e2) {
                    }
                    catch (SliceOutOfRangeException e3) {
                        // empty catch block
                    }
                }
                if (this.m_list == null) {
                    Object s = null;
                    int[] depthIndex = new int[this.m_dimDepth];
                    try {
                        if (this.slices != null) {
                            int slice = (Integer)this.slices.elementAt(index);
                            name = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, this.m_labelType);
                            value = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "value");
                            if (name == null) {
                                name = value;
                            }
                            try {
                                hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "relHierInfo");
                                if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                                    hierLevel = "";
                                }
                                try {
                                    indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "hierLevel");
                                    drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "drillState");
                                }
                                catch (Exception ex2) {
                                    indentLevel = 0;
                                    drillState = 0;
                                }
                            }
                            catch (Exception ePlus) {
                                ePlus.printStackTrace();
                            }
                        } else {
                            name = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, this.m_labelType);
                            value = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "value");
                            if (name == null) {
                                name = value;
                            }
                            try {
                                hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "relHierInfo");
                                if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                                    hierLevel = "";
                                }
                                try {
                                    indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "hierLevel");
                                    drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "drillState");
                                }
                                catch (Exception ex2) {
                                    indentLevel = 0;
                                    drillState = 0;
                                }
                            }
                            catch (Exception ePlus) {
                                ePlus.printStackTrace();
                            }
                        }
                        di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                    }
                    catch (SliceOutOfRangeException e1) {
                        e1.printStackTrace();
                    }
                    catch (LayerOutOfRangeException e2) {
                        e2.printStackTrace();
                    }
                    catch (EdgeOutOfRangeException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return di;
    }

    public void setLabelType(String value) {
        this.m_labelType = value;
    }

    public String getLabelType() {
        return this.m_labelType;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public void setDimensionName(String dimensionName) {
        this.m_dimensionName = dimensionName;
    }

    public String getDimensionName() {
        return this.m_dimensionName;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
        this.initDataAccess();
    }

    public void setHierarchical(boolean hier) {
        this.m_isHierarchical = hier;
    }

    private void initDataAccess() {
        if (this.m_dataAccess != null && this.m_dimensionName != null) {
            try {
                int e = 0;
                while (e < this.m_dataAccess.getEdgeCount()) {
                    int d = 0;
                    while (d < this.m_dataAccess.getLayerCount(e)) {
                        String layerName = (String)this.m_dataAccess.getLayerMetadata(e, d, "dimName");
                        if (layerName != null && this.m_dimensionName.equals(layerName)) {
                            this.m_dimEdge = e;
                            this.m_dimDepth = d;
                            if (!this.m_first) {
                                this.m_first = true;
                            }
                            this.m_initOK = true;
                            break;
                        }
                        ++d;
                    }
                    ++e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void $init$() {
        this.m_dataAccess = null;
        this.m_memberAccess = null;
        this.m_isDragable = true;
        this.m_isDropTarget = true;
        this.m_listeners = null;
        this.m_selItem = null;
        this.m_labelType = "longName";
        this.m_initOK = false;
        this.m_dimensionName = "";
        this.m_verbose = false;
        this.m_dimEdge = 0;
        this.m_dimDepth = -1;
        this.m_first = false;
        this.m_isHierarchical = true;
        this.m_isTable = false;
        this._memberListExist = false;
        this.m_list = null;
    }

    class ValueData {
        Object value;
        Object name;

        public ValueData(Object val, Object n) {
            this.value = val;
            this.name = n;
        }
    }
}

