/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.dimensionList.DimFindEditor;
import oracle.dss.util.dimensionList.DimFindEvent;
import oracle.dss.util.dimensionList.DimFindEventListener;
import oracle.dss.util.dimensionList.DimFindHistory;
import oracle.dss.util.help.HelpContext;

public class DimFindTool
extends JPanel
implements ActionListener,
HelpContext,
Serializable {
    private JLabel m_findLabelMembersThat;
    private JLabel m_findLabel;
    private JLabel m_statusText;
    private JComboBox m_findCombo;
    private JComboBox m_findCombo1;
    private DimFindEditor m_findEditor;
    private DimFindEditor m_findEditor1;
    private JCheckBox m_caseCheck;
    private String m_closeText;
    private String m_findNextText;
    private String m_findHelpText;
    private JButton m_findNextButton;
    private JButton m_closeButton;
    private JButton m_findHelpButton;
    private boolean m_isListDisplayed;
    private Vector m_listeners;
    private Vector m_history;
    private int m_position;
    private static String[] m_strLabelTypes;
    private static ResourceBundle m_localStrings;

    private void $init$() {
        this.m_findLabelMembersThat = null;
        this.m_findLabel = null;
        this.m_statusText = null;
        this.m_findCombo = null;
        this.m_findCombo1 = null;
        this.m_findEditor = null;
        this.m_findEditor1 = null;
        this.m_caseCheck = null;
        this.m_closeText = null;
        this.m_findNextText = null;
        this.m_findHelpText = null;
        this.m_findNextButton = null;
        this.m_closeButton = null;
        this.m_findHelpButton = null;
        this.m_isListDisplayed = false;
        this.m_listeners = null;
        this.m_history = null;
        this.m_position = 0;
    }

    public DimFindTool() {
        this.$init$();
        this.m_history = new Vector();
        this.setLayout(new BoxLayout(this, 1));
        JPanel pnlTop = new JPanel();
        JPanel pnlCen = new JPanel();
        JPanel pnlBot = new JPanel();
        GridBagLayout gblTop = new GridBagLayout();
        GridBagLayout gblCen = new GridBagLayout();
        GridBagLayout gblBot = new GridBagLayout();
        pnlTop.setLayout(gblTop);
        pnlCen.setLayout(gblCen);
        pnlBot.setLayout(gblBot);
        GridBagConstraints gbcLeft = new GridBagConstraints();
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcLeft.insets = new Insets(3, 5, 3, 3);
        gbcLeft.gridwidth = 1;
        gbcLeft.fill = 0;
        gbcLeft.anchor = 18;
        gbcLeft.weightx = 0.0;
        gbcLeft.weighty = 1.0;
        gbcRight.insets = new Insets(1, 3, 1, 3);
        gbcRight.gridwidth = 0;
        gbcRight.fill = 2;
        gbcRight.anchor = 18;
        gbcRight.weightx = 1.0;
        gbcRight.weighty = 1.0;
        this.m_findLabelMembersThat = new JLabel();
        this.m_findCombo = new JComboBox();
        this.m_findLabelMembersThat.setLabelFor(this.m_findCombo);
        this.m_findEditor = new DimFindEditor();
        this.m_findEditor.addActionListener(this);
        pnlTop.add(this.m_findLabelMembersThat);
        pnlTop.add(this.m_findCombo);
        gblTop.setConstraints(this.m_findLabelMembersThat, gbcLeft);
        gblTop.setConstraints(this.m_findCombo, gbcRight);
        this.m_findLabel = new JLabel();
        this.m_findCombo1 = new JComboBox();
        this.m_findCombo1.setMaximumRowCount(3);
        this.m_findEditor1 = new DimFindEditor();
        this.m_findEditor1.addActionListener(this);
        this.m_findCombo1.setEditor(this.m_findEditor1);
        this.m_findCombo1.setEditable(true);
        this.m_findLabel.setLabelFor(this.m_findEditor1.getEditorComponent());
        JLabel lblFill = new JLabel();
        this.m_caseCheck = new JCheckBox();
        pnlCen.add(this.m_findLabel);
        pnlCen.add(this.m_findCombo1);
        pnlCen.add(lblFill);
        pnlCen.add(this.m_caseCheck);
        gblCen.setConstraints(this.m_findLabel, gbcLeft);
        gblCen.setConstraints(this.m_findCombo1, gbcRight);
        gblCen.setConstraints(lblFill, gbcLeft);
        gblCen.setConstraints(this.m_caseCheck, gbcRight);
        this.m_statusText = new JLabel();
        this.m_statusText.setText("  ");
        JLabel lblFill2 = new JLabel();
        pnlBot.add(this.m_statusText);
        pnlBot.add(lblFill2);
        gblBot.setConstraints(this.m_statusText, gbcLeft);
        gblBot.setConstraints(lblFill2, gbcRight);
        this.add(pnlTop);
        this.add(Box.createVerticalStrut(15));
        this.add(pnlCen);
        this.add(Box.createVerticalStrut(5));
        this.add(pnlBot);
    }

    public synchronized void setPosition(int position) {
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public synchronized void setStatusText(String text) {
        this.m_statusText.setText(text != null ? text : "");
    }

    public String getStatusText() {
        return this.m_statusText.getText();
    }

    public synchronized void setHistory(DimFindHistory fh) {
        this.m_history.removeAllElements();
        if (fh != null) {
            int i = 0;
            while (i < fh.size()) {
                this.m_history.addElement(fh.elementAt(i));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimFindHistory getHistory() {
        DimFindHistory fh = new DimFindHistory();
        if (fh != null) {
            Vector v;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                v = (Vector)this.m_history.clone();
            }
            int count = v.size();
            int i = 0;
            while (i < count) {
                fh.addElement(v.elementAt(i));
                ++i;
            }
        }
        return fh;
    }

    public synchronized void addDimFindEventListener(Object l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
        }
    }

    public synchronized void removeDimFindEventListener(Object l) {
        if (this.m_listeners != null && !this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    public void processFindNextButton() {
        String value = null;
        boolean bdecendChecked = false;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
        if (value.length() > 0) {
            this.updateHistory(value);
            DimFindEvent fe = new DimFindEvent(this, 2, value, this.m_position, bcaseChecked, bdecendChecked, iIndex);
            this.notifyFindListeners(fe);
        }
    }

    public void processCloseButton() {
        String value = null;
        boolean bdecendChecked = false;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
        DimFindEvent fe = new DimFindEvent(this, 1, "", this.m_position, bcaseChecked, bdecendChecked, iIndex);
        this.notifyFindListeners(fe);
    }

    public void actionPerformed(ActionEvent e) {
        String value = null;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
    }

    public void setLocale(Locale locale) {
        m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle", locale == null ? Locale.getDefault() : locale);
    }

    public void addNotify() {
        super.addNotify();
        this.updateResources();
    }

    private void updateResources() {
        if (this.m_findLabelMembersThat != null) {
            String strFindMembersThat = DimFindTool.getIntlString("lblFindMembersThat");
            this.m_findLabelMembersThat.setText(StringUtils.stripMnemonic((String)strFindMembersThat));
            this.m_findLabelMembersThat.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)strFindMembersThat));
        }
        if (this.m_findLabel != null) {
            String strFind = DimFindTool.getIntlString("lblFind");
            this.m_findLabel.setText(StringUtils.stripMnemonic((String)strFind));
            this.m_findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)strFind));
        }
        if (this.m_caseCheck != null) {
            String strMatchCase = DimFindTool.getIntlString("txtMatchCase");
            this.m_caseCheck.setText(StringUtils.stripMnemonic((String)strMatchCase));
            this.m_caseCheck.setMnemonic(StringUtils.getMnemonicKeyCode((String)strMatchCase));
        }
        if (this.m_findCombo != null) {
            String txt1 = new String(DimFindTool.getIntlString("findmemContain"));
            String txt2 = new String(DimFindTool.getIntlString("findmemExactlyMatch"));
            String txt3 = new String(DimFindTool.getIntlString("findmemStartWith"));
            String txt4 = new String(DimFindTool.getIntlString("findmemEndWith"));
            m_strLabelTypes = new String[]{txt1, txt2, txt3, txt4};
            this.m_findCombo.setModel(new DefaultComboBoxModel<String>(m_strLabelTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFindListeners(DimFindEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            int i = 0;
            while (i < count) {
                DimFindEventListener client = (DimFindEventListener)v.elementAt(i);
                client.processDimFindEvent(e);
                ++i;
            }
        }
    }

    private synchronized void updateHistory(String str) {
        if (str != null && str.length() > 0) {
            boolean inList = this.m_history.contains(str);
            if (inList) {
                this.m_findCombo1.removeItem(str);
                this.m_history.removeElement(str);
            }
            this.m_findCombo1.insertItemAt(str, 0);
            this.m_findCombo1.setSelectedIndex(0);
            this.m_history.insertElementAt(str, 0);
        }
    }

    private static String getIntlString(String key) {
        String strTemp;
        if (m_localStrings == null) {
            return key;
        }
        try {
            strTemp = m_localStrings.getString(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource: " + key);
            e.printStackTrace();
            String string = key;
            return string;
        }
        return strTemp;
    }

    static {
        m_localStrings = null;
    }
}

