/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dss.util.FocusUtility;
import oracle.dss.util.dimensionList.DefaultListCellEditor;
import oracle.dss.util.dimensionList.DefaultListDataModel;
import oracle.dss.util.dimensionList.DefaultListSelection;
import oracle.dss.util.dimensionList.DimListCellEditor;
import oracle.dss.util.dimensionList.DimListCellEditorEvent;
import oracle.dss.util.dimensionList.DimListCellEditorListener;
import oracle.dss.util.dimensionList.DimListCellRenderer;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionListEvent;
import oracle.dss.util.dimensionList.DimensionListListener;
import oracle.dss.util.dimensionList.DimensionUtil;
import oracle.dss.util.dimensionList.DragList;

public class DimensionList
extends DragList
implements DimListCellEditorListener,
ListDataListener,
ListSelectionListener,
Serializable {
    public static final int BELOW_PARENT = 0;
    public static final int ABOVE_PARENT = 1;
    public static final int AUTOKEY_NONE = 0;
    public static final int AUTOKEY_FIRSTCHAR = 1;
    public static final int AUTOKEY_ANYCHAR = 2;
    public static final int DRILLSTATE_NOT_DRILLABLE = 0;
    public static final int DRILLSTATE_DRILLABLE = 1;
    public static final int DRILLSTATE_IS_DRILLED = 2;
    private static final int DRILL_GAP = 5;
    boolean m_matchCase;
    private int m_autoKeyAction;
    private DimListCellEditor mCellEditor;
    private String m_cellPrototype;
    private DefDimListCellRenderer m_cellRenderer;
    private boolean m_contextIconVisible;
    private DefaultListDataModel m_dataModel;
    private boolean m_editable;
    private boolean m_iconShow;
    private DefaultListSelection m_selectionModel;
    private boolean m_tooltipsEnabled;
    private transient boolean m_constructed;
    private transient Icon m_blankIcon;
    private transient Icon m_closedIcon;
    private transient Icon m_collapsedIcon;
    private transient long m_dragEndIndex;
    private transient long m_dragStartIndex;
    private transient DimensionUtil m_du;
    private transient int m_editIndex;
    private transient DefaultListCellEditor m_editor;
    private transient Icon m_expandedIcon;
    private transient Vector m_listeners;
    private transient Vector m_listlisteners;
    private transient Icon m_nodeIcon;
    private transient Icon m_openedIcon;
    private int m_iconWidth;
    private transient int m_tabPosition;
    private transient int m_cellHeightPadValue;
    protected int m_debugLevel;
    private boolean m_blnFromMouseEvent;

    private void $init$() {
        this.m_matchCase = false;
        this.m_autoKeyAction = 0;
        this.mCellEditor = null;
        this.m_cellPrototype = new String("RSTLNEy");
        this.m_cellRenderer = null;
        this.m_contextIconVisible = true;
        this.m_dataModel = null;
        this.m_editable = false;
        this.m_iconShow = true;
        this.m_selectionModel = null;
        this.m_tooltipsEnabled = true;
        this.m_constructed = false;
        this.m_blankIcon = null;
        this.m_closedIcon = null;
        this.m_collapsedIcon = null;
        this.m_dragEndIndex = -1;
        this.m_dragStartIndex = -1;
        this.m_du = null;
        this.m_editIndex = -1;
        this.m_editor = null;
        this.m_expandedIcon = null;
        this.m_listeners = null;
        this.m_listlisteners = null;
        this.m_nodeIcon = null;
        this.m_openedIcon = null;
        this.m_iconWidth = 0;
        this.m_tabPosition = 0;
        this.m_cellHeightPadValue = 0;
        this.m_debugLevel = 0;
        this.m_blnFromMouseEvent = false;
    }

    public DimensionList() {
        this.$init$();
        this.m_constructed = true;
        this.m_du = new DimensionUtil();
        this.init();
        this.addListSelectionListener(this);
    }

    public synchronized void addDimensionListListener(DimensionListListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_cellRenderer = null;
        this.init();
        this.enableEvents(60);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
    }

    public void clearSelection() {
        DimListDataModel dm;
        boolean rc = false;
        ListModel dmodel = this.getModel();
        if (dmodel instanceof DimListDataModel && (dm = (DimListDataModel)dmodel) != null) {
            int index = this.getSelectedIndex();
            DimensionListEvent de = new DimensionListEvent(this, 7, index);
            this.notifyDimensionListListener(de);
            if (!de.isConsumed()) {
                super.clearSelection();
                this.notifyDimensionListListener(new DimensionListEvent(this, 8, -1));
                rc = true;
            }
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.init();
    }

    public void DimListCellEditorAction(DimListCellEditorEvent e) {
        if (e.getId() != DimListCellEditorEvent.START) {
            if (e.getId() == DimListCellEditorEvent.ACCEPT) {
                int index = this.mCellEditor.getIndex();
                DimListDataModel dm = (DimListDataModel)this.getModel();
                DimListDataItem dsItem = (DimListDataItem)dm.elementAt(index);
                dsItem.setText(this.mCellEditor.getText());
                dm.setElementAt(dsItem, index);
                this.repaint();
            }
            this.mCellEditor.removeEditListener(this);
            this.remove((Component)((Object)this.mCellEditor));
            this.requestFocus();
        }
    }

    public boolean doExpandAll() {
        DimListDataModel dm = (DimListDataModel)this.getModel();
        if (dm != null) {
            int index = this.getSelectedIndex();
            DimensionListEvent de = new DimensionListEvent(this, 3, index);
            this.notifyDimensionListListener(de);
            if (!de.isConsumed()) {
                this.clearSelection();
                dm.expandAll();
                this.setSelectedIndex(index);
                this.notifyDimensionListListener(new DimensionListEvent(this, 4, 0));
                return true;
            }
        }
        return false;
    }

    public boolean doCollapseAll() {
        DimListDataModel dm = (DimListDataModel)this.getModel();
        if (dm != null) {
            int index = this.getSelectedIndex();
            DimensionListEvent de = new DimensionListEvent(this, 1, index);
            this.notifyDimensionListListener(de);
            if (!de.isConsumed()) {
                this.clearSelection();
                dm.collapseAll();
                this.setSelectedIndex(0);
                this.notifyDimensionListListener(new DimensionListEvent(this, 2, 0));
            }
            return true;
        }
        return false;
    }

    public boolean doDrill(int index) {
        DimListDataModel dataModel = (DimListDataModel)this.getModel();
        if (dataModel != null) {
            DimensionListEvent dle = new DimensionListEvent(this, 5, index);
            this.notifyDimensionListListener(dle);
            if (!dle.isConsumed()) {
                DimListDataItem dsItem = (DimListDataItem)dataModel.elementAt(index);
                if (dsItem == null) {
                    return false;
                }
                int nDrillState = dsItem.getDrillState();
                if (nDrillState != 0) {
                    int delta = (nDrillState & 2) > 0 ? -1 : 0;
                    delta = (nDrillState & 1) > 0 ? 1 : delta;
                    this.clearSelection();
                    DimensionList.setParentWindowCursor((Component)this, 3);
                    dataModel.drill(index, delta);
                    DimensionList.setParentWindowCursor((Component)this, 0);
                    this.setSelectedIndex(index);
                    AccessibleContext ac = this.getAccessibleContext();
                    if (ac != null) {
                        ac.firePropertyChange("AccessibleActiveDescendant", null, ac.getAccessibleChild(index));
                    }
                    this.notifyDimensionListListener(new DimensionListEvent(this, 6, 0));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doEdit(int index) {
        DimListDataItem dsItem;
        ListModel dataModel;
        boolean result = false;
        if (this.getEditable() && (dataModel = this.getModel()) != null && dataModel instanceof DimListDataModel && (dsItem = (DimListDataItem)((DimListDataModel)dataModel).elementAt(index)) != null) {
            Rectangle rect = this.getCellBounds(index, index);
            if (this.mCellEditor != null) {
                this.remove((Component)((Object)this.mCellEditor));
                this.mCellEditor.removeEditListener(this);
                this.mCellEditor.addEditListener(this);
                this.add((Component)((Object)this.mCellEditor));
                this.mCellEditor.startEdit(this, dsItem.getText(), index, rect);
                result = true;
            }
        }
        return result;
    }

    public int doFind(String search, int flags, int startPos, boolean showModalDialog) {
        int result = -1;
        DimListDataModel dm = (DimListDataModel)this.getModel();
        if (dm != null) {
            String str = "";
            if (search != null) {
                str = search.trim();
            }
            if (startPos < 0) {
                startPos = 0;
            }
            if ((result = dm.find(str, flags, startPos)) > -1) {
                this.ensureIndexIsVisible(result);
                this.setSelectedIndex(result);
            }
        }
        return result;
    }

    public void doGoBottom() {
        int f_index = this.getFirstVisibleIndex();
        int l_index = this.getLastVisibleIndex();
        int s_index = this.getSelectedIndex();
        int pg_size = l_index - f_index + 1;
        int count = this.getCount();
        if (count > 0) {
            --count;
        }
        if (l_index < count - pg_size) {
            this.ensureIndexIsVisible(count);
        }
        if (s_index != count) {
            this.setSelectedIndex(count);
        }
        this.ensureIndexIsVisible(count);
    }

    public void doGoTop() {
        int f_index = this.getFirstVisibleIndex();
        int l_index = this.getLastVisibleIndex();
        int s_index = this.getSelectedIndex();
        int pg_size = l_index - f_index + 1;
        if (f_index != 0 && pg_size < this.getCount()) {
            this.ensureIndexIsVisible(pg_size);
        }
        if (s_index != f_index) {
            this.setSelectedIndex(0);
        }
        this.ensureIndexIsVisible(0);
    }

    public int doKeySearch(int key) {
        int result = -1;
        if (this.m_autoKeyAction > 0) {
            byte[] b = new byte[1];
            int flags = 0;
            int n = this.m_matchCase ? flags & 0xFFFFFF7F : 128;
            b[0] = (byte)key;
            result = this.doFind(new String(b), flags |= n, this.getSelectedIndex(), false);
        }
        return result;
    }

    public void doLineDown() {
        int s_index = this.getSelectedIndex();
        int count = this.getCount();
        if (count > 0) {
            --count;
        }
        if (s_index < count) {
            this.setSelectedIndex(++s_index);
            this.ensureIndexIsVisible(s_index);
        }
    }

    public void doLineUp() {
        int s_index = this.getSelectedIndex();
        if (s_index > 0) {
            this.setSelectedIndex(--s_index);
            this.ensureIndexIsVisible(s_index);
        }
    }

    public void doPageDown() {
        int f_index = this.getFirstVisibleIndex();
        int l_index = this.getLastVisibleIndex();
        int s_index = this.getSelectedIndex();
        int pg_size = l_index - f_index + 1;
        int count = this.getCount();
        if (count > 0) {
            --count;
        }
        if (l_index > count || l_index == -1) {
            l_index = count;
        }
        if (s_index != l_index) {
            this.setSelectedIndex(l_index);
        } else if (l_index < count) {
            if ((l_index += pg_size - 1) > count) {
                l_index = count;
            }
            this.setSelectedIndex(l_index);
            f_index = l_index - (pg_size - 1);
            if (f_index < 0) {
                f_index = 0;
            }
            this.ensureIndexIsVisible(f_index);
        }
        this.ensureIndexIsVisible(l_index);
    }

    public void doPageUp() {
        int f_index = this.getFirstVisibleIndex();
        int l_index = this.getLastVisibleIndex();
        int s_index = this.getSelectedIndex();
        int pg_size = l_index - f_index + 1;
        if (s_index != f_index) {
            this.setSelectedIndex(f_index);
        } else if (f_index > 0) {
            f_index = f_index > pg_size ? (f_index -= pg_size - 1) : 0;
            this.setSelectedIndex(f_index);
            this.ensureIndexIsVisible(f_index + pg_size + 1);
        }
        this.ensureIndexIsVisible(f_index);
    }

    public int getAutoKeyAction() {
        return this.m_autoKeyAction;
    }

    public DimListCellEditor getCellEditor() {
        return this.mCellEditor;
    }

    public int getTabPosition() {
        return this.m_tabPosition;
    }

    public void setTabPosition(int position) {
        this.m_tabPosition = position;
    }

    public int getCellHeightPadValue() {
        return this.m_cellHeightPadValue;
    }

    public void setCellHeightPadValue(int value) {
        if (value >= 0) {
            this.m_cellHeightPadValue = value;
            this.repaint();
        }
    }

    public Icon getClosedIcon() {
        return this.m_closedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.m_collapsedIcon;
    }

    public boolean getContextIconVisible() {
        return this.m_contextIconVisible;
    }

    public int getCount() {
        DimListDataModel dm = (DimListDataModel)this.getModel();
        if (dm != null) {
            return dm.size();
        }
        return 0;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public int getEditIndex() {
        return this.m_editIndex;
    }

    public long getEndIndex() {
        return this.m_dragEndIndex;
    }

    public Icon getExpandedIcon() {
        return this.m_expandedIcon;
    }

    public int getFirstVisibleIndex() {
        return super.getFirstVisibleIndex();
    }

    public Icon getNodeIcon() {
        return this.m_nodeIcon;
    }

    public Icon getOpenedIcon() {
        return this.m_openedIcon;
    }

    public long getStartIndex() {
        return this.m_dragStartIndex;
    }

    public boolean getToolTipsEnabled() {
        return this.m_tooltipsEnabled;
    }

    public int getWidthHeuristic() {
        return this.getFixedCellWidth();
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public boolean isContextIconVisible() {
        return this.getContextIconVisible();
    }

    public boolean isIconVisible() {
        return this.m_iconShow;
    }

    public boolean isToolTipsEnabled() {
        return this.getToolTipsEnabled();
    }

    public synchronized void removeDimensionListListener(DimensionListListener l) {
        if (this.m_listeners != null && !this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
    }

    public synchronized void setAutoKeyAction(int action) {
        if (action < 0 || action > 2) {
            System.out.println("setAutoKeyAction(): parameter out-of-range");
        } else if (action != this.m_autoKeyAction) {
            int oldValue = this.m_autoKeyAction;
            this.m_autoKeyAction = action;
            this.firePropertyChange("AutoKeyAction", oldValue, this.m_autoKeyAction);
        }
    }

    public synchronized void setCellEditor(DimListCellEditor anEditor) {
        if (anEditor != null) {
            DimListCellEditor oldValue = this.mCellEditor;
            this.mCellEditor = anEditor;
            this.firePropertyChange("CellEditor", oldValue, this.mCellEditor);
        }
    }

    public synchronized void setClosedIcon(Icon icon) {
        Icon oldIcon = this.m_closedIcon;
        if (icon == null) {
            try {
                this.m_closedIcon = new ImageIcon(this.m_du.getImageResource("images/folder-c.gif", true));
            }
            catch (Exception e) {
                System.out.println("DimensionList.setClosedIcon() - exception obtaining closed icon");
                e.printStackTrace();
            }
        } else {
            this.m_closedIcon = icon;
        }
        if (oldIcon != this.m_closedIcon) {
            this.firePropertyChange("ClosedIcon", oldIcon, this.m_closedIcon);
        }
    }

    public synchronized void setCollapsedIcon(Icon icon) {
        Icon oldIcon = this.m_collapsedIcon;
        if (icon == null) {
            try {
                Icon tIcon = (Icon)UIManager.get("Tree.collapsedIcon");
                this.m_collapsedIcon = tIcon != null ? tIcon : new ImageIcon(this.m_du.getImageResource("images/collapse.gif", true));
            }
            catch (Exception e) {
                System.out.println("DimensionList.setCollapsedIcon() - exception obtaining collapsed icon");
                e.printStackTrace();
            }
        } else {
            this.m_collapsedIcon = icon;
        }
        if (oldIcon != this.m_collapsedIcon) {
            this.firePropertyChange("CollapsedIcon", oldIcon, this.m_collapsedIcon);
        }
    }

    public synchronized void setContextIconVisible(boolean visible) {
        if (visible != this.m_contextIconVisible) {
            boolean oldValue = this.m_contextIconVisible;
            this.m_contextIconVisible = visible;
            this.repaint();
            this.firePropertyChange("ContextIconVisible", oldValue, this.m_contextIconVisible);
        }
    }

    public synchronized void setEditable(boolean flag) {
        if (flag != this.m_editable) {
            boolean oldValue = this.m_editable;
            this.m_editable = flag;
            this.firePropertyChange("Editable", oldValue, this.m_editable);
        }
    }

    public synchronized void setEditIndex(int index) {
        if (index != this.m_editIndex) {
            int oldValue = this.m_editIndex;
            this.m_editIndex = index;
            this.firePropertyChange("EditIndex", oldValue, this.m_editIndex);
        }
    }

    public synchronized void setExpandedIcon(Icon icon) {
        Icon oldIcon = this.m_expandedIcon;
        if (icon == null) {
            try {
                Icon tIcon = (Icon)UIManager.get("Tree.expandedIcon");
                this.m_expandedIcon = tIcon != null ? tIcon : new ImageIcon(this.m_du.getImageResource("images/expand.gif", true));
            }
            catch (Exception e) {
                System.out.println("DimensionList.setExpandedIcon() - exception obtaining expanded icon");
                e.printStackTrace();
            }
        } else {
            this.m_expandedIcon = icon;
        }
        if (oldIcon != this.m_expandedIcon) {
            this.firePropertyChange("ExpandedIcon", oldIcon, this.m_expandedIcon);
        }
    }

    public void setFirstVisibleIndex(int index) {
        int count = this.getCount();
        if (count > 0 && index < count) {
            int f_index;
            int nLoops = 0;
            --count;
            this.ensureIndexIsVisible(index);
            while ((f_index = this.getFirstVisibleIndex()) != index) {
                int l_index = this.getLastVisibleIndex();
                if (l_index == -1 || l_index >= count) break;
                if (++nLoops > 200) {
                    System.out.println("warning: looping in setFirstVisibleIndex() index=" + index + ", first=" + f_index + ", last=" + l_index + ", count=" + (count + 1));
                    break;
                }
                this.ensureIndexIsVisible(l_index + 1);
            }
            this.ensureIndexIsVisible(index);
        }
    }

    public synchronized void setIconVisible(boolean visible) {
        if (visible != this.m_iconShow) {
            boolean oldValue = this.m_iconShow;
            this.m_iconShow = visible;
            this.repaint();
            this.firePropertyChange("IconVisible", oldValue, this.m_iconShow);
        }
    }

    public synchronized void setModel(DimListDataModel model) {
        super.setModel(model);
        if (this.m_dataModel != null) {
            this.m_dataModel.removeListDataListener(this);
        }
        this.init();
        if (model != null) {
            model.addListDataListener(this);
        }
        this.notifyDimensionListListener(new DimensionListEvent(this, 0, 0));
    }

    public synchronized void setNodeIcon(Icon icon) {
        Icon oldIcon = this.m_nodeIcon;
        if (icon == null) {
            try {
                this.m_nodeIcon = new ImageIcon(this.m_du.getImageResource("images/point.gif", true));
            }
            catch (Exception e) {
                System.out.println("DimensionList.setNodeIcon() - exception obtaining node icon");
                e.printStackTrace();
            }
        } else {
            this.m_nodeIcon = icon;
        }
        if (oldIcon != this.m_nodeIcon) {
            this.firePropertyChange("NodeIcon", oldIcon, this.m_nodeIcon);
        }
    }

    public synchronized void setOpenedIcon(Icon icon) {
        Icon oldIcon = this.m_openedIcon;
        if (icon == null) {
            try {
                this.m_openedIcon = new ImageIcon(this.m_du.getImageResource("images/folder-o.gif", true));
            }
            catch (Exception e) {
                System.out.println("DimensionList.setOpenedIcon() - exception obtaining opened icon");
                e.printStackTrace();
            }
        } else {
            this.m_openedIcon = icon;
        }
        if (oldIcon != this.m_openedIcon) {
            this.firePropertyChange("OpenedIcon", oldIcon, this.m_openedIcon);
        }
    }

    public synchronized void setToolTipsEnabled(boolean flag) {
        if (flag != this.m_tooltipsEnabled) {
            boolean oldValue = this.m_tooltipsEnabled;
            this.m_tooltipsEnabled = flag;
            this.firePropertyChange("ToolTipsEnabled", oldValue, this.m_tooltipsEnabled);
        }
    }

    public synchronized void setWidthHeuristic(int width) {
        int oldValue = this.getFixedCellWidth();
        if (oldValue < width) {
            this.setFixedCellWidth(width);
            this.firePropertyChange("WidthHeuristic", oldValue, width);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.init();
        if (this.m_cellRenderer != null) {
            this.m_cellRenderer.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.notifyDimensionListListener(new DimensionListEvent(this, 10, e.getLastIndex()));
        } else {
            this.notifyDimensionListListener(new DimensionListEvent(this, 9, e.getFirstIndex()));
        }
    }

    protected void init() {
        ListModel dmodel;
        if (!this.m_constructed) {
            return;
        }
        if (this.getExpandedIcon() == null) {
            this.setExpandedIcon(null);
        }
        if (this.getCollapsedIcon() == null) {
            this.setCollapsedIcon(null);
        }
        if (this.getOpenedIcon() == null) {
            this.setOpenedIcon(null);
        }
        if (this.getClosedIcon() == null) {
            this.setClosedIcon(null);
        }
        if (this.getNodeIcon() == null) {
            this.setNodeIcon(null);
        }
        try {
            this.m_blankIcon = new ImageIcon(this.m_du.getImageResource("images/blank.gif", true));
        }
        catch (Exception e) {
            System.out.println("DimensionList.init() warning: blank.gif icon not loaded");
        }
        if (this.m_cellRenderer == null) {
            this.m_cellRenderer = new DefDimListCellRenderer();
            this.setCellRenderer(this.m_cellRenderer);
        }
        if (this.m_selectionModel == null) {
            this.m_selectionModel = new DefaultListSelection();
            this.m_selectionModel.setSelectionMode(this.getSelectionMode());
            this.setSelectionModel(this.m_selectionModel);
        }
        if ((dmodel = this.getModel()) != null && dmodel instanceof DimListDataModel) {
            DimListDataModel dm = (DimListDataModel)dmodel;
            this.m_cellRenderer.setShowHierarchical(dm.isHierarchical());
        }
        Icon ic = null;
        this.m_iconWidth = 0;
        ic = this.m_expandedIcon;
        if (ic != null && ic.getIconWidth() > this.m_iconWidth) {
            this.m_iconWidth = ic.getIconWidth();
        }
        if ((ic = this.m_collapsedIcon) != null && ic.getIconWidth() > this.m_iconWidth) {
            this.m_iconWidth = ic.getIconWidth();
        }
        if (this.getContextIconVisible()) {
            ic = this.m_openedIcon;
            if (ic != null && ic.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = ic.getIconWidth();
            }
            if ((ic = this.m_closedIcon) != null && ic.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = ic.getIconWidth();
            }
            if ((ic = this.m_nodeIcon) != null && ic.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = ic.getIconWidth();
            }
        }
        this.setCellEditor(null);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (!this.m_blnFromMouseEvent && e.getID() == 1004) {
            FocusUtility.setFocusToFirstSelectedRow(this, e);
            this.ensureIndexIsVisible(this.getLeadSelectionIndex());
        }
    }

    protected boolean dragCancel(long start) {
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragCancel");
        }
        DimensionListEvent de = new DimensionListEvent((Object)this, 13, start, null);
        this.notifyDimensionListListener(de);
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
        return true;
    }

    protected boolean dragEnd(long start, long end) {
        DimListDataModel dm;
        ListModel model;
        boolean bOK = false;
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragEnd");
        }
        if ((model = this.getModel()) != null && model instanceof DimListDataModel && (dm = (DimListDataModel)model).isDropTarget(end, null) && start != end) {
            DimensionListEvent de = new DimensionListEvent(this, 12, start, end, null);
            this.notifyDimensionListListener(de);
            if (de.isConsumed()) {
                this.notifyDimensionListListener(new DimensionListEvent(this, 13, 0));
            } else {
                dm.moveElement((int)start, (int)end);
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
                bOK = true;
            }
        }
        return bOK;
    }

    protected boolean dragStart(long start) {
        DimListDataModel dm;
        boolean bOK = false;
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragStart");
        }
        if (this.isManualSortGuiEnabled() && (dm = (DimListDataModel)this.getModel()) != null && dm.isDragable(start)) {
            DimensionListEvent de = new DimensionListEvent((Object)this, 11, start, null);
            this.notifyDimensionListListener(de);
            if (de.isConsumed()) {
                this.notifyDimensionListListener(new DimensionListEvent(this, 13, 0));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
                bOK = true;
            }
        }
        return bOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDimensionListListener(DimensionListEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v;
            DimensionList dimensionList = this;
            synchronized (dimensionList) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            DimListDataModel dm = (DimListDataModel)this.getModel();
            if (e.getDataModel() == null) {
                e.setDataModel(dm);
            }
            switch (e.getId()) {
                case 0: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionChanged(e);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionCollapsing(e);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionCollapsed(e);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionExpanding(e);
                        ++i;
                    }
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionExpanded(e);
                        ++i;
                    }
                    break;
                }
                case 5: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionDrilling(e);
                        ++i;
                    }
                    break;
                }
                case 6: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionDrilled(e);
                        ++i;
                    }
                    break;
                }
                case 7: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionClearing(e);
                        ++i;
                    }
                    break;
                }
                case 8: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionCleared(e);
                        ++i;
                    }
                    break;
                }
                case 9: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionSelecting(e);
                        ++i;
                    }
                    break;
                }
                case 10: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionSelected(e);
                        ++i;
                    }
                    break;
                }
                case 11: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionDragStart(e);
                        ++i;
                    }
                    break;
                }
                case 12: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionDragEnd(e);
                        ++i;
                    }
                    break;
                }
                case 13: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionDragCancel(e);
                        ++i;
                    }
                    break;
                }
                case 14: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionPrefixIconSelecting(e);
                        ++i;
                    }
                    break;
                }
                case 15: {
                    int i = 0;
                    while (i < count && !e.isConsumed()) {
                        DimensionListListener client = (DimensionListListener)v.elementAt(i);
                        client.dimensionPrefixIconSelected(e);
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.isEnabled() && e.getID() == 503) {
            this.handleMouseMoved(e);
        }
        super.processMouseMotionEvent(e);
    }

    private boolean inBounds(int index, MouseEvent e) {
        if (index >= 0) {
            Rectangle rectangle = this.getCellBounds(this.getFirstVisibleIndex(), this.getLastVisibleIndex());
            if (rectangle != null) {
                return e.getY() <= rectangle.height;
            }
            return true;
        }
        return false;
    }

    protected void handleMouseMoved(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        ListModel model = this.getModel();
        if (model != null && model instanceof DimListDataModel) {
            DimListDataModel dataModel = (DimListDataModel)model;
            if (this.inBounds(index, e)) {
                DimListDataItem dldItem = (DimListDataItem)dataModel.elementAt(index);
                if (dldItem != null) {
                    this.setToolTipText(dldItem.getDescription());
                }
            } else {
                this.setToolTipText(null);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        this.m_blnFromMouseEvent = true;
        if (this.isEnabled()) {
            int id = e.getID();
            if (id == 501) {
                this.handleMousePressed(e);
            } else if (id == 502) {
                this.handleMouseReleased(e);
            } else if (id == 500) {
                this.handleMouseClicked(e);
            }
            super.processMouseEvent(e);
        }
        this.m_blnFromMouseEvent = false;
    }

    protected void handleMousePressed(MouseEvent me) {
        this.m_dragStartIndex = this.locationToIndex(me.getPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMouseReleased(MouseEvent me) {
        DimensionList dimensionList = this;
        synchronized (dimensionList) {
            this.m_dragEndIndex = this.locationToIndex(me.getPoint());
            if (this.isManualSortGuiEnabled() && !this.inSelection(me) && this.m_dragEndIndex != this.m_dragStartIndex) {
                Rectangle rectangle = this.getCellBounds((int)this.m_dragEndIndex, (int)this.m_dragEndIndex);
                if (rectangle != null) {
                    boolean blnLowerHalf;
                    boolean bl = blnLowerHalf = me.getY() % rectangle.height > rectangle.height / 2;
                    if (blnLowerHalf) {
                        this.m_dragEndIndex += (long)1;
                    }
                }
                if (this.m_dragEndIndex == (long)-1 && me.getY() > 0 && (double)me.getY() < this.getSize().getHeight()) {
                    this.m_dragEndIndex = this.getModel().getSize();
                }
                if (this.m_dragEndIndex != (long)-1) {
                    this.dragEnd(this.m_dragStartIndex, this.m_dragEndIndex);
                }
            }
        }
    }

    protected void handleMouseClicked(MouseEvent e) {
        DimListDataItem dsItem;
        boolean bLeftButton;
        int nCount = e.getClickCount();
        Point point = e.getPoint();
        int nIndex = this.locationToIndex(point);
        ListModel dataModel = this.getModel();
        DimListCellRenderer cellRenderer = (DimListCellRenderer)this.getCellRenderer();
        boolean bl = bLeftButton = (e.getModifiers() & 0x10) == 16;
        if (dataModel != null && dataModel instanceof DimListDataModel && cellRenderer != null && (dsItem = (DimListDataItem)((DimListDataModel)dataModel).elementAt(nIndex)) != null) {
            if (bLeftButton) {
                boolean bPrefixIconSelected;
                boolean bDrillIcon;
                if (dsItem.getDrillState() != 0 && ((bDrillIcon = cellRenderer.isDrillIconHit(dsItem, point)) || nCount == 2 && !bDrillIcon)) {
                    this.doDrill(nIndex);
                }
                if (bPrefixIconSelected = cellRenderer.isPrefixIconHit(dsItem, point)) {
                    DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 15, nIndex);
                    this.notifyDimensionListListener(dimensionListEvent);
                }
            }
            if (nCount == 2) {
                this.setSelectedIndex(nIndex);
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        int id = e.getID();
        if (id == 401) {
            this.handleKeyPressed(e);
        } else if (id == 400) {
            this.handleKeyTyped(e);
        }
    }

    protected void handleKeyTyped(KeyEvent e) {
        char key = e.getKeyChar();
        if (!e.isControlDown() && !e.isMetaDown() && (key >= '0' && key <= '9' || key >= 'a' && key <= 'z' || key == ' ' || key >= 'A' && key <= 'Z')) {
            this.doKeySearch(key);
        }
    }

    protected void handleKeyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (e.getKeyCode() == 27) {
            this.dragCancel(this.m_dragStartIndex);
        } else if (key == 32) {
            if (e.isControlDown()) {
                this.addSelectionInterval(this.getSelectedIndex(), this.getSelectedIndex());
            }
        } else if (key == 39 || key == 37) {
            if (e.isControlDown()) {
                if (key == 39) {
                    int index = this.getSelectedIndex();
                    this.doExpandAll();
                    this.setSelectedIndex(index);
                } else if (key == 37) {
                    this.doCollapseAll();
                }
            } else {
                DimListDataModel dataModel = (DimListDataModel)this.getModel();
                if (dataModel != null) {
                    int index = this.getSelectedIndex();
                    DimListDataItem dsItem = (DimListDataItem)dataModel.elementAt(index);
                    int nDrillState = dsItem.getDrillState();
                    if (dsItem != null && nDrillState != 0) {
                        boolean isDrilled;
                        boolean bl = isDrilled = (nDrillState & 2) > 0;
                        if (isDrilled && key == 37) {
                            this.doDrill(index);
                        } else if (!isDrilled && key == 39) {
                            this.doDrill(index);
                        }
                    }
                }
            }
        }
    }

    private static void setParentWindowCursor(Component component, Cursor cursor) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null) {
            window.setCursor(cursor);
        }
    }

    private static void setParentWindowCursor(Component comp, int intCursorType) {
        DimensionList.setParentWindowCursor(comp, Cursor.getPredefinedCursor(intCursorType));
    }

    static int ra$m_iconWidth(DimensionList dimensionList) {
        return dimensionList.m_iconWidth;
    }

    static Icon ra$m_closedIcon(DimensionList dimensionList) {
        return dimensionList.m_closedIcon;
    }

    static Icon ra$m_openedIcon(DimensionList dimensionList) {
        return dimensionList.m_openedIcon;
    }

    static Icon ra$m_nodeIcon(DimensionList dimensionList) {
        return dimensionList.m_nodeIcon;
    }

    static Icon ra$m_expandedIcon(DimensionList dimensionList) {
        return dimensionList.m_expandedIcon;
    }

    static Icon ra$m_collapsedIcon(DimensionList dimensionList) {
        return dimensionList.m_collapsedIcon;
    }

    static Icon ra$m_blankIcon(DimensionList dimensionList) {
        return dimensionList.m_blankIcon;
    }

    class DefDimListCellRenderer
    extends JLabel
    implements DimListCellRenderer,
    Serializable {
        private transient boolean m_added;
        private transient int m_level;
        private transient int m_state;
        private transient String m_meta;
        private transient boolean m_selected;
        private transient Color m_forenorm;
        private transient Color m_backnorm;
        private transient Color m_background;
        private transient Color m_foresel;
        private transient Color m_backsel;
        private transient Color m_lineColor;
        private int m_ascent;
        private int m_indentUnit;
        private boolean m_showHierarchical;
        private boolean m_blnContextIconVisible;
        private Border m_noFocusBorder;
        private transient String m_prefix;
        private transient int m_position;
        private transient int m_padValue;
        private transient Icon m_stepIcon;
        private transient Icon m_prefixIcon;
        private transient int m_prefixIconWidth;
        private transient Icon m_icoOpened;
        private transient Icon m_icoClosed;

        private void $init$() {
            this.m_added = false;
            this.m_level = -1;
            this.m_state = 0;
            this.m_meta = "";
            this.m_selected = false;
            this.m_forenorm = Color.black;
            this.m_backnorm = Color.white;
            this.m_background = null;
            this.m_foresel = Color.white;
            this.m_backsel = Color.blue;
            this.m_lineColor = Color.lightGray;
            this.m_ascent = 0;
            this.m_indentUnit = 12;
            this.m_showHierarchical = true;
            this.m_blnContextIconVisible = true;
            this.m_noFocusBorder = null;
            this.m_prefix = "";
            this.m_position = 0;
            this.m_padValue = 0;
            this.m_stepIcon = null;
            this.m_prefixIcon = null;
            this.m_prefixIconWidth = 0;
            this.m_icoOpened = null;
            this.m_icoClosed = null;
        }

        public DefDimListCellRenderer() {
            this.$init$();
            this.m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setOpaque(true);
            this.setBorder(this.m_noFocusBorder);
            this.init();
        }

        public void addNotify() {
            super.addNotify();
            this.m_added = true;
            this.init();
        }

        public void updateUI() {
            super.updateUI();
            this.init();
        }

        public void setShowHierarchical(boolean showHier) {
            this.m_showHierarchical = showHier;
        }

        public boolean getShowHierarchical() {
            return this.m_showHierarchical;
        }

        public void setIndentUnit(int value) {
            if (value > -1) {
                this.m_indentUnit = value;
                this.repaint();
            }
        }

        public int getIndentUnit() {
            return this.m_indentUnit;
        }

        public boolean isPrefixIconHit(DimListDataItem dataItem, Point point) {
            return dataItem != null && this.m_prefixIcon != null && point.x >= 0 && point.x < this.m_prefixIcon.getIconWidth();
        }

        public boolean isDrillIconHit(DimListDataItem dataItem, Point point) {
            if (dataItem != null) {
                Icon icon;
                int nLevel;
                int nOffset = 0;
                if (this.m_showHierarchical && (nLevel = dataItem.getLevel()) > -1) {
                    nOffset = nLevel * this.getIndentUnit() + this.m_position;
                }
                int nIconWidth = ((icon = this.getIcon()) != null ? icon.getIconWidth() : 0) + nOffset;
                if (point.x >= nOffset - 5 && point.x < nIconWidth + 5) {
                    return true;
                }
            }
            return false;
        }

        public int getTextXOffset(Object value) {
            int offset = 0;
            if (this.m_showHierarchical) {
                DimListDataItem dsItem = (DimListDataItem)value;
                int level = dsItem.getLevel();
                if (level > -1) {
                    Icon icon = this.getIcon();
                    offset += level * this.getIndentUnit();
                    offset += this.getIconTextGap() * 4;
                    if (icon != null) {
                        offset += icon.getIconWidth() * 2;
                        offset += this.getIconTextGap();
                    }
                } else {
                    offset += this.getIconTextGap();
                }
            }
            return offset;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int level = -1;
            int state = 0;
            String src = "";
            String meta = "";
            Icon stepIcon = null;
            Icon prefixIcon = null;
            Object icoOpened = null;
            Object icoClosed = null;
            String prefix = "";
            if (value instanceof String) {
                src = (String)value;
                level = -1;
                state = 0;
            } else {
                DimListDataItem dsItem = (DimListDataItem)value;
                if (dsItem != null) {
                    src = dsItem.getText();
                    level = dsItem.getLevel();
                    state = dsItem.getDrillState();
                    meta = dsItem.getMetaInfo();
                    prefix = dsItem.getPrefix();
                    stepIcon = dsItem.getDataIcon();
                    prefixIcon = dsItem.getPrefixIcon();
                    this.m_blnContextIconVisible = dsItem.isContextIconVisible();
                    this.m_icoOpened = dsItem.getOpenedIcon();
                    this.m_icoClosed = dsItem.getClosedIcon();
                }
            }
            this.setText(src);
            String accessibleDrillText = "";
            if (this.m_showHierarchical) {
                this.setIcon(state == 2 ? DimensionList.ra$m_expandedIcon(DimensionList.this) : (state == 1 ? DimensionList.ra$m_collapsedIcon(DimensionList.this) : DimensionList.ra$m_blankIcon(DimensionList.this)));
                this.m_level = level;
                if (state == 1) {
                    accessibleDrillText = AccessibleState.COLLAPSED.toDisplayString();
                } else if (state == 2) {
                    accessibleDrillText = AccessibleState.EXPANDED.toDisplayString();
                }
            } else {
                this.m_level = -1;
            }
            if (this.getAccessibleContext() != null) {
                this.getAccessibleContext().setAccessibleName(prefix + " " + src + " " + accessibleDrillText);
            }
            this.m_state = state;
            this.m_meta = meta;
            this.m_selected = isSelected;
            this.m_prefix = prefix;
            this.m_stepIcon = stepIcon;
            this.m_prefixIcon = prefixIcon;
            if (prefixIcon != null) {
                this.m_prefixIconWidth = prefixIcon.getIconWidth() + this.getIconTextGap();
            }
            if (isSelected) {
                this.m_background = this.m_backsel;
                this.setForeground(this.m_foresel);
            } else {
                this.m_background = this.m_backnorm;
                this.setForeground(this.m_forenorm);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.m_noFocusBorder);
            if (list != null && list instanceof DimensionList) {
                Dimension dim = this.getPreferredSize();
                this.m_position = ((DimensionList)list).getTabPosition();
                this.m_padValue = ((DimensionList)list).getCellHeightPadValue();
                DimensionList.this.setFixedCellHeight(dim.height + this.m_padValue);
                ((DimensionList)list).setWidthHeuristic(dim.width);
            }
            return this;
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            this.paintEx(g, size);
        }

        private void drawText(Graphics g, String s, int x, int cx, int cy, int ascent) {
            Insets in = this.getInsets();
            if (this.isEnabled()) {
                g.setColor(this.m_background);
            }
            int nWidth = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(s);
            g.fillRect(x, in.top, nWidth, cy);
            if (this.isEnabled()) {
                g.setColor(this.getForeground());
            } else {
                g.setColor(this.m_forenorm);
            }
            g.drawString(s, x, ascent);
        }

        private void paintEx(Graphics g, Dimension size) {
            Icon icon = this.getIcon();
            int cxIcon = 0;
            int cyIcon = 0;
            int cxTab = 0;
            int cx = 0;
            Insets in = this.getInsets();
            boolean bAnyIcons = false;
            cx = in.left;
            if (this.m_prefix != null) {
                if (this.m_prefixIcon != null) {
                    this.m_prefixIcon.paintIcon(this, g, cx, (size.height - this.m_padValue - this.m_prefixIcon.getIconHeight()) / 2);
                    cx += this.m_prefixIconWidth;
                }
                if (this.m_prefix != "") {
                    this.drawText(g, this.m_prefix, cx, this.m_position - cx, size.height - in.bottom - in.top, this.m_ascent);
                    int nWidth = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.m_prefix);
                    cx += nWidth;
                }
                cx = Math.max(cx, in.left + this.m_position);
            }
            if (this.m_showHierarchical && icon != null) {
                cxIcon = icon.getIconWidth();
                cyIcon = icon.getIconHeight();
            }
            cxTab = this.getIndentUnit();
            if (this.m_level > 0) {
                cx += this.m_level * cxTab;
            }
            if (this.m_showHierarchical) {
                if (DimensionList.this.isIconVisible()) {
                    if (icon != null) {
                        int y = (size.height - this.m_padValue - cyIcon) / 2;
                        int x = 0;
                        int n = x = cxIcon > cxTab ? cx + (cxIcon - cxTab) / 2 : cx + (cxTab - cxIcon) / 2;
                        if (this.m_level > 1 || this.m_state != 0) {
                            icon.paintIcon(this, g, x, y);
                        }
                    }
                    if (this.m_level > 1 || this.m_state != 0) {
                        cx += cxTab;
                    }
                    bAnyIcons = true;
                }
                if (DimensionList.this.isContextIconVisible() && this.m_blnContextIconVisible) {
                    if (this.m_stepIcon != null) {
                        this.m_stepIcon.paintIcon(this, g, cx, (size.height - this.m_padValue - this.m_stepIcon.getIconHeight()) / 2);
                    } else if (this.m_state == 1) {
                        if (this.m_icoClosed != null) {
                            this.m_icoClosed.paintIcon(this, g, cx, (size.height - this.m_padValue - this.m_icoClosed.getIconHeight()) / 2);
                        } else if (DimensionList.ra$m_closedIcon(DimensionList.this) != null) {
                            DimensionList.ra$m_closedIcon(DimensionList.this).paintIcon(this, g, cx, (size.height - this.m_padValue - DimensionList.ra$m_closedIcon(DimensionList.this).getIconHeight()) / 2);
                        }
                    } else if (this.m_state == 2) {
                        if (this.m_icoOpened != null) {
                            this.m_icoOpened.paintIcon(this, g, cx, (size.height - this.m_padValue - this.m_icoOpened.getIconHeight()) / 2);
                        } else if (DimensionList.ra$m_openedIcon(DimensionList.this) != null) {
                            DimensionList.ra$m_openedIcon(DimensionList.this).paintIcon(this, g, cx, (size.height - this.m_padValue - DimensionList.ra$m_openedIcon(DimensionList.this).getIconHeight()) / 2);
                        }
                    } else if (this.m_state == 0 && DimensionList.ra$m_nodeIcon(DimensionList.this) != null) {
                        DimensionList.ra$m_nodeIcon(DimensionList.this).paintIcon(this, g, cx, (size.height - this.m_padValue - DimensionList.ra$m_nodeIcon(DimensionList.this).getIconHeight()) / 2);
                    }
                    cx += cxTab;
                    bAnyIcons = true;
                }
                if (bAnyIcons) {
                    cx += this.getIconTextGap();
                }
            }
            this.drawText(g, this.getText(), cx, size.width - this.m_position - in.right, size.height - in.bottom, this.m_ascent);
        }

        public Dimension getPreferredSize() {
            int cxTab = 0;
            int cx = 0;
            Insets in = this.getInsets();
            boolean bAnyIcons = false;
            cx = in.left;
            if (this.m_prefix != null) {
                if (this.m_prefixIcon != null) {
                    cx += this.m_prefixIconWidth;
                }
                if (this.m_prefix != "") {
                    int nWidth = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.m_prefix);
                    cx += nWidth;
                }
                cx = Math.max(cx, in.left + this.m_position);
            }
            cxTab = this.getIndentUnit();
            if (this.m_level > 0) {
                cx += this.m_level * cxTab;
            }
            if (this.m_showHierarchical) {
                if (DimensionList.this.isIconVisible()) {
                    if (this.m_level != 1 || this.m_state != 0) {
                        cx += cxTab;
                    }
                    bAnyIcons = true;
                }
                if (DimensionList.this.isContextIconVisible() && this.m_blnContextIconVisible) {
                    cx += cxTab;
                    bAnyIcons = true;
                }
                if (bAnyIcons) {
                    cx += this.getIconTextGap();
                }
            }
            int nWidth = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.getText());
            return new Dimension(cx += nWidth, (int)super.getPreferredSize().getHeight());
        }

        private void drawHierarchyRelationships(Graphics g, int tab, int leftBorder, int height) {
            int cx;
            if (this.m_meta != null && (cx = this.m_meta.length()) > 0) {
                int col = leftBorder + (cx + 1) * tab - tab / 2;
                int cyHalf = height / 2;
                int halfTab = tab / 2;
                g.setColor(this.m_lineColor);
                int i = 0;
                while (i < cx) {
                    char ch = this.m_meta.charAt(i);
                    if (i == 0) {
                        if (ch == '0') {
                            g.drawLine(col, 0, col, height);
                            g.drawLine(col, cyHalf, col + halfTab, cyHalf);
                        } else {
                            g.drawLine(col, 0, col, cyHalf);
                            g.drawLine(col, cyHalf, col + halfTab, cyHalf);
                        }
                    } else if (ch == '0') {
                        g.drawLine(col, 0, col, height);
                    }
                    col -= tab;
                    ++i;
                }
            }
        }

        private void init() {
            FontMetrics _fm;
            Font _font = this.getFont();
            if (_font != null && (_fm = this.getFontMetrics(_font)) != null && this.m_added) {
                int cx = _fm.stringWidth("X");
                if (cx < DimensionList.ra$m_iconWidth(DimensionList.this)) {
                    cx = DimensionList.ra$m_iconWidth(DimensionList.this);
                }
                this.setIndentUnit(cx);
                this.m_ascent = _fm.getAscent();
                DimensionList.this.setFixedCellHeight(_fm.getHeight() + this.m_padValue);
            }
            this.m_forenorm = UIManager.getColor("List.foreground");
            this.m_backnorm = UIManager.getColor("List.background");
            this.m_foresel = UIManager.getColor("List.selectionForeground");
            this.m_backsel = UIManager.getColor("List.selectionBackground");
            this.m_lineColor = Color.lightGray;
        }
    }
}

