/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.dss.util.FocusUtility;

public class DragList
extends JList {
    private static final int HEIGHT = 1;
    private boolean m_blnMetaKeyDown;
    private Rectangle m_rectangle;
    private boolean m_blnDragging;
    private boolean m_blnInSelection;
    private boolean m_blnManualSortGuiEnabled;
    private boolean m_blnFromMouseEvent;

    private void $init$() {
        this.m_blnManualSortGuiEnabled = true;
        this.m_blnFromMouseEvent = false;
    }

    public DragList() {
        this.$init$();
    }

    public DragList(ListModel dataModel) {
        super(dataModel);
        this.$init$();
    }

    public DragList(Object[] listData) {
        super(listData);
        this.$init$();
    }

    public DragList(Vector listData) {
        super(listData);
        this.$init$();
    }

    public boolean isManualSortGuiEnabled() {
        return this.m_blnManualSortGuiEnabled;
    }

    public void setManualSortGuiEnabled(boolean blnManualSortGuiEnabled) {
        this.m_blnManualSortGuiEnabled = blnManualSortGuiEnabled;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && !this.m_blnFromMouseEvent) {
            FocusUtility.setFocusToFirstSelectedRow(this, focusEvent);
            this.ensureIndexIsVisible(this.getLeadSelectionIndex());
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        this.m_blnFromMouseEvent = true;
        if (this.isManualSortingGuiEnabled() && this.isEnabled() && !this.m_blnMetaKeyDown) {
            if (e.getID() == 501) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.m_blnDragging = true;
                if (this.inSelection(e)) {
                    this.m_blnInSelection = true;
                    this.m_blnFromMouseEvent = false;
                    return;
                }
            }
            if (e.getID() == 502) {
                this.setCursor(Cursor.getDefaultCursor());
                this.m_blnDragging = false;
                this.m_rectangle = null;
                if (this.m_blnInSelection) {
                    this.m_blnInSelection = false;
                    this.clearSelection();
                } else {
                    this.repaint();
                }
            }
        }
        super.processMouseEvent(e);
        this.m_blnFromMouseEvent = false;
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.isManualSortingGuiEnabled() && this.isEnabled()) {
            if (this.m_blnDragging && !this.inSelection(e)) {
                int intIndex = this.locationToIndex(e.getPoint());
                if (intIndex == -1 && e.getY() > 0 && (double)e.getY() < this.getSize().getHeight()) {
                    this.m_rectangle = this.getCellBounds(this.getModel().getSize() - 1, this.getModel().getSize() - 1);
                    this.m_rectangle.setLocation(this.m_rectangle.x, this.m_rectangle.y + this.m_rectangle.height);
                } else {
                    this.m_rectangle = this.getCellBounds(intIndex, intIndex);
                    if (this.m_rectangle != null) {
                        boolean blnLowerHalf;
                        boolean bl = blnLowerHalf = e.getY() % this.m_rectangle.height > this.m_rectangle.height / 2;
                        if (blnLowerHalf && intIndex == this.getMinSelectionIndex() - 1 || !blnLowerHalf && intIndex == this.getMaxSelectionIndex() + 1) {
                            this.m_rectangle = null;
                        } else if (blnLowerHalf) {
                            this.m_rectangle.setLocation(this.m_rectangle.x, this.m_rectangle.y + this.m_rectangle.height);
                        }
                    }
                }
            } else {
                this.m_rectangle = null;
            }
            this.repaint();
        } else {
            super.processMouseMotionEvent(e);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (this.isManualSortingGuiEnabled() && (e.getID() == 401 || e.getID() == 402)) {
            this.m_blnMetaKeyDown = e.isShiftDown() || e.isControlDown();
        }
    }

    protected boolean isManualSortingGuiEnabled() {
        return this.isManualSortGuiEnabled() && this.getModel().getSize() > 1;
    }

    protected boolean inSelection(MouseEvent e) {
        int intIndex = this.locationToIndex(e.getPoint());
        return intIndex >= this.getMinSelectionIndex() && intIndex <= this.getMaxSelectionIndex();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_rectangle != null) {
            g.fillRect(this.m_rectangle.x, this.m_rectangle.y, this.m_rectangle.width, 1);
        }
    }
}

