/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class LocaleDealer {
    private String[] MonthAbbr;
    private String[] WeekDayInFull;
    private String[] WeekDayInAbbr;
    private String[] MonthNameInFull;
    private String[] AmPmUpperCase;
    private String[] AmPmLowerCase;
    private String[] AmPmUpperCaseWithPeriods;
    private String[] AmPmLowerCaseWithPeriods;
    private String[] ErasUpperCase;
    private String[] ErasLowerCase;
    private String[] ErasUpperCaseWithPeriods;
    private String[] ErasLowerCaseWithPeriods;
    private Locale theLocale;
    private int weekDayFullMax;
    private int weekDayAbbrMax;
    private int monthFullMax;
    private int monthAbbrMax;
    private char m_groupingSeparator;
    private ResourceBundle m_bundle;
    private static final String UTIL_BUNDLE = "oracle.dss.util.resource.UtilBundle";

    public LocaleDealer(Locale loc) {
        this.$init$();
        this.theLocale = loc;
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public LocaleDealer() {
        this.$init$();
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public String[] getWeekDayName(boolean inAbbreviation) {
        if (inAbbreviation) {
            return this.WeekDayInAbbr;
        }
        return this.WeekDayInFull;
    }

    public String[] getMonthName(boolean inAbbreviation) {
        if (inAbbreviation) {
            return this.MonthAbbr;
        }
        return this.MonthNameInFull;
    }

    String[] getAmPm(boolean lowerCase, boolean withPeriods) {
        if (lowerCase) {
            if (withPeriods) {
                return this.AmPmLowerCaseWithPeriods;
            }
            return this.AmPmLowerCase;
        }
        if (withPeriods) {
            return this.AmPmUpperCaseWithPeriods;
        }
        return this.AmPmUpperCase;
    }

    String[] getEras(boolean lowerCase, boolean withPeriods) {
        if (lowerCase) {
            if (withPeriods) {
                return this.ErasLowerCaseWithPeriods;
            }
            return this.ErasLowerCase;
        }
        if (withPeriods) {
            return this.ErasUpperCaseWithPeriods;
        }
        return this.ErasUpperCase;
    }

    char getGroupingSeparator() {
        return this.m_groupingSeparator;
    }

    private void fillWeekDays() {
        SimpleDateFormat fFull = new SimpleDateFormat("EEEE", this.theLocale);
        SimpleDateFormat fAbbr = new SimpleDateFormat("EEE", this.theLocale);
        boolean bForceGregCal = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        GregorianCalendar cal = new GregorianCalendar(this.theLocale);
        if (bForceGregCal) {
            fFull.setCalendar(cal);
            fAbbr.setCalendar(cal);
        }
        int i = 0;
        while (i < 7) {
            cal = new GregorianCalendar(this.theLocale);
            cal.set(1998, 10, i + 1);
            Date theDate = cal.getTime();
            this.WeekDayInFull[i] = fFull.format(theDate);
            if (this.WeekDayInFull[i].length() > this.weekDayFullMax) {
                this.weekDayFullMax = this.WeekDayInFull[i].length();
            }
            this.WeekDayInAbbr[i] = fAbbr.format(theDate);
            if (this.WeekDayInAbbr[i].length() > this.weekDayAbbrMax) {
                this.weekDayAbbrMax = this.WeekDayInAbbr[i].length();
            }
            ++i;
        }
        this.adjustLength(this.WeekDayInFull, this.weekDayFullMax, 7);
        this.adjustLength(this.WeekDayInAbbr, this.weekDayAbbrMax, 7);
    }

    private void fillMonth() {
        boolean bForceGregCal;
        SimpleDateFormat fFull = new SimpleDateFormat("MMMM", this.theLocale);
        SimpleDateFormat fAbbr = null;
        fAbbr = this.theLocale.getLanguage().compareTo("ja") == 0 ? new SimpleDateFormat("MMM", Locale.ENGLISH) : new SimpleDateFormat("MMM", this.theLocale);
        GregorianCalendar cal = new GregorianCalendar(this.theLocale);
        boolean bl = bForceGregCal = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            fFull.setCalendar(cal);
            fAbbr.setCalendar(cal);
        }
        int i = 0;
        while (i < 12) {
            cal = new GregorianCalendar(1999, i, 1);
            Date theDate = cal.getTime();
            this.MonthNameInFull[i] = fFull.format(theDate);
            if (this.MonthNameInFull[i].length() > this.monthFullMax) {
                this.monthFullMax = this.MonthNameInFull[i].length();
            }
            this.MonthAbbr[i] = fAbbr.format(theDate);
            if (this.MonthAbbr[i].length() > this.monthAbbrMax) {
                this.monthAbbrMax = this.MonthAbbr[i].length();
            }
            ++i;
        }
        this.adjustLength(this.MonthNameInFull, this.monthFullMax, 12);
        this.adjustLength(this.MonthAbbr, this.monthAbbrMax, 12);
    }

    private void _fillAmPm() {
        this.AmPmUpperCase = new String[2];
        this.AmPmUpperCaseWithPeriods = new String[2];
        this.AmPmLowerCase = new String[2];
        this.AmPmLowerCaseWithPeriods = new String[2];
        if (this.m_bundle != null) {
            this.AmPmUpperCase[0] = this.m_bundle.getString("AM");
            this.AmPmUpperCase[1] = this.m_bundle.getString("PM");
            this.AmPmUpperCaseWithPeriods[0] = this.m_bundle.getString("A.M.");
            this.AmPmUpperCaseWithPeriods[1] = this.m_bundle.getString("P.M.");
            this.AmPmLowerCase[0] = this.m_bundle.getString("am");
            this.AmPmLowerCase[1] = this.m_bundle.getString("pm");
            this.AmPmLowerCaseWithPeriods[0] = this.m_bundle.getString("a.m.");
            this.AmPmLowerCaseWithPeriods[1] = this.m_bundle.getString("p.m.");
        } else {
            this.AmPmUpperCase[0] = "AM";
            this.AmPmUpperCase[1] = "PM";
            this.AmPmUpperCaseWithPeriods[0] = "A.M.";
            this.AmPmUpperCaseWithPeriods[1] = "P.M.";
            this.AmPmLowerCase[0] = "am";
            this.AmPmLowerCase[1] = "pm";
            this.AmPmLowerCaseWithPeriods[0] = "a.m.";
            this.AmPmLowerCaseWithPeriods[1] = "p.m.";
        }
    }

    private void _fillEras() {
        this.ErasUpperCase = new String[2];
        this.ErasUpperCaseWithPeriods = new String[2];
        this.ErasLowerCase = new String[2];
        this.ErasLowerCaseWithPeriods = new String[2];
        if (this.m_bundle != null) {
            this.ErasUpperCase[0] = this.m_bundle.getString("BC");
            this.ErasUpperCase[1] = this.m_bundle.getString("AD");
            this.ErasUpperCaseWithPeriods[0] = this.m_bundle.getString("B.C.");
            this.ErasUpperCaseWithPeriods[1] = this.m_bundle.getString("A.D.");
            this.ErasLowerCase[0] = this.m_bundle.getString("bc");
            this.ErasLowerCase[1] = this.m_bundle.getString("ad");
            this.ErasLowerCaseWithPeriods[0] = this.m_bundle.getString("b.c.");
            this.ErasLowerCaseWithPeriods[1] = this.m_bundle.getString("a.d.");
        } else {
            this.ErasUpperCase[0] = "BC";
            this.ErasUpperCase[1] = "AD";
            this.ErasUpperCaseWithPeriods[0] = "B.C.";
            this.ErasUpperCaseWithPeriods[1] = "A.D.";
            this.ErasLowerCase[0] = "bc";
            this.ErasLowerCase[1] = "ad";
            this.ErasLowerCaseWithPeriods[0] = "b.c.";
            this.ErasLowerCaseWithPeriods[1] = "a.d.";
        }
    }

    private void _fillGroupingSeparator() {
        DecimalFormatSymbols dfs = null;
        dfs = this.theLocale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(this.theLocale);
        this.m_groupingSeparator = dfs.getGroupingSeparator();
    }

    private void adjustLength(String[] arr, int maxLen, int arrLen) {
        int i = 0;
        while (i < arrLen) {
            int theLen = arr[i].length();
            if (theLen < maxLen) {
                int diff = maxLen - theLen;
                int j = 0;
                while (j < diff) {
                    int n = i;
                    arr[n] = arr[n] + " ";
                    ++j;
                }
            }
            ++i;
        }
    }

    private void _updateResourceBundle() {
        try {
            this.m_bundle = this.theLocale != null ? ResourceBundle.getBundle(UTIL_BUNDLE, this.theLocale) : ResourceBundle.getBundle(UTIL_BUNDLE);
        }
        catch (MissingResourceException e) {
            this.m_bundle = null;
        }
    }

    private void $init$() {
        this.MonthAbbr = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        this.WeekDayInFull = new String[]{null, null, null, null, null, null, null};
        this.WeekDayInAbbr = new String[]{null, null, null, null, null, null, null};
        this.MonthNameInFull = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        this.AmPmUpperCase = new String[]{null, null};
        this.AmPmLowerCase = new String[]{null, null};
        this.AmPmUpperCaseWithPeriods = new String[]{null, null};
        this.AmPmLowerCaseWithPeriods = new String[]{null, null};
        this.ErasUpperCase = new String[]{null, null};
        this.ErasLowerCase = new String[]{null, null};
        this.ErasUpperCaseWithPeriods = new String[]{null, null};
        this.ErasLowerCaseWithPeriods = new String[]{null, null};
        this.theLocale = Locale.getDefault();
        this.weekDayFullMax = 0;
        this.weekDayAbbrMax = 0;
        this.monthFullMax = 0;
        this.monthAbbrMax = 0;
        this.m_groupingSeparator = (char)44;
        this.m_bundle = null;
    }
}

