/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.format.dateFormat.BadOracleDateFormatException;
import oracle.dss.util.format.dateFormat.DateConstants;
import oracle.dss.util.format.dateFormat.DateFormatToken;
import oracle.dss.util.format.dateFormat.LiteralToken;
import oracle.dss.util.format.dateFormat.LocaleDealer;
import oracle.dss.util.format.dateFormat.ModifierToken;
import oracle.dss.util.format.dateFormat.Scanner;
import oracle.dss.util.format.dateFormat.StringBasedDateFormat;
import oracle.dss.util.format.dateFormat.TimeUnitToken;

public class OracleDateFormat
extends StringBasedDateFormat {
    protected transient ErrorHandler m_eh;
    private Vector tokenList;
    private Locale thisLocale;
    private TimeZone thisTimeZone;
    private String formatString;
    private String[] MonthNameInAbbr;
    private String[] MonthNameInFull;
    private String[] WeekDayInFull;
    private String[] WeekDayInAbbr;
    private String[] AmPmLowerCase;
    private String[] AmPmLowerCaseWithPeriods;
    private String[] AmPmUpperCase;
    private String[] AmPmUpperCaseWithPeriods;
    private String[] ErasLowerCase;
    private String[] ErasLowerCaseWithPeriods;
    private String[] ErasUpperCase;
    private String[] ErasUpperCaseWithPeriods;
    private char m_groupingSeparator;
    private static final boolean DEBUG = false;

    public OracleDateFormat(String fstring) throws BadOracleDateFormatException {
        this.$init$();
        Locale loc = Locale.getDefault();
        this.thisTimeZone = TimeZone.getDefault();
        if (loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(loc));
        }
        this.FormatTheString(fstring, loc);
    }

    public OracleDateFormat(String fstring, Locale loc) throws BadOracleDateFormatException {
        this.$init$();
        this.thisTimeZone = TimeZone.getDefault();
        if (loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(loc));
        }
        this.FormatTheString(fstring, loc);
    }

    public OracleDateFormat(Locale loc) {
        this.$init$();
        this.thisLocale = loc;
        this.formatString = "";
        this.thisTimeZone = TimeZone.getDefault();
        if (loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(loc));
        }
    }

    public OracleDateFormat(Locale loc, TimeZone tz) {
        this.$init$();
        this.thisLocale = loc;
        this.formatString = "";
        this.thisTimeZone = tz == null ? TimeZone.getDefault() : tz;
        Calendar cal = null;
        cal = loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(this.thisTimeZone, loc) : Calendar.getInstance(this.thisTimeZone, loc);
        this.setCalendar(cal);
        LocaleDealer theDealer = new LocaleDealer(loc);
        this.WeekDayInFull = theDealer.getWeekDayName(false);
        this.WeekDayInAbbr = theDealer.getWeekDayName(true);
        this.MonthNameInAbbr = theDealer.getMonthName(true);
        this.MonthNameInFull = theDealer.getMonthName(false);
        this.AmPmLowerCase = theDealer.getAmPm(true, false);
        this.AmPmLowerCaseWithPeriods = theDealer.getAmPm(true, true);
        this.AmPmUpperCase = theDealer.getAmPm(false, false);
        this.AmPmUpperCaseWithPeriods = theDealer.getAmPm(false, true);
        this.ErasLowerCase = theDealer.getEras(true, false);
        this.ErasLowerCaseWithPeriods = theDealer.getEras(true, true);
        this.ErasUpperCase = theDealer.getEras(false, false);
        this.ErasUpperCaseWithPeriods = theDealer.getEras(false, true);
        this.m_groupingSeparator = theDealer.getGroupingSeparator();
    }

    private void FormatTheString(String fstring, Locale loc) throws BadOracleDateFormatException {
        this.formatString = fstring;
        Scanner formatScanner = new Scanner(this.formatString);
        this.tokenList = new Vector();
        int numOfToken = 0;
        DateFormatToken thisToken = formatScanner.getNextToken();
        while (thisToken.getType() != 0) {
            int tokenType = thisToken.getType();
            if (tokenType == 48) {
                throw new BadOracleDateFormatException("Bad Format: " + thisToken.getValue());
            }
            if (tokenType == 13 || tokenType == 14) {
                throw new BadOracleDateFormatException("Era not supported!");
            }
            if (tokenType == 400 || tokenType == 300) {
                if (numOfToken == 0) {
                    throw new BadOracleDateFormatException("Date format not recognized");
                }
                DateFormatToken preToken = (DateFormatToken)this.tokenList.elementAt(numOfToken - 1);
                int preTokenType = preToken.getType();
                if (preTokenType == 23 && preToken.getCase() == 1 && thisToken.getCase() == 2) {
                    ((TimeUnitToken)preToken).setCase(3);
                }
                int i = 0;
                while (i < 16) {
                    if (preTokenType == DateConstants.TokenFollowedByTHSP[i]) {
                        throw new BadOracleDateFormatException("Bad Format: TH or SP can't modify " + preToken.getValue());
                    }
                    ++i;
                }
                if (tokenType == 400) {
                    if (!((TimeUnitToken)this.tokenList.elementAt(numOfToken - 1)).setTH()) {
                        throw new BadOracleDateFormatException("Bad Format: No two THs together.");
                    }
                } else if (!((TimeUnitToken)this.tokenList.elementAt(numOfToken - 1)).setSP()) {
                    throw new BadOracleDateFormatException("Bad Format: No two SPs together.");
                }
            } else {
                this.tokenList.addElement(thisToken);
                ++numOfToken;
            }
            thisToken = formatScanner.getNextToken();
        }
        if (loc != this.thisLocale) {
            this.thisLocale = loc;
            Calendar cal = null;
            cal = loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(this.thisTimeZone, loc) : Calendar.getInstance(this.thisTimeZone, loc);
            this.setCalendar(cal);
            LocaleDealer theDealer = new LocaleDealer(loc);
            this.WeekDayInFull = theDealer.getWeekDayName(false);
            this.WeekDayInAbbr = theDealer.getWeekDayName(true);
            this.MonthNameInAbbr = theDealer.getMonthName(true);
            this.MonthNameInFull = theDealer.getMonthName(false);
            this.AmPmLowerCase = theDealer.getAmPm(true, false);
            this.AmPmLowerCaseWithPeriods = theDealer.getAmPm(true, true);
            this.AmPmUpperCase = theDealer.getAmPm(false, false);
            this.AmPmUpperCaseWithPeriods = theDealer.getAmPm(false, true);
            this.ErasLowerCase = theDealer.getEras(true, false);
            this.ErasLowerCaseWithPeriods = theDealer.getEras(true, true);
            this.ErasUpperCase = theDealer.getEras(false, false);
            this.ErasUpperCaseWithPeriods = theDealer.getEras(false, true);
            this.m_groupingSeparator = theDealer.getGroupingSeparator();
        }
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String fstring) {
        block7: {
            String oldVal = this.formatString;
            try {
                this.FormatTheString(fstring, this.thisLocale);
                this.formatString = fstring;
            }
            catch (BadOracleDateFormatException e) {
                if (this.m_eh != null) {
                    this.m_eh.error(e, this.getClass().getName(), "setFormatString");
                } else {
                    e.printStackTrace();
                }
                this.formatString = oldVal;
                if (this.formatString.equals("")) break block7;
                try {
                    this.FormatTheString(this.formatString, this.thisLocale);
                }
                catch (BadOracleDateFormatException bde) {
                    this.formatString = "";
                    if (this.m_eh != null) {
                        this.m_eh.error(e, this.getClass().getName(), "setFormatString");
                        break block7;
                    }
                    bde.printStackTrace();
                }
            }
        }
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            } else {
                System.out.println("Oracle date format string hasn't been set");
            }
            toAppendTo.append(date.toString());
            return toAppendTo;
        }
        int numOfToken = this.tokenList.size();
        Calendar cal = this.getCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        boolean fillModeOn = true;
        if (year < 0) {
            year = -year;
        }
        int i = 0;
        while (i < numOfToken) {
            DateFormatToken thisToken = (DateFormatToken)this.tokenList.elementAt(i);
            if (thisToken instanceof LiteralToken) {
                toAppendTo.append(thisToken.getValue());
            } else if (thisToken instanceof ModifierToken) {
                if (thisToken.getType() == 100) {
                    fillModeOn ^= true;
                } else if (thisToken.getType() == 200) {
                    // empty if block
                }
            } else {
                toAppendTo.append(this.processToken((TimeUnitToken)thisToken, date, fillModeOn, cal, year));
            }
            ++i;
        }
        return toAppendTo;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    private String processToken(TimeUnitToken thisToken, Date date, boolean fillModeOn, Calendar cal, int year) {
        String retval = "";
        int option = thisToken.getType();
        switch (option) {
            case 1: 
            case 5: {
                if (cal.get(0) == 1) {
                    if (thisToken.getCase() == 1) {
                        retval = this.ErasUpperCaseWithPeriods[1];
                        break;
                    }
                    retval = this.ErasLowerCaseWithPeriods[1];
                    break;
                }
                if (thisToken.getCase() == 1) {
                    retval = this.ErasUpperCaseWithPeriods[0];
                    break;
                }
                retval = this.ErasLowerCaseWithPeriods[0];
                break;
            }
            case 2: 
            case 28: {
                if (cal.get(9) == 1) {
                    if (thisToken.getCase() == 1) {
                        retval = this.AmPmUpperCaseWithPeriods[1];
                        break;
                    }
                    retval = this.AmPmLowerCaseWithPeriods[1];
                    break;
                }
                if (thisToken.getCase() == 1) {
                    retval = this.AmPmUpperCaseWithPeriods[0];
                    break;
                }
                retval = this.AmPmLowerCaseWithPeriods[0];
                break;
            }
            case 3: 
            case 6: {
                if (cal.get(0) == 1) {
                    if (thisToken.getCase() == 1) {
                        retval = this.ErasUpperCase[1];
                        break;
                    }
                    retval = this.ErasLowerCase[1];
                    break;
                }
                if (thisToken.getCase() == 1) {
                    retval = this.ErasUpperCase[0];
                    break;
                }
                retval = this.ErasLowerCase[0];
                break;
            }
            case 4: 
            case 29: {
                if (cal.get(9) == 1) {
                    if (thisToken.getCase() == 1) {
                        retval = this.AmPmUpperCase[1];
                        break;
                    }
                    retval = this.AmPmLowerCase[1];
                    break;
                }
                if (thisToken.getCase() == 1) {
                    retval = this.AmPmUpperCase[0];
                    break;
                }
                retval = this.AmPmLowerCase[0];
                break;
            }
            case 7: 
            case 34: {
                int cc = year / 100;
                if (year % 100 != 0) {
                    ++cc;
                }
                retval = Integer.toString(cc);
                if (cc < 10 && fillModeOn) {
                    retval = "0" + retval;
                }
                String tmp = " ";
                if (cal.get(0) != 1) {
                    tmp = "-";
                }
                if (option != 34) break;
                retval = tmp + retval;
                break;
            }
            case 8: {
                retval = Integer.toString(cal.get(7));
                break;
            }
            case 9: {
                int today = cal.get(7);
                retval = this.WeekDayInFull[today - 1];
                if (thisToken.getCase() == 1) {
                    retval = retval.toUpperCase();
                } else if (thisToken.getCase() == 2) {
                    retval = retval.toLowerCase();
                }
                if (fillModeOn) break;
                retval = retval.trim();
                break;
            }
            case 10: {
                int val = cal.get(5);
                if (val < 10 && fillModeOn) {
                    retval = "0" + Integer.toString(val);
                    break;
                }
                retval = Integer.toString(val);
                break;
            }
            case 11: {
                int val = cal.get(6);
                if (!fillModeOn) {
                    retval = Integer.toString(val);
                    break;
                }
                String tmp = "";
                if (val < 10) {
                    tmp = "00";
                } else if (val < 100) {
                    tmp = "0";
                }
                retval = tmp + Integer.toString(val);
                break;
            }
            case 12: {
                int today = cal.get(7);
                retval = this.WeekDayInAbbr[today - 1];
                if (thisToken.getCase() == 1) {
                    retval = retval.toUpperCase();
                    break;
                }
                if (thisToken.getCase() != 2) break;
                retval = retval.toLowerCase();
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                SimpleDateFormat dummyFormatter = new SimpleDateFormat("h");
                dummyFormatter.setCalendar(this.getCalendar());
                retval = dummyFormatter.format(date);
                if (!fillModeOn || retval.length() != 1) break;
                retval = "0" + retval;
                break;
            }
            case 17: {
                SimpleDateFormat dummyFormatter = new SimpleDateFormat("H");
                dummyFormatter.setCalendar(this.getCalendar());
                retval = dummyFormatter.format(date);
                if (!fillModeOn || retval.length() != 1) break;
                retval = "0" + retval;
                break;
            }
            case 19: {
                int num = this.weekInISO(cal);
                retval = Integer.toString(num);
                if (!fillModeOn || num >= 10) break;
                retval = "0" + retval;
                break;
            }
            case 23: {
                int theMon = cal.get(2) + 1;
                int theDay = cal.get(5);
                int res = 0;
                int theYear = year;
                if (cal.get(0) != 1) {
                    theYear = -year;
                }
                if (theYear < 1582 || theYear == 1582 && theMon < 10 || theYear == 1582 && theMon == 10 && theDay < 5) {
                    int daysWithoutLeap = (4712 + year) * 365;
                    int numOfLeapYear = 1178 + (year - 1) / 4;
                    if (cal.get(0) != 1) {
                        daysWithoutLeap = (4712 - year) * 365;
                        numOfLeapYear = (4712 - year + 1) / 4 - 1;
                        if (numOfLeapYear < 0) {
                            numOfLeapYear = 0;
                        }
                    }
                    res = daysWithoutLeap + numOfLeapYear + cal.get(6);
                } else if (theYear == 1582 && theMon == 10 && theDay > 4 && theDay < 16) {
                    res = 2299161;
                } else {
                    int daysWithoutLeap = (4712 + year) * 365;
                    int tmp = (year - 1) / 100;
                    int numOfLeapYear = 1179 + (year - 1) / 4 - tmp + tmp / 4 + 1;
                    res = daysWithoutLeap + numOfLeapYear + cal.get(6);
                }
                retval = Integer.toString(res);
                int digits = retval.length();
                if (digits == 7 || !fillModeOn) break;
                int i = 0;
                while (i < 7 - digits) {
                    retval = "0" + retval;
                    ++i;
                }
                break;
            }
            case 24: {
                int val = cal.get(12);
                retval = Integer.toString(val);
                if (!fillModeOn || val >= 10) break;
                retval = "0" + retval;
                break;
            }
            case 25: {
                int val = cal.get(2) + 1;
                retval = Integer.toString(val);
                if (!fillModeOn || val >= 10) break;
                retval = "0" + retval;
                break;
            }
            case 26: {
                retval = this.MonthNameInAbbr[cal.get(2)];
                if (thisToken.getCase() == 1) {
                    retval = retval.toUpperCase();
                    break;
                }
                if (thisToken.getCase() != 2) break;
                retval = retval.toLowerCase();
                break;
            }
            case 27: {
                retval = this.MonthNameInFull[cal.get(2)];
                if (thisToken.getCase() == 1) {
                    retval = retval.toUpperCase();
                } else if (thisToken.getCase() == 2) {
                    retval = retval.toLowerCase();
                }
                if (fillModeOn) break;
                retval = retval.trim();
                break;
            }
            case 30: {
                int thisQuarter = cal.get(2) / 3 + 1;
                retval = Integer.toString(thisQuarter);
                break;
            }
            case 31: {
                retval = DateConstants.MonthInRoman[cal.get(2)];
                if (thisToken.getCase() == 1) {
                    retval = retval.toUpperCase();
                } else if (thisToken.getCase() == 2) {
                    retval = retval.toLowerCase();
                }
                if (fillModeOn) break;
                retval = retval.trim();
                break;
            }
            case 35: {
                int val = cal.get(13);
                retval = Integer.toString(val);
                if (!fillModeOn || val >= 10) break;
                retval = "0" + retval;
                break;
            }
            case 36: {
                int hour = cal.get(11);
                int minute = cal.get(12);
                int second = cal.get(13);
                retval = Integer.toString(hour * 3600 + minute * 60 + second);
                if (!fillModeOn) break;
                int numOfZeroNeeded = 5 - retval.length();
                int i = 0;
                while (i < numOfZeroNeeded) {
                    retval = "0" + retval;
                    ++i;
                }
                break;
            }
            case 40: {
                int dayInMonth = cal.get(5);
                retval = Integer.toString((dayInMonth - 1) / 7 + 1);
                break;
            }
            case 41: {
                int dayInYear = cal.get(6);
                int val = (dayInYear - 1) / 7 + 1;
                retval = Integer.toString(val);
                if (!fillModeOn || val >= 10) break;
                retval = "0" + retval;
                break;
            }
            case 18: 
            case 42: {
                int theYear = year;
                if (option == 18) {
                    theYear = this.yearInISO(cal);
                }
                String interVal = Integer.toString(theYear);
                int len = interVal.length();
                retval = interVal.substring(len - 1, len);
                break;
            }
            case 38: {
                String tmp = " ";
                retval = this.spellYear(year, thisToken.getCase());
                if (cal.get(0) != 1) {
                    tmp = "-";
                }
                retval = tmp + retval;
                break;
            }
            case 44: {
                retval = this.spellYear(year, thisToken.getCase());
                break;
            }
            case 20: 
            case 32: 
            case 45: {
                String interVal;
                int len;
                int theYear = year;
                if (option == 20) {
                    theYear = this.yearInISO(cal);
                }
                if ((len = (interVal = Integer.toString(theYear)).length()) == 1) {
                    if (fillModeOn) {
                        retval = "0" + interVal;
                        break;
                    }
                    retval = interVal;
                    break;
                }
                retval = interVal.substring(len - 2, len);
                if (fillModeOn || retval.charAt(0) != '0') break;
                retval = retval.substring(1, 2);
                break;
            }
            case 21: 
            case 46: {
                int len;
                int theYear = year;
                if (option == 21) {
                    theYear = this.yearInISO(cal);
                }
                if ((len = (retval = Integer.toString(theYear)).length()) == 1) {
                    if (!fillModeOn) break;
                    retval = "00" + retval;
                    break;
                }
                if (len == 2) {
                    if (!fillModeOn) break;
                    retval = "0" + retval;
                    break;
                }
                retval = retval.substring(len - 3, len);
                if (fillModeOn) break;
                if (retval.startsWith("00")) {
                    retval = retval.substring(2, 3);
                    break;
                }
                if (!retval.startsWith("0")) break;
                retval = retval.substring(1, 3);
                break;
            }
            case 22: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 47: {
                int len;
                int theYear = year;
                if (option == 22) {
                    theYear = this.yearInISO(cal);
                }
                if ((len = (retval = Integer.toString(theYear)).length()) == 1) {
                    if (fillModeOn) {
                        retval = "000" + retval;
                    }
                } else if (len == 2) {
                    if (fillModeOn) {
                        retval = "00" + retval;
                    }
                } else if (len == 3 && fillModeOn) {
                    retval = "0" + retval;
                }
                len = retval.length();
                String tmp = " ";
                if (cal.get(0) == 0) {
                    tmp = "-";
                }
                if (option == 43 && len == 4) {
                    retval = retval.substring(0, 1) + this.m_groupingSeparator + retval.substring(1, 4);
                    break;
                }
                if (option == 37) {
                    if (len == 4) {
                        retval = tmp + retval.substring(0, 1) + this.m_groupingSeparator + retval.substring(1, 4);
                        break;
                    }
                    retval = tmp + retval;
                    break;
                }
                if (option != 39) break;
                retval = tmp + retval;
                break;
            }
            default: {
                System.out.println("Shouldn't be here at all!");
            }
        }
        if (thisToken.getTH() && !thisToken.getSP()) {
            int theCase = thisToken.getCase();
            retval = this.processTH(retval, theCase);
        } else if (thisToken.getSP()) {
            int theCase = thisToken.getCase();
            boolean THOn = thisToken.getTH();
            boolean forJulian = false;
            if (thisToken.getType() == 23) {
                forJulian = true;
            }
            retval = this.processSP(retval, THOn, theCase, forJulian);
        }
        return retval;
    }

    private String processTH(String thisVal, int theCase) {
        int len = thisVal.length();
        if (len == 0) {
            return thisVal;
        }
        int val = new Integer(thisVal);
        if (val > 99) {
            val = new Integer(thisVal.substring(len - 2, len));
        }
        int valone = 0;
        String tmp = "th";
        if (theCase == 1) {
            tmp = tmp.toUpperCase();
        }
        if (val > 10 && val < 14) {
            return thisVal + tmp;
        }
        valone = len == 1 ? new Integer(thisVal).intValue() : new Integer(thisVal.substring(len - 1, len)).intValue();
        if (valone == 1) {
            tmp = "st";
        } else if (valone == 2) {
            tmp = "nd";
        } else if (valone == 3) {
            tmp = "rd";
        }
        if (theCase == 1) {
            tmp = tmp.toUpperCase();
        }
        return thisVal + tmp;
    }

    private String processSP(String thisVal, boolean THOn, int theCase, boolean forJulian) {
        String currentStr = thisVal;
        String retval = "";
        int pos = thisVal.indexOf(this.m_groupingSeparator);
        if (pos != -1) {
            currentStr = thisVal.substring(0, pos) + thisVal.substring(pos + 1);
        }
        currentStr = currentStr.replace('-', ' ');
        int numVal = new Integer(currentStr = currentStr.trim());
        if (numVal == 0) {
            retval = THOn ? DateConstants.NumInTH[0] : DateConstants.NumSpelledOut[0];
        } else if (!forJulian && numVal < 10000) {
            int fourthDigit = numVal / 1000;
            if (numVal % 1000 == 0) {
                retval = DateConstants.NumSpelledOut[fourthDigit];
                retval = !THOn ? retval + " " + DateConstants.NumSpelledOut[29] : retval + " " + DateConstants.NumInTH[29];
            } else {
                if (fourthDigit > 0) {
                    retval = DateConstants.NumSpelledOut[fourthDigit] + " " + DateConstants.NumSpelledOut[29];
                }
                int rest = numVal % 1000;
                String dum = " ";
                if (fourthDigit == 0) {
                    dum = "";
                }
                retval = retval + dum + this.constructThreeDigits(rest, THOn);
            }
        } else {
            int millions = numVal / 1000000;
            int thousands = numVal % 1000000 / 1000;
            int rest = numVal % 1000;
            String dum = "";
            if (millions != 0) {
                retval = DateConstants.NumSpelledOut[millions];
                retval = numVal % 1000000 == 0 && THOn ? retval + " " + DateConstants.NumInTH[30] : retval + " " + DateConstants.NumSpelledOut[30];
                dum = " ";
            }
            if (thousands != 0) {
                retval = retval + dum + this.constructThreeDigits(thousands, false);
                retval = numVal % 1000 == 0 && THOn ? retval + " " + DateConstants.NumInTH[29] : retval + " " + DateConstants.NumSpelledOut[29];
                dum = " ";
            }
            if (rest != 0) {
                retval = retval + dum + this.constructThreeDigits(rest, THOn);
            }
        }
        if (theCase == 1) {
            retval = retval.toUpperCase();
        } else if (theCase == 2) {
            retval = retval.toLowerCase();
        }
        return retval;
    }

    private String constructThreeDigits(int val, boolean THOn) {
        int num = val;
        String retval = "";
        int tmp = num / 100;
        if (num % 100 == 0) {
            retval = THOn ? DateConstants.NumInTH[28] : DateConstants.NumSpelledOut[28];
            retval = DateConstants.NumSpelledOut[tmp] + " " + retval;
        } else if (num < 21) {
            retval = THOn ? DateConstants.NumInTH[num] : DateConstants.NumSpelledOut[num];
        } else {
            if (num > 99) {
                retval = DateConstants.NumSpelledOut[tmp] + " " + DateConstants.NumSpelledOut[28];
                num %= 100;
            }
            if (num < 21) {
                retval = THOn ? retval + " " + DateConstants.NumInTH[num] : retval + " " + DateConstants.NumSpelledOut[num];
            } else {
                int firstOne = num / 10;
                int secondOne = num % 10;
                if (secondOne == 0) {
                    if (retval.length() != 0) {
                        retval = retval + " ";
                    }
                    retval = THOn ? retval + DateConstants.NumInTH[18 + firstOne] : retval + DateConstants.NumSpelledOut[18 + firstOne];
                } else {
                    String dum = "-";
                    if (retval.length() != 0) {
                        retval = retval + " ";
                    }
                    if (firstOne != 0) {
                        retval = retval + DateConstants.NumSpelledOut[18 + firstOne];
                    } else {
                        dum = " ";
                        if (retval.length() != 0) {
                            dum = "";
                        }
                    }
                    retval = THOn ? retval + dum + DateConstants.NumInTH[secondOne] : retval + dum + DateConstants.NumSpelledOut[secondOne];
                }
            }
        }
        return retval;
    }

    private String spellYear(int theYear, int thisCase) {
        String retval = "";
        if (theYear >= 1000) {
            if (theYear % 1000 == 0) {
                retval = DateConstants.NumSpelledOut[theYear / 1000] + " " + DateConstants.NumSpelledOut[29];
            } else if (theYear / 10 % 10 == 0) {
                retval = DateConstants.NumSpelledOut[theYear / 1000] + " " + DateConstants.NumSpelledOut[29];
                int tmp = theYear / 100 % 10;
                if (tmp != 0) {
                    retval = retval + " " + DateConstants.NumSpelledOut[tmp] + " " + DateConstants.NumSpelledOut[28];
                }
                if (theYear % 10 != 0) {
                    retval = retval + " " + DateConstants.NumSpelledOut[theYear % 10];
                }
            } else {
                retval = this.constructTwoDigits(theYear / 100) + " " + this.constructTwoDigits(theYear % 100);
            }
        } else if (theYear >= 100) {
            int secondDigit = theYear / 10 % 10;
            if (secondDigit == 0) {
                retval = DateConstants.NumSpelledOut[theYear / 100] + " " + DateConstants.NumSpelledOut[28];
                int thirdDigit = theYear % 10;
                if (thirdDigit != 0) {
                    retval = retval + " " + DateConstants.NumSpelledOut[thirdDigit];
                }
            } else {
                retval = DateConstants.NumSpelledOut[theYear / 100] + " " + this.constructTwoDigits(theYear % 100);
            }
        } else {
            retval = this.constructTwoDigits(theYear % 100);
        }
        if (thisCase == 1) {
            retval = retval.toUpperCase();
        } else if (thisCase == 2) {
            retval = retval.toLowerCase();
        }
        return retval;
    }

    private String constructTwoDigits(int num) {
        int firstOne = num / 10;
        int secondOne = num % 10;
        if (num < 21) {
            return DateConstants.NumSpelledOut[num];
        }
        if (secondOne == 0) {
            return DateConstants.NumSpelledOut[18 + firstOne];
        }
        return DateConstants.NumSpelledOut[18 + firstOne] + "-" + DateConstants.NumSpelledOut[secondOne];
    }

    private boolean firstWeekInPreYear(int year) {
        GregorianCalendar dayCal = new GregorianCalendar(Locale.US);
        dayCal.set(year, 0, 1);
        int firstDay = dayCal.get(7);
        return firstDay == 1 || firstDay == 6 || firstDay == 7;
    }

    private int weekInISO(Calendar cal) {
        int theYear = cal.get(1);
        int weekInCal = cal.get(3);
        int yearIn = this.yearInISO(cal);
        if (yearIn == theYear) {
            int dayInWeek = cal.get(7);
            if (dayInWeek == 1) {
                --weekInCal;
            }
            if (this.firstWeekInPreYear(theYear)) {
                GregorianCalendar tmpCal = new GregorianCalendar(Locale.US);
                tmpCal.set(theYear, 0, 1);
                int firstDayInWeek = tmpCal.get(7);
                if (firstDayInWeek == 1) {
                    return weekInCal;
                }
                return weekInCal - 1;
            }
            return weekInCal;
        }
        if (yearIn == theYear + 1) {
            return 1;
        }
        GregorianCalendar dayCal = new GregorianCalendar(Locale.US);
        dayCal.set(yearIn, 11, 31);
        int weekInCalLastYear = dayCal.get(3);
        if (this.firstWeekInPreYear(yearIn)) {
            GregorianCalendar tmpCal = new GregorianCalendar(Locale.US);
            tmpCal.set(yearIn, 0, 1);
            int firstDayInWeek = tmpCal.get(7);
            if (firstDayInWeek == 1) {
                return weekInCalLastYear;
            }
            return weekInCalLastYear - 1;
        }
        return weekInCalLastYear;
    }

    private int yearInISO(Calendar cal) {
        int theYear = cal.get(1);
        int monthIs = cal.get(2);
        if (monthIs != 0 && monthIs != 11) {
            return theYear;
        }
        int dateIs = cal.get(5);
        if (monthIs == 0) {
            GregorianCalendar dayCal = new GregorianCalendar(Locale.US);
            dayCal.set(theYear, 0, 1);
            int firstDay = dayCal.get(7);
            if (firstDay == 6 && dateIs <= 3) {
                return theYear - 1;
            }
            if (firstDay == 7 && dateIs <= 2) {
                return theYear - 1;
            }
            if (firstDay == 1 && dateIs == 1) {
                return theYear - 1;
            }
        } else {
            GregorianCalendar dayCal = new GregorianCalendar(Locale.US);
            dayCal.set(theYear, 11, 31);
            int lastDay = dayCal.get(7);
            int dif = 31 - dateIs;
            if (lastDay == 2 && dif == 0) {
                return theYear + 1;
            }
            if (lastDay == 3 && dif <= 1) {
                return theYear + 1;
            }
            if (lastDay == 4 && dif <= 2) {
                return theYear + 1;
            }
        }
        return theYear;
    }

    public Date parse(String text) throws ParseException {
        return this.parse(text, true);
    }

    public Date parse(String text, boolean dynamic) throws ParseException {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        return this.myParse(text, pos, dynamic);
    }

    public Date parse(String text, ParsePosition pos) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        Date d = null;
        int startPos = pos.getIndex();
        try {
            d = this.myParse(text, pos, true);
        }
        catch (ParseException e) {
            pos.setIndex(startPos);
        }
        return d;
    }

    public Object parseObject(String source, ParsePosition pos) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        return super.parseObject(source, pos);
    }

    public Object clone() {
        OracleDateFormat format = new OracleDateFormat(this.thisLocale, this.thisTimeZone);
        format.setErrorHandler(this.m_eh);
        return format;
    }

    private Date myParse(String text, ParsePosition pos, boolean dynamic) throws ParseException {
        if (text.indexOf(34) != -1) {
            throw new ParseException("Literal does not match format string", 0);
        }
        int YYRR = -1;
        boolean stopParse = false;
        Calendar cal = this.getCalendar();
        Vector tokenVec = (Vector)this.tokenList.clone();
        int posBeginAt = pos.getIndex();
        while (!stopParse) {
            boolean fmOn = true;
            boolean fxOn = false;
            boolean bothOn = false;
            boolean puncNotMatch = false;
            boolean allSpecified = true;
            boolean yearConflict = false;
            boolean ADBCConflict = false;
            boolean AMPMConflict = false;
            boolean hourConflict = false;
            boolean monthConflict = false;
            boolean dayOfWeekConflict = false;
            boolean quarterConflict = false;
            boolean DDDJConflict = false;
            int yearVal = -5000;
            int JyearVal = -5000;
            int monthVal = -1;
            int dateVal = 0;
            int hourVal = -1;
            int minuteVal = -1;
            int secondVal = -1;
            int dddVal = 0;
            int sssssVal = -1;
            int quarterVal = -1;
            int AMPMModified = 0;
            int ADBCModified = 0;
            int valDayOfWeek = 0;
            pos.setIndex(posBeginAt);
            String parseString = text;
            int numOfToken = tokenVec.size();
            try {
                int i = 0;
                while (i < numOfToken) {
                    boolean leadingSpaceTrimed = false;
                    DateFormatToken thisToken = (DateFormatToken)tokenVec.elementAt(i);
                    if (!thisToken.getInputAllowed()) {
                        throw new ParseException(thisToken.getValue() + " can't be used as input", pos.getIndex());
                    }
                    if (thisToken instanceof ModifierToken) {
                        if (thisToken.getType() == 100) {
                            fmOn ^= true;
                        } else {
                            fxOn ^= true;
                        }
                        bothOn = fxOn && fmOn;
                    } else if (thisToken instanceof LiteralToken) {
                        if (parseString.length() != 0) {
                            int type = thisToken.getType();
                            int strLen = this.processLiteral(thisToken.getValue(), type, parseString, pos, fxOn);
                            if (strLen == -1) {
                                puncNotMatch = true;
                            } else {
                                parseString = parseString.substring(strLen);
                                pos.setIndex(pos.getIndex() + strLen);
                            }
                        }
                    } else {
                        TimeUnitToken tmpTok = (TimeUnitToken)thisToken;
                        if (tmpTok.getTH() || tmpTok.getSP()) {
                            throw new ParseException("TH and SP can't be used as input", pos.getIndex());
                        }
                        if (!fxOn) {
                            if (parseString.length() > 0 && parseString.charAt(0) == ' ') {
                                leadingSpaceTrimed = true;
                            }
                            parseString = parseString.trim();
                        }
                        int parseLen = parseString.length();
                        int option = thisToken.getType();
                        switch (option) {
                            case 1: 
                            case 5: {
                                int[] ret = this.processADBC(option, parseString, pos, ADBCConflict);
                                ADBCModified = ret[0];
                                ADBCConflict = true;
                                parseString = parseString.substring(ret[1]);
                                pos.setIndex(pos.getIndex() + ret[1]);
                                break;
                            }
                            case 3: 
                            case 6: {
                                int[] ret = this.processADBC(option, parseString, pos, ADBCConflict);
                                ADBCModified = ret[0];
                                ADBCConflict = true;
                                parseString = parseString.substring(ret[1]);
                                pos.setIndex(pos.getIndex() + ret[1]);
                                break;
                            }
                            case 2: 
                            case 28: {
                                int[] ret = this.processAMPM(option, parseString, pos, AMPMConflict);
                                AMPMModified = ret[0];
                                AMPMConflict = true;
                                parseString = parseString.substring(ret[1]);
                                pos.setIndex(pos.getIndex() + ret[1]);
                                break;
                            }
                            case 4: 
                            case 29: {
                                int[] ret = this.processAMPM(option, parseString, pos, AMPMConflict);
                                AMPMModified = ret[0];
                                AMPMConflict = true;
                                parseString = parseString.substring(ret[1]);
                                pos.setIndex(pos.getIndex() + ret[1]);
                                break;
                            }
                            case 8: {
                                if (dayOfWeekConflict) {
                                    throw new ParseException("Day of week may only be specified once", pos.getIndex());
                                }
                                dayOfWeekConflict = true;
                                if (parseLen < 1) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                char c = parseString.charAt(0);
                                if (!Character.isDigit(c)) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                valDayOfWeek = Character.digit(c, 10);
                                if (valDayOfWeek > 7 || valDayOfWeek == 0) {
                                    throw new ParseException("Not a valid day for the week", pos.getIndex());
                                }
                                parseString = parseString.substring(1);
                                pos.setIndex(pos.getIndex() + 1);
                                break;
                            }
                            case 9: {
                                if (dayOfWeekConflict) {
                                    throw new ParseException("Day of week may only be specified once", pos.getIndex());
                                }
                                dayOfWeekConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                valDayOfWeek = this.checkArray(this.WeekDayInFull, 7, parseString, pos);
                                if (valDayOfWeek == 0) {
                                    throw new ParseException("Not a valid day of week", pos.getIndex());
                                }
                                int plen = pos.getIndex() - startPos;
                                parseString = parseString.substring(plen);
                                break;
                            }
                            case 12: {
                                if (dayOfWeekConflict) {
                                    throw new ParseException("Day of week may only be specified once", pos.getIndex());
                                }
                                dayOfWeekConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                valDayOfWeek = this.checkArray(this.WeekDayInAbbr, 7, parseString, pos);
                                if (valDayOfWeek == 0) {
                                    throw new ParseException("Not a valid day of week", pos.getIndex());
                                }
                                int plen = pos.getIndex() - startPos;
                                parseString = parseString.substring(plen);
                                break;
                            }
                            case 10: {
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int len = this.readAtMost(parseString, 2);
                                if (len == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (len != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && len != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, len);
                                int val = new Integer(tmp);
                                if (val > 31 || val == 0) {
                                    throw new ParseException("Day of month must be between 1 and last day of month", pos.getIndex());
                                }
                                dateVal = val;
                                parseString = parseString.substring(len);
                                pos.setIndex(pos.getIndex() + len);
                                break;
                            }
                            case 11: {
                                if (DDDJConflict) {
                                    throw new ParseException("Format code appears twice", pos.getIndex());
                                }
                                DDDJConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int len = this.readAtMost(parseString, 3);
                                if (len == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (len != 3) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && len != 3) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, len);
                                int val = new Integer(tmp);
                                if (val > 366 || val == 0) {
                                    throw new ParseException("Day of year must be between 1 and last day of year", pos.getIndex());
                                }
                                dddVal = val;
                                parseString = parseString.substring(len);
                                pos.setIndex(pos.getIndex() + len);
                                break;
                            }
                            case 15: 
                            case 16: 
                            case 17: {
                                int rlen;
                                if (hourConflict) {
                                    throw new ParseException("Hour may only be specified once", pos.getIndex());
                                }
                                hourConflict = true;
                                if (option == 17) {
                                    if (AMPMConflict) {
                                        throw new ParseException("Format code appears twice", pos.getIndex());
                                    }
                                    AMPMConflict = true;
                                }
                                if ((rlen = this.readAtMost(parseString, 2)) == 0) {
                                    if (parseLen == 0) {
                                        if (!fxOn) {
                                            hourVal = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                int val = new Integer(tmp);
                                if (option == 17) {
                                    if (val > 23) {
                                        throw new ParseException("Hour must be between 0 and 23", pos.getIndex());
                                    }
                                } else if (val == 0 || val > 12) {
                                    throw new ParseException("Hour must be between 1 and 12", pos.getIndex());
                                }
                                hourVal = val;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 23: {
                                if (DDDJConflict) {
                                    throw new ParseException("Julian date precludes use of day of year", pos.getIndex());
                                }
                                DDDJConflict = true;
                                int rlen = this.readAtMost(parseString, 7);
                                if (rlen == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 7) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 7) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                int fourYears = 1461;
                                String tmpStr = parseString.substring(0, rlen);
                                int jDay = new Integer(tmpStr);
                                if (jDay < 1721424) {
                                    if (jDay < 1826) {
                                        JyearVal = (jDay - 1) / 365 - 4712;
                                        dddVal = jDay - (jDay - 1) / 365 * 365;
                                    } else {
                                        int tmp1 = ((jDay -= 1826) - 1) / fourYears;
                                        int tmp2 = jDay - tmp1 * fourYears;
                                        tmp1 = tmp1 * 4 + 5 - 4712;
                                        if (tmp2 <= 365) {
                                            JyearVal = tmp1;
                                            dddVal = tmp2;
                                        } else if (tmp2 <= 730) {
                                            JyearVal = tmp1 + 1;
                                            dddVal = tmp2 - 365;
                                        } else if (tmp2 <= 1095) {
                                            JyearVal = tmp1 + 2;
                                            dddVal = tmp2 - 730;
                                        } else {
                                            JyearVal = tmp1 + 3;
                                            dddVal = tmp2 - 1095;
                                        }
                                    }
                                    if (JyearVal == 0) {
                                        throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                    }
                                } else if (jDay < 2299161) {
                                    int tmp1 = ((jDay -= 1721423) - 1) / fourYears;
                                    int tmp2 = jDay - tmp1 * fourYears;
                                    JyearVal = tmp1 * 4;
                                    int tmp3 = tmp2 / 365;
                                    JyearVal += tmp3 + 1;
                                    dddVal = tmp2 - tmp3 * 365;
                                } else if (jDay == 2299161) {
                                    JyearVal = 1582;
                                    dddVal = 288;
                                } else {
                                    int fourHundYears = 146097;
                                    int tmp1 = ((jDay -= 1721423) - 1) / fourHundYears;
                                    int tmp2 = jDay - tmp1 * fourHundYears;
                                    JyearVal = tmp1 * 400;
                                    tmp1 = (tmp2 - 1) / 36524;
                                    if (tmp1 == 4) {
                                        --tmp1;
                                    }
                                    JyearVal += tmp1 * 100;
                                    tmp2 -= tmp1 * 36524;
                                    tmp1 = (tmp2 - 1) / fourYears;
                                    JyearVal += tmp1 * 4;
                                    int tmp3 = (tmp2 -= tmp1 * fourYears) / 365;
                                    JyearVal += tmp3 + 1;
                                    dddVal = tmp2 - tmp3 * 365 - 2;
                                }
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 24: {
                                int rlen = this.readAtMost(parseString, 2);
                                if (rlen == 0) {
                                    if (parseLen == 0) {
                                        if (!fxOn) {
                                            minuteVal = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                int val = new Integer(tmp);
                                if (val > 59) {
                                    throw new ParseException("Minute must be between 0 and 59", pos.getIndex());
                                }
                                minuteVal = val;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 25: {
                                if (monthConflict) {
                                    throw new ParseException("Month may only be specified once", pos.getIndex());
                                }
                                monthConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int rlen = this.readAtMost(parseString, 2);
                                if (rlen == 0) {
                                    if (fxOn) {
                                        throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                    }
                                    int startPos = pos.getIndex();
                                    monthVal = this.checkArray(this.MonthNameInFull, 12, parseString, pos);
                                    if (monthVal != 0) {
                                        parseString = parseString.substring(pos.getIndex() - startPos);
                                        --monthVal;
                                        break;
                                    }
                                    monthVal = this.checkArray(this.MonthNameInAbbr, 12, parseString, pos);
                                    if (monthVal != 0) {
                                        parseString = parseString.substring(pos.getIndex() - startPos);
                                        --monthVal;
                                        break;
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                int val = new Integer(tmp);
                                if (val == 0 || val > 12) {
                                    throw new ParseException("Month must be between 1 and 12", pos.getIndex());
                                }
                                monthVal = val - 1;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 26: {
                                if (monthConflict) {
                                    throw new ParseException("Month may only be specified once", pos.getIndex());
                                }
                                monthConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                if (fxOn ? (monthVal = this.checkArray(this.MonthNameInAbbr, 12, parseString, pos)) == 0 : (monthVal = this.checkArray(this.MonthNameInFull, 12, parseString, pos)) == 0 && (monthVal = this.checkArray(this.MonthNameInAbbr, 12, parseString, pos)) == 0) {
                                    throw new ParseException("Not a valid month", startPos);
                                }
                                --monthVal;
                                parseString = parseString.substring(pos.getIndex() - startPos);
                                break;
                            }
                            case 27: {
                                if (monthConflict) {
                                    throw new ParseException("Month may only be specified once", pos.getIndex());
                                }
                                monthConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                monthVal = this.checkArray(this.MonthNameInFull, 12, parseString, pos);
                                if (monthVal == 0) {
                                    if (fxOn) {
                                        throw new ParseException("Not a valid month", startPos);
                                    }
                                    monthVal = this.checkArray(this.MonthNameInAbbr, 12, parseString, pos);
                                    if (monthVal == 0) {
                                        throw new ParseException("Not a valid month", startPos);
                                    }
                                }
                                --monthVal;
                                parseString = parseString.substring(pos.getIndex() - startPos);
                                break;
                            }
                            case 31: {
                                if (monthConflict) {
                                    throw new ParseException("Month may only be specified once", pos.getIndex());
                                }
                                monthConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                monthVal = this.checkArray(DateConstants.MonthInRoman, 12, parseString, pos);
                                if (monthVal == 0) {
                                    throw new ParseException("Not a valid month", startPos);
                                }
                                --monthVal;
                                parseString = parseString.substring(pos.getIndex() - startPos);
                                break;
                            }
                            case 30: {
                                if (quarterConflict) {
                                    throw new ParseException("Quarter may only be specified once", pos.getIndex());
                                }
                                quarterConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                char c = parseString.charAt(0);
                                if (!Character.isDigit(c)) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                quarterVal = Character.digit(c, 10);
                                if (quarterVal > 4 || quarterVal == 0) {
                                    throw new ParseException("Not a valid quarter", pos.getIndex());
                                }
                                --quarterVal;
                                parseString = parseString.substring(1);
                                pos.setIndex(pos.getIndex() + 1);
                                break;
                            }
                            case 32: 
                            case 33: {
                                int rlen;
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                if (!fxOn && option == 32) {
                                    YYRR = i;
                                }
                                int maxrlen = 2;
                                if (option == 33) {
                                    maxrlen = 4;
                                }
                                if ((rlen = this.readAtMost(parseString, maxrlen)) == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != maxrlen) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != maxrlen) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                int sTwoDigitY = new Integer(tmp);
                                Calendar rightNow = this.getCalendar();
                                rightNow.setTime(new Date());
                                int thisYear = rightNow.get(1);
                                int lastTwoDigit = thisYear % 100;
                                int firstTwoDigit = thisYear / 100;
                                if (option == 33) {
                                    if (sTwoDigitY > 99 || rlen > 2) {
                                        yearVal = sTwoDigitY;
                                        parseString = parseString.substring(rlen);
                                        pos.setIndex(pos.getIndex() + rlen);
                                        break;
                                    }
                                    sTwoDigitY %= 100;
                                }
                                if (lastTwoDigit > 49 && sTwoDigitY < 50) {
                                    ++firstTwoDigit;
                                }
                                if (lastTwoDigit < 50 && sTwoDigitY > 49) {
                                    --firstTwoDigit;
                                }
                                yearVal = firstTwoDigit * 100 + sTwoDigitY;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 35: {
                                int rlen = this.readAtMost(parseString, 2);
                                if (rlen == 0) {
                                    if (parseLen == 0) {
                                        if (!fxOn) {
                                            secondVal = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                secondVal = new Integer(tmp);
                                if (secondVal > 59) {
                                    throw new ParseException("Second of minute must be between 0 and 59", pos.getIndex());
                                }
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 36: {
                                int rlen = this.readAtMost(parseString, 5);
                                if (rlen == 0) {
                                    if (parseLen == 0) {
                                        if (!fxOn) {
                                            sssssVal = -1;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", pos.getIndex());
                                }
                                if (rlen != 5) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmp = parseString.substring(0, rlen);
                                sssssVal = new Integer(tmp);
                                if (sssssVal > 86399) {
                                    throw new ParseException("Second of day must be between 0 and 86399", pos.getIndex());
                                }
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 37: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                if (ADBCConflict) {
                                    throw new ParseException("Signed year precludes use of BC/AD", pos.getIndex());
                                }
                                yearConflict = true;
                                ADBCConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input string not long enough for date format", pos.getIndex());
                                }
                                boolean bcYear = false;
                                char firstc = parseString.charAt(0);
                                if (!leadingSpaceTrimed && firstc != '-') {
                                    allSpecified = false;
                                }
                                if (firstc == '-') {
                                    bcYear = true;
                                    parseString = parseString.substring(1);
                                } else if (fmOn && fxOn) {
                                    if (firstc == ' ') {
                                        parseString = parseString.substring(1);
                                    } else {
                                        throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                    }
                                }
                                int startPos = pos.getIndex();
                                yearVal = this.processCommaYear(parseString, pos, fxOn && fmOn);
                                if (yearVal == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                int rlen = pos.getIndex() - startPos;
                                if (rlen != 5) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                if (bcYear) {
                                    yearVal = -yearVal;
                                }
                                parseString = parseString.substring(rlen);
                                break;
                            }
                            case 39: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                if (ADBCConflict) {
                                    throw new ParseException("Signed year precludes use of BC/AD", pos.getIndex());
                                }
                                yearConflict = true;
                                ADBCConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input string not long enough for date format", pos.getIndex());
                                }
                                boolean bcYear = false;
                                char firstc = parseString.charAt(0);
                                if (!leadingSpaceTrimed && firstc != '-') {
                                    allSpecified = false;
                                }
                                if (firstc == '-') {
                                    bcYear = true;
                                    pos.setIndex(pos.getIndex() + 1);
                                    parseString = parseString.substring(1);
                                } else if (fmOn && fxOn) {
                                    if (firstc == ' ') {
                                        parseString = parseString.substring(1);
                                    } else {
                                        throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                    }
                                }
                                int rlen = this.readAtMost(parseString, 4);
                                if (rlen == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                if (rlen != 4) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 4) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmpStr = parseString.substring(0, rlen);
                                yearVal = new Integer(tmpStr);
                                if (yearVal == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                if (bcYear) {
                                    yearVal = -yearVal;
                                }
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 42: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int rlen = this.readAtMost(parseString, 1);
                                if (rlen == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                char c = parseString.charAt(0);
                                int lval = Character.digit(c, 10);
                                Calendar tmpCal = this.getCalendar();
                                tmpCal.setTime(new Date());
                                int yval = tmpCal.get(1);
                                yearVal = yval / 10 * 10 + lval;
                                parseString = parseString.substring(1);
                                pos.setIndex(pos.getIndex() + 1);
                                break;
                            }
                            case 43: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int startPos = pos.getIndex();
                                yearVal = this.processCommaYear(parseString, pos, fxOn && fmOn);
                                if (yearVal == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                int rlen = pos.getIndex() - startPos;
                                if (rlen != 5) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                parseString = parseString.substring(rlen);
                                break;
                            }
                            case 45: {
                                int rlen;
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                if (!fxOn) {
                                    YYRR = i;
                                }
                                if ((rlen = this.readAtMost(parseString, 2)) == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                if (rlen != 2) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmpStr = parseString.substring(0, rlen);
                                int lval = new Integer(tmpStr);
                                Calendar tmpCal = this.getCalendar();
                                tmpCal.setTime(new Date());
                                int fval = tmpCal.get(1);
                                yearVal = fval / 100 * 100 + lval;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 46: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int rlen = this.readAtMost(parseString, 3);
                                if (rlen == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                if (rlen != 3) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 3) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmpStr = parseString.substring(0, rlen);
                                int lval = new Integer(tmpStr);
                                Calendar tmpCal = this.getCalendar();
                                tmpCal.setTime(new Date());
                                int fval = tmpCal.get(1);
                                yearVal = fval / 1000 * 1000 + lval;
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            case 47: {
                                if (yearConflict) {
                                    throw new ParseException("Year may only be specified once", pos.getIndex());
                                }
                                yearConflict = true;
                                if (parseLen == 0) {
                                    throw new ParseException("Input value not long enough for date format", pos.getIndex());
                                }
                                int rlen = this.readAtMost(parseString, 4);
                                if (rlen == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                if (rlen != 4) {
                                    allSpecified = false;
                                }
                                if (puncNotMatch && !allSpecified) {
                                    throw new ParseException("Literal does not match format string", pos.getIndex());
                                }
                                if (bothOn && rlen != 4) {
                                    throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
                                }
                                String tmpStr = parseString.substring(0, rlen);
                                yearVal = new Integer(tmpStr);
                                if (yearVal == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
                                }
                                parseString = parseString.substring(rlen);
                                pos.setIndex(pos.getIndex() + rlen);
                                break;
                            }
                            default: {
                                System.out.println("Shouldn't be here at all!");
                            }
                        }
                    }
                    ++i;
                }
                if (parseString.length() != 0) {
                    throw new ParseException("Date format picture ends before converting entire input string", 0);
                }
                cal = this.checkIntegrity(yearVal, JyearVal, quarterVal, monthVal, dateVal, hourVal, minuteVal, secondVal, dddVal, valDayOfWeek, sssssVal, ADBCModified, AMPMModified, dynamic);
            }
            catch (ParseException e) {
                if (YYRR == -1) {
                    throw e;
                }
                DateFormatToken thisToken = (DateFormatToken)tokenVec.elementAt(YYRR);
                int newTokenType = 47;
                if (thisToken.getType() == 32) {
                    newTokenType = 33;
                }
                TimeUnitToken newToken = new TimeUnitToken(newTokenType, thisToken.getValue(), thisToken.getCase(), DateConstants.InputAllowed[newTokenType]);
                tokenVec.setElementAt(newToken, YYRR);
                YYRR = -1;
                continue;
            }
            return cal.getTime();
        }
        return cal.getTime();
    }

    private Calendar checkIntegrity(int yearVal, int JyearVal, int quarterVal, int monthVal, int dateVal, int hourVal, int minuteVal, int secondVal, int dddVal, int valDayOfWeek, int sssssVal, int ADBCModified, int AMPMModified, boolean dynamic) throws ParseException {
        int dum;
        int retYear = yearVal;
        int retQuarter = quarterVal;
        int retMonth = monthVal;
        int retDate = dateVal;
        int retHour = hourVal;
        int retMinute = minuteVal;
        int retSecond = secondVal;
        if (JyearVal != -5000 && yearVal != -5000 && yearVal != JyearVal) {
            throw new ParseException("Year conflicts with Julian date", 0);
        }
        if (JyearVal != -5000 && yearVal == -5000) {
            retYear = JyearVal;
        }
        if (retYear > 0 && (ADBCModified == 5 || ADBCModified == 6)) {
            retYear = -retYear;
        }
        Calendar calNow = this.getCalendar();
        if (retYear == -5000) {
            retYear = dynamic ? calNow.get(1) : 1900;
        }
        if (dddVal != 0) {
            int tmpDate;
            int tmpQtr;
            int tmpMon;
            int janEnd = 31;
            int febEnd = 59;
            int marEnd = 90;
            int aprEnd = 120;
            int mayEnd = 151;
            int junEnd = 181;
            int julEnd = 212;
            int augEnd = 243;
            int sepEnd = 273;
            int octEnd = 304;
            int novEnd = 334;
            int decEnd = 365;
            if (new GregorianCalendar().isLeapYear(retYear)) {
                ++febEnd;
                ++marEnd;
                ++aprEnd;
                ++mayEnd;
                ++junEnd;
                ++julEnd;
                ++augEnd;
                ++sepEnd;
                ++octEnd;
                ++novEnd;
                ++decEnd;
            }
            if (dddVal <= janEnd) {
                tmpMon = 0;
                tmpQtr = 0;
                tmpDate = dddVal;
            } else if (dddVal <= febEnd) {
                tmpMon = 1;
                tmpQtr = 0;
                tmpDate = dddVal - janEnd;
            } else if (dddVal <= marEnd) {
                tmpMon = 2;
                tmpQtr = 0;
                tmpDate = dddVal - febEnd;
            } else if (dddVal <= aprEnd) {
                tmpMon = 3;
                tmpQtr = 1;
                tmpDate = dddVal - marEnd;
            } else if (dddVal <= mayEnd) {
                tmpMon = 4;
                tmpQtr = 1;
                tmpDate = dddVal - aprEnd;
            } else if (dddVal <= junEnd) {
                tmpMon = 5;
                tmpQtr = 1;
                tmpDate = dddVal - mayEnd;
            } else if (dddVal <= julEnd) {
                tmpMon = 6;
                tmpQtr = 2;
                tmpDate = dddVal - junEnd;
            } else if (dddVal <= augEnd) {
                tmpMon = 7;
                tmpQtr = 2;
                tmpDate = dddVal - julEnd;
            } else if (dddVal <= sepEnd) {
                tmpMon = 8;
                tmpQtr = 2;
                tmpDate = dddVal - augEnd;
            } else if (dddVal <= octEnd) {
                tmpMon = 9;
                tmpQtr = 3;
                tmpDate = dddVal - sepEnd;
            } else if (dddVal <= novEnd) {
                tmpMon = 10;
                tmpQtr = 3;
                tmpDate = dddVal - octEnd;
            } else if (dddVal <= decEnd) {
                tmpMon = 11;
                tmpQtr = 3;
                tmpDate = dddVal - novEnd;
            } else {
                throw new ParseException("Day of year must be between 1 and the last day of the year", 0);
            }
            if (retQuarter != -1 && retQuarter != tmpQtr) {
                throw new ParseException("Quarter conflicts with Julian date", 0);
            }
            retQuarter = tmpQtr;
            if (retMonth != -1 && retMonth != tmpMon) {
                throw new ParseException("Month of year conflicts with Julian date", 0);
            }
            retMonth = tmpMon;
            if (retDate != 0 && retDate != tmpDate) {
                throw new ParseException("Date of month conflicts with Julian date", 0);
            }
            retDate = tmpDate;
        }
        if (retMonth == -1) {
            retMonth = retQuarter != -1 ? 3 * retQuarter : (dynamic ? calNow.get(2) : 0);
        } else if (retQuarter != -1 && retQuarter != retMonth / 3) {
            throw new ParseException("Month not valid for quarter specified", 0);
        }
        if (retDate == 0) {
            retDate = 1;
        }
        if (retMonth == 1 && retDate > 29) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (retDate == 31 && (retMonth == 3 || retMonth == 5 || retMonth == 8 || retMonth == 10)) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (retMonth == 1 && retDate > 28 && !new GregorianCalendar().isLeapYear(retYear)) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (AMPMModified != 0 && (AMPMModified == 28 || AMPMModified == 29) && retHour != 12 && retHour != -1) {
            retHour += 12;
        }
        if (sssssVal != -1) {
            int ssHour = sssssVal / 3600;
            int ssMinute = sssssVal % 3600 / 60;
            int ssSecond = sssssVal % 3600 % 60;
            if (retHour == -1) {
                retHour = ssHour;
            } else if (retHour != ssHour) {
                throw new ParseException("Hour conflicts with second of hour", 0);
            }
            if (retMinute == -1) {
                retMinute = ssMinute;
            } else if (retMinute != ssMinute) {
                throw new ParseException("Minute conflicts with second of hour", 0);
            }
            if (retSecond == -1) {
                retSecond = ssSecond;
            } else if (retSecond != ssSecond) {
                throw new ParseException("Second conflicts with second of hour", 0);
            }
        }
        if (retHour == -1) {
            retHour = 0;
        }
        if (retMinute == -1) {
            retMinute = 0;
        }
        if (retSecond == -1) {
            retSecond = 0;
        }
        Calendar cal = this.getCalendar();
        cal.clear();
        cal.set(retYear, retMonth, retDate, retHour, retMinute, retSecond);
        if (valDayOfWeek != 0 && (dum = cal.get(7)) != valDayOfWeek) {
            throw new ParseException("Day of week conflicts with Julian date", 0);
        }
        return cal;
    }

    private int processCommaYear(String pstring, ParsePosition pos, boolean fmfxOn) throws ParseException {
        String tmpStr2;
        if (fmfxOn && pstring.length() < 5) {
            throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
        }
        int plen1 = this.readAtMost(pstring, 4);
        if (plen1 == 0) {
            throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", pos.getIndex());
        }
        String tmpStr1 = pstring.substring(0, plen1);
        int fval = new Integer(tmpStr1);
        pos.setIndex(pos.getIndex() + plen1);
        if (plen1 == 4) {
            if (pstring.length() > 4 && pstring.charAt(4) == this.m_groupingSeparator) {
                pos.setIndex(pos.getIndex() + 1);
                return fval;
            }
            if (!fmfxOn) {
                return fval;
            }
            if (pstring.charAt(5) != this.m_groupingSeparator) {
                throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
            }
        }
        if ((tmpStr2 = pstring.substring(plen1)).length() == 0) {
            return fval;
        }
        if (tmpStr2.charAt(0) != this.m_groupingSeparator) {
            if (fmfxOn) {
                throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
            }
            return fval;
        }
        tmpStr2 = tmpStr2.substring(1);
        pos.setIndex(pos.getIndex() + 1);
        int plen2 = this.readAtMost(tmpStr2, 4 - plen1);
        if (fmfxOn && plen2 != 4 - plen1) {
            throw new ParseException("The numeric value does not match the length of the format item", pos.getIndex());
        }
        if (plen2 == 0) {
            return fval;
        }
        tmpStr2 = tmpStr2.substring(0, plen2);
        tmpStr1 = tmpStr1 + tmpStr2;
        int sval = new Integer(tmpStr1);
        pos.setIndex(pos.getIndex() + plen2);
        return sval;
    }

    private int processLiteral(String compareStr, int type, String pstring, ParsePosition pos, boolean fxOn) throws ParseException {
        if (compareStr.length() == 0) {
            return 0;
        }
        if (type == 2000) {
            int puncPos = 0;
            int pstrLen = pstring.length();
            while (puncPos < pstrLen && !Character.isLetterOrDigit(pstring.charAt(puncPos))) {
                ++puncPos;
            }
            String puncStr = pstring.substring(0, puncPos);
            int plen = puncStr.length();
            String cStr = compareStr;
            int clen = cStr.length();
            if (!fxOn) {
                if (plen > clen) {
                    if (puncStr.trim().length() <= clen) {
                        return plen;
                    }
                    throw new ParseException("literal does not match format string", pos.getIndex());
                }
                if (plen > 0) {
                    return plen;
                }
                return -1;
            }
            if (!puncStr.equals(cStr)) {
                throw new ParseException("literal does not match format string", pos.getIndex());
            }
            return plen;
        }
        int cstrLen = compareStr.length();
        if (pstring.length() < cstrLen) {
            throw new ParseException("Literal does not match format string", pos.getIndex());
        }
        String litStr = pstring.substring(0, cstrLen);
        if (!litStr.equalsIgnoreCase(compareStr)) {
            throw new ParseException("Literal does not match format string", pos.getIndex());
        }
        return cstrLen;
    }

    private int readAtMost(String pstring, int len) {
        int slen = len;
        if (pstring.length() < len) {
            slen = pstring.length();
        }
        int i = 0;
        while (i < slen) {
            char c = pstring.charAt(i);
            if (!Character.isDigit(c)) {
                return i;
            }
            ++i;
        }
        return slen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] processADBC(int option, String pstring, ParsePosition pos, boolean conflict) throws ParseException {
        int[] retval = new int[]{0, -1};
        if (conflict) {
            throw new ParseException("Format code appears twice", pos.getIndex());
        }
        if (option == 1 || option == 5) {
            if (pstring.startsWith(this.ErasUpperCaseWithPeriods[1])) {
                retval[0] = 1;
                retval[1] = this.ErasUpperCaseWithPeriods[1].length();
                return retval;
            } else if (pstring.startsWith(this.ErasLowerCaseWithPeriods[1])) {
                retval[0] = 1;
                retval[1] = this.ErasLowerCaseWithPeriods[1].length();
                return retval;
            } else if (pstring.startsWith(this.ErasUpperCaseWithPeriods[0])) {
                retval[0] = 5;
                retval[1] = this.ErasUpperCaseWithPeriods[0].length();
                return retval;
            } else {
                if (!pstring.startsWith(this.ErasLowerCaseWithPeriods[0])) throw new ParseException("B.C. or A.D. required", pos.getIndex());
                retval[0] = 5;
                retval[1] = this.ErasLowerCaseWithPeriods[0].length();
            }
            return retval;
        } else if (pstring.startsWith(this.ErasUpperCase[1])) {
            retval[0] = 3;
            retval[1] = this.ErasUpperCase[1].length();
            return retval;
        } else if (pstring.startsWith(this.ErasLowerCase[1])) {
            retval[0] = 3;
            retval[1] = this.ErasLowerCase[1].length();
            return retval;
        } else if (pstring.startsWith(this.ErasUpperCase[0])) {
            retval[0] = 6;
            retval[1] = this.ErasUpperCase[0].length();
            return retval;
        } else {
            if (!pstring.startsWith(this.ErasLowerCase[0])) throw new ParseException("BC or AD required", pos.getIndex());
            retval[0] = 6;
            retval[1] = this.ErasLowerCase[0].length();
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] processAMPM(int option, String pstring, ParsePosition pos, boolean conflict) throws ParseException {
        int[] retval = new int[]{0, -1};
        if (conflict) {
            throw new ParseException("Format code appears twice", pos.getIndex());
        }
        if (option == 2 || option == 28) {
            if (pstring.startsWith(this.AmPmUpperCaseWithPeriods[0])) {
                retval[0] = 2;
                retval[1] = this.AmPmUpperCaseWithPeriods[0].length();
                return retval;
            } else if (pstring.startsWith(this.AmPmLowerCaseWithPeriods[0])) {
                retval[0] = 2;
                retval[1] = this.AmPmLowerCaseWithPeriods[0].length();
                return retval;
            } else if (pstring.startsWith(this.AmPmUpperCaseWithPeriods[1])) {
                retval[0] = 28;
                retval[1] = this.AmPmUpperCaseWithPeriods[1].length();
                return retval;
            } else {
                if (!pstring.startsWith(this.AmPmLowerCaseWithPeriods[1])) throw new ParseException("A.M. or P.M. required", pos.getIndex());
                retval[0] = 28;
                retval[1] = this.AmPmLowerCaseWithPeriods[1].length();
            }
            return retval;
        } else if (pstring.startsWith(this.AmPmUpperCase[0])) {
            retval[0] = 4;
            retval[1] = this.AmPmUpperCase[0].length();
            return retval;
        } else if (pstring.startsWith(this.AmPmLowerCase[0])) {
            retval[0] = 4;
            retval[1] = this.AmPmLowerCase[0].length();
            return retval;
        } else if (pstring.startsWith(this.AmPmUpperCase[1])) {
            retval[0] = 29;
            retval[1] = this.AmPmUpperCase[1].length();
            return retval;
        } else {
            if (!pstring.startsWith(this.AmPmLowerCase[1])) throw new ParseException("AM or PM required", pos.getIndex());
            retval[0] = 29;
            retval[1] = this.AmPmLowerCase[1].length();
        }
        return retval;
    }

    private int checkArray(String[] arr, int arrLen, String pstring, ParsePosition pos) {
        int len = pstring.length();
        int maxMatchLen = 0;
        int matchPos = 0;
        int i = 0;
        while (i < arrLen) {
            String tmp;
            String str = arr[i].trim();
            int slen = str.length();
            if (len >= slen && (tmp = pstring.substring(0, slen)).equalsIgnoreCase(str) && slen > maxMatchLen) {
                maxMatchLen = slen;
                matchPos = i;
            }
            ++i;
        }
        if (maxMatchLen == 0) {
            return 0;
        }
        pos.setIndex(pos.getIndex() + maxMatchLen);
        return matchPos + 1;
    }

    private void $init$() {
        this.m_eh = null;
        this.tokenList = new Vector();
        this.formatString = "";
        this.m_groupingSeparator = (char)44;
    }
}

