/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;

public class LazyScrollPane
extends JScrollPane {
    private static final int HORIZONTAL_GAP = 10;
    private static final int DEFAULT_THRESHOLD = 1000;
    private MouseDelayListener m_mouseDelayListener;
    private JComponent m_component;
    private JList m_list;
    private JScrollBar m_verticalScrollBar;
    private int m_intThreshold;
    private int m_intRowHeight;
    private MouseEvent m_mouseEvent;
    private ResourceBundle m_bundle;
    private JWindow m_window;
    private JPanel m_panel;
    private boolean m_blnShowTooltip;
    private Point m_location;
    private JToolTip m_toolTip;

    private void $init$() {
        this.m_mouseDelayListener = new MouseDelayListener();
        this.m_component = null;
        this.m_list = null;
        this.m_verticalScrollBar = null;
        this.m_intThreshold = 1000;
        this.m_intRowHeight = -1;
        this.m_mouseEvent = null;
        this.m_bundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
        this.m_window = null;
        this.m_panel = null;
        this.m_blnShowTooltip = true;
        this.m_location = null;
        this.m_toolTip = null;
    }

    public LazyScrollPane(JComponent component, int intThreshold) {
        super(component);
        this.$init$();
        this.m_intThreshold = intThreshold;
        this.m_component = component;
        if (component instanceof JList) {
            this.m_list = (JList)component;
        }
        this.setLazyModel();
    }

    public LazyScrollPane(JComponent component) {
        this(component, 1000);
    }

    public boolean isShowTooltip() {
        return this.m_blnShowTooltip;
    }

    public void setShowTooltip(boolean blnShowTooltip) {
        this.m_blnShowTooltip = blnShowTooltip;
    }

    private void setLazyModel() {
        LazyModel lazyModel = new LazyModel();
        this.getVerticalScrollBar().addMouseListener(this.m_mouseDelayListener);
        this.getVerticalScrollBar().setModel(lazyModel);
        this.updateUI();
        this.m_verticalScrollBar = this.getVerticalScrollBar();
    }

    private JWindow getWindow() {
        if (this.m_window == null) {
            this.m_window = new JWindow();
            this.m_window.getContentPane().add(this.getPanel());
        }
        return this.m_window;
    }

    private JPanel getPanel() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel(new BorderLayout());
        }
        return this.m_panel;
    }

    private int getX(JScrollBar scrollBar, JComponent component) {
        if (scrollBar != null) {
            if (scrollBar.getValue() + scrollBar.getVisibleAmount() == scrollBar.getMaximum()) {
                return this.getY(scrollBar, component);
            }
            return scrollBar.getValue() / (this.getRowHeight(component) - 1) + 1;
        }
        return -1;
    }

    private int getY(JScrollBar scrollBar, JComponent component) {
        if (scrollBar != null) {
            return scrollBar.getMaximum() / (this.getRowHeight(component) - 1);
        }
        return -1;
    }

    private int getRowHeight(JComponent component) {
        Rectangle rectangle;
        if (this.m_intRowHeight == -1 && component != null && component instanceof JList && (rectangle = ((JList)component).getCellBounds(0, 0)) != null) {
            this.m_intRowHeight = rectangle.height + 1;
        }
        return this.m_intRowHeight;
    }

    private String getXofY(JScrollBar scrollBar) {
        if (scrollBar != null && this.m_list != null) {
            Object[] formatArgs = new String[]{Integer.toString(this.getX(scrollBar, this.m_component)), Integer.toString(this.getY(scrollBar, this.m_component))};
            return MessageFormat.format(this.m_bundle.getString("XofY"), formatArgs);
        }
        return null;
    }

    private Point getInitialTooltipLocation(JWindow window, JScrollBar scrollBar, MouseEvent e) {
        if (window != null && scrollBar != null && scrollBar.isShowing() && e != null) {
            int x = scrollBar.getLocationOnScreen().x - window.getWidth();
            int y = this.getLocationOnScreen().y + e.getY() - this.getRowHeight(this.m_component) / 2;
            return new Point(x - 10, y);
        }
        return null;
    }

    private Point getTooltipLocation(JWindow window, JScrollBar scrollBar) {
        if (window != null && scrollBar != null && scrollBar.isShowing() && this.m_location != null) {
            int x = scrollBar.getLocationOnScreen().x - window.getWidth();
            int y = this.m_location.y;
            return new Point(x - 10, y);
        }
        return null;
    }

    private void updateXofY() {
        this.m_toolTip = new JToolTip();
        this.m_toolTip.setTipText(this.getXofY(this.m_verticalScrollBar));
        this.getPanel().removeAll();
        this.getPanel().add((Component)this.m_toolTip, "Center");
        this.getWindow().pack();
        this.m_location = this.getTooltipLocation(this.getWindow(), this.m_verticalScrollBar);
        if (this.m_location != null) {
            this.getWindow().setLocation(this.m_location);
        }
    }

    static JList ra$m_list(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_list;
    }

    static JWindow mav$getWindow(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.getWindow();
    }

    static JWindow ra$m_window(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_window;
    }

    static JScrollBar ra$m_verticalScrollBar(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_verticalScrollBar;
    }

    static Point mav$getInitialTooltipLocation(LazyScrollPane lazyScrollPane, JWindow jWindow, JScrollBar jScrollBar, MouseEvent mouseEvent) {
        return lazyScrollPane.getInitialTooltipLocation(jWindow, jScrollBar, mouseEvent);
    }

    static void wa$m_location(LazyScrollPane lazyScrollPane, Point point) {
        lazyScrollPane.m_location = point;
    }

    static Point ra$m_location(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_location;
    }

    static void mav$updateXofY(LazyScrollPane lazyScrollPane) {
        lazyScrollPane.updateXofY();
    }

    static JComponent ra$m_component(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_component;
    }

    static int mav$getY(LazyScrollPane lazyScrollPane, JScrollBar jScrollBar, JComponent jComponent) {
        return lazyScrollPane.getY(jScrollBar, jComponent);
    }

    static int ra$m_intThreshold(LazyScrollPane lazyScrollPane) {
        return lazyScrollPane.m_intThreshold;
    }

    class MouseDelayListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.ra$m_list(LazyScrollPane.this) != null) {
                LazyScrollPane.wa$m_location(LazyScrollPane.this, LazyScrollPane.mav$getInitialTooltipLocation(LazyScrollPane.this, LazyScrollPane.ra$m_window(LazyScrollPane.this), LazyScrollPane.ra$m_verticalScrollBar(LazyScrollPane.this), e));
                if (LazyScrollPane.ra$m_location(LazyScrollPane.this) != null) {
                    LazyScrollPane.mav$getWindow(LazyScrollPane.this).setLocation(LazyScrollPane.ra$m_location(LazyScrollPane.this));
                }
                LazyScrollPane.mav$getWindow(LazyScrollPane.this).setVisible(true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.ra$m_list(LazyScrollPane.this) != null) {
                LazyScrollPane.mav$getWindow(LazyScrollPane.this).setVisible(false);
            }
        }

        MouseDelayListener() {
        }
    }

    class LazyModel
    extends DefaultBoundedRangeModel {
        public LazyModel() {
            super(0, 10, 0, 100);
        }

        protected void fireStateChanged() {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.ra$m_list(LazyScrollPane.this) != null) {
                LazyScrollPane.mav$updateXofY(LazyScrollPane.this);
            }
            if (!this.getValueIsAdjusting() || LazyScrollPane.mav$getY(LazyScrollPane.this, LazyScrollPane.ra$m_verticalScrollBar(LazyScrollPane.this), LazyScrollPane.ra$m_component(LazyScrollPane.this)) <= LazyScrollPane.ra$m_intThreshold(LazyScrollPane.this)) {
                super.fireStateChanged();
            }
        }
    }
}

